package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import java.util.List;
import java.util.ArrayList;

public abstract class OFXCommandPage<Bound> implements IOFXPage<Bound> {
  protected String pageName;
  protected IOFXSelProvider<Bound> __selectionProvider;
  protected IOFXPage.IOFXPageConclusion[] conclusions;
  protected int conclusionsAdded = 0;

  public OFXCommandPage(String name, int size) {
    pageName = name;
    conclusions = new IOFXPage.IOFXPageConclusion[size];
  }

  public void conclusion(OFXCommandPageConclusion conc) {
    conclusions[conclusionsAdded] = conc;
    conclusionsAdded++;
  }

  public abstract void initGenPageConclusion();
  public abstract Object pageLoadFunction() throws Exception;
  @Override
  public List<Bound> initPage(IOFXSelProvider<Bound> selRecorder) throws Exception {
    __selectionProvider = selRecorder;

    Object listOrObject = pageLoadFunction();

    // we do not check on element type here, should we?
    if (listOrObject == null) {
      throw new RuntimeException("This can not happen. Pageload of " + pageName + " return null.");

    } else if (listOrObject instanceof List) {
      return (List<Bound>) listOrObject;

    } else {
      List createdList = new ArrayList(1);
      createdList.add(listOrObject);
      return (List<Bound>) createdList;

    }
  }

  @Override
  public void execPageConclusion(IOFXPage.IOFXPageConclusion conclusion) throws OFXChangePageException, OFXJobWorkCanceledException, OFXCommandDoneException, OFXAbortedException, Exception {
    // check before execution
    IOFXPage.IOFXPageConclusion concToExec = null;
    for (IOFXPage.IOFXPageConclusion candidate : conclusions) {
      if (candidate == conclusion) {
        concToExec = candidate;
        break;
      }
    }
    if (concToExec == null) {
      throw new IllegalStateException("" + conclusion + " is not a conclusion of this page " + pageName);
    }

    conclusion.execute();
  }

  @Override
  public IOFXPage.IOFXPageConclusion[] getPageConclusions(IOFXSelProvider<Bound> finalView) {
    __selectionProvider = finalView;
    return conclusions;
  }
  @Override
  public void cmdTerminated(boolean wasChild, boolean inFinalOk, IOFXSelProvider<Bound> __selectionProvider) {
    // empty default impl
  }
  @Override
  public void cmdTerminatedWithPushed(boolean wasChild, boolean inFinalOk, Object pushed, IOFXSelProvider<Bound> __selectionProvider) {
    // empty default impl
  }

  public String dynamicPageTitle() {
    return "";
  }
  @Override
  public String calcDynamicPageTitleAndScopes() {
    calcScopes();
    return dynamicPageTitle();
  }
  @Override
  public String getPageName() {
    return pageName;
  }
  @Override
  public String toString() {
    return super.toString();
  }
}
