package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import org.joda.time.format.DateTimeFormatter;
import javax.xml.transform.TransformerFactory;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.configuration.DefaultConfigurationBuilder;
import org.apache.fop.configuration.Configuration;
import java.io.ByteArrayInputStream;
import org.apache.fop.apps.FopFactoryBuilder;
import java.io.File;
import org.apache.fop.configuration.ConfigurationException;
import org.modellwerkstatt.manmap.runtime.IM3UserEnvironment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.FileOutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import java.io.StringReader;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.MimeConstants;
import javax.xml.transform.Transformer;
import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import org.xml.sax.ContentHandler;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.fop.apps.FOPException;
import javax.xml.transform.TransformerException;
import java.awt.Desktop;
import java.net.URI;
import java.net.URISyntaxException;

/**
 * OFXFop print service is capable of printing in single user environment
 * basically supporting fop for designer templates and fopland templates. 
 * 
 * 
 * 
 * Dan Brighton Autumn 2015
 * 
 * 
 */
public class OFXFatClientFopUserPrintService implements IPrintingServiceImpl {
  public static final DateTimeFormatter dateTimeFormatter = MoWareFormattersFactory.forDateTimePattern("dd.MM.yyyy hh:mm:ss", OFXStringFormatter2.DEFAULT_LOCALE);


  protected static TransformerFactory transFactory;
  protected static FopFactory fopFactory;

  protected boolean useMoFopland;
  protected boolean useTmpDir;
  protected Class<?> classloaderForXslt;
  protected String fallBackFsDirForXslt;
  protected String outputFileDir;
  protected IOFXUserEnvironment userEnvironment;
  private boolean autodetectFonts;


  public OFXFatClientFopUserPrintService(IOFXUserEnvironment userEnv, String classLoadForXslTemplates, String fallBackFsDirForXsltTemplate, String outputPath, boolean useFopland, boolean useTmpDirectory, boolean autodetect) {
    //       should it be printAndOpen()? instead of print?
    //       do not specify full dir name as doc!

    // (1) streams, classLoading or fs access.
    // (2)
    userEnvironment = userEnv;
    fallBackFsDirForXslt = fallBackFsDirForXsltTemplate;
    useMoFopland = useFopland;
    useTmpDir = useTmpDirectory;
    outputFileDir = outputPath;
    autodetectFonts = autodetect;

    try {
      classloaderForXslt = Class.forName(classLoadForXslTemplates);

    } catch (ClassNotFoundException e) {
      classLoadForXslTemplates = null;

    }
  }

  public void gcClean() {
    // Vaadin bug, do not clean up static flieds in single instance !
    classloaderForXslt = null;
    userEnvironment = null;
  }


  public void selfconfigureFopFactory(String fontPath) {
    try {
      // font configuration particularly important for
      // designer templates.
      StringBuilder configString = new StringBuilder();
      configString.append("<fop version=\"2.1\">");
      configString.append("<strict-configuration>true</strict-configuration>");
      configString.append("<strict-validation>true</strict-validation>");
      configString.append("<renderers>");
      configString.append("<renderer mime=\"application/pdf\">");
      configString.append("<fonts>");

      configString.append("<directory>" + fontPath + "</directory>");
      if (autodetectFonts) {
        configString.append("<auto-detect/>");
      }

      configString.append("<substitutions>");
      configString.append("<substitution>");
      configString.append("<from font-family=\"Arial\" />");
      configString.append("<to font-family=\"Helvetica\"/>");
      configString.append("<from font-family=\"Consolas\" />");
      configString.append("<to font-family=\"Courier\"/>");
      configString.append("</substitution>");
      configString.append("</substitutions>");


      configString.append("</fonts>");
      configString.append("</renderer>");
      configString.append("</renderers>");
      configString.append("</fop>");

      if (fopFactory == null) {
        DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
        Configuration cfg;

        cfg = cfgBuilder.build(new ByteArrayInputStream(configString.toString().getBytes()));

        FopFactoryBuilder factoryBuilder = new FopFactoryBuilder(new File(".").toURI()).setConfiguration(cfg);

        fopFactory = factoryBuilder.build();

        // fopFactory.setUserConfig(cfg)
      }
      if (transFactory == null) {
        transFactory = TransformerFactory.newInstance();
      }


    } catch (ConfigurationException ex) {
      throw new RuntimeException("Exception while initializing printing utility: ", ex);

    }
  }


  private static String adjustXmlData(String origXml, IM3UserEnvironment environment) {
    String heading = "<?xml version = '1.0' encoding = 'UTF-8'?>\n<OBJECT>";
    String timestring = dateTimeFormatter.print(DeprecatedServerDateProvider.getSqlServerDateTime());
    String userString = environment.getUserName();
    heading = heading + "<__TIMESTAMP>" + timestring + "</__TIMESTAMP>";
    heading = heading + "<__USER>" + userString + "</__USER>";
    return heading + origXml + "</OBJECT>";
  }

  public String adjustXsltForFopland(BufferedReader reader) throws IOException {
    // Add initial <?xml if it s missing in the template
    StringBuilder content = new StringBuilder();
    String line;
    boolean firstLine = true;

    while ((line = reader.readLine()) != null) {
      if (firstLine) {
        if (!(line.contains("<?xml"))) {
          content.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        }
        firstLine = false;
      }
      content.append(line);
    }
    reader.close();
    String xsltData = content.toString();
    xsltData = xsltData.replaceAll("&amp;#xA0;", "&#xA0;");
    return xsltData;
  }

  private String getBarcode4JPath(String xslt) {
    int startIndex = xslt.indexOf(FoBc4jBarCode.barcodeID);
    int lenBid = FoBc4jBarCode.barcodeID.length();
    if (xslt.charAt(startIndex + lenBid) != '(') {
      throw new RuntimeException("OFXFopUserPrintService barcode 4j substitution: When using BARCODE4J and no java Barcode-Class ist specified, use BARCODE4J(<<path>>) in template. ( missing");
    }
    int stop = xslt.indexOf(")", startIndex + lenBid + 1);
    if (stop < 0) {
      throw new RuntimeException("OFXFopUserPrintService barcode 4j substitution: When using BARCODE4J and no java Barcode-Class ist specified, use BARCODE4J(<<path>>) in template. ) missing");
    }

    return xslt.substring(startIndex + lenBid + 1, stop);
  }

  public String adjustXsltForDesigner(BufferedReader reader, FoBc4jBarCode barcode) throws IOException {
    // read content from xslt file
    StringBuilder content = new StringBuilder();

    String line;
    while ((line = reader.readLine()) != null) {
      // Some fixes for XFO Designer...  line oriented style. ?? might be faster??
      // (1) replace display-align="middle" with display-align="center"
      // (2) replace is-html="true" with empty string

      line = line.replace("display-align=\"middle\"", "display-align=\"center\"");
      line = line.replace("is-html=\"true\"", "");
      content.append(line);
    }
    reader.close();

    String xsltData = content.toString();

    if (barcode != null) {
      xsltData = xsltData.replace(FoBc4jBarCode.barcodeID, barcode.toString());

    } else if (xsltData.contains(FoBc4jBarCode.barcodeID)) {
      // okay, use "internal" mode
      String path = getBarcode4JPath(xsltData);
      barcode = new FoBc4jBarCode(path);
      xsltData = xsltData.replace(FoBc4jBarCode.barcodeID + "(" + path + ")", barcode.toString());
    }
    return xsltData;
  }

  public File renderFop(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode, boolean tempDir) {
    try {
      // Object xml information add on ...
      xmlGraphData = adjustXmlData(xmlGraphData, userEnvironment);

      // load xslt
      BufferedReader reader = null;
      if (classloaderForXslt != null) {
        InputStream xsltSream = classloaderForXslt.getResourceAsStream(xsltTemplateName);
        if (xsltSream != null) {
          reader = new BufferedReader(new InputStreamReader(xsltSream, "UTF-8"));
        }
      }
      if (reader == null) {
        reader = new BufferedReader(new FileReader(new File(fallBackFsDirForXslt + "/" + xsltTemplateName)));
      }


      // In past, template was read in UFT-8
      String xsltData;
      if (useMoFopland) {
        xsltData = adjustXsltForFopland(reader);

      } else {
        xsltData = adjustXsltForDesigner(reader, ((FoBc4jBarCode) barcode));
      }


      // also here, in past, template was read in UTF-8
      String[] fileNameWithEnding = documentFilename.split("\\.");
      File resultingFile;

      if (fileNameWithEnding.length != 2) {
        throw new RuntimeException("Provide a <filname>.<ending> when rendering (<filename>.pdf ?). You provided '" + documentFilename + "'");
      }

      if (tempDir) {
        resultingFile = File.createTempFile(fileNameWithEnding[0], "." + fileNameWithEnding[1]);
      } else {
        resultingFile = new File(outputFileDir + "/" + documentFilename);
      }

      OutputStream pdfOutputStream = new FileOutputStream(resultingFile);

      // okay. render it now
      Source xsltStreamSource = new StreamSource(new StringReader(xsltData));

      // outStream only checked in here.
      Fop fop = fopFactory.newFop(MimeConstants.MIME_PDF, pdfOutputStream);

      // new StreamSource(xsltFile)
      Transformer transformer = transFactory.newTransformer(xsltStreamSource);

      // render
      Source xmlGraphDataStreamSource = new StreamSource(new StringReader(xmlGraphData));

      Result result = new SAXResult((ContentHandler) fop.getDefaultHandler());
      transformer.transform(xmlGraphDataStreamSource, result);

      // do not forget to close outstream ..
      pdfOutputStream.close();
      transformer = null;
      fop = null;

      return resultingFile;
    } catch (TransformerConfigurationException ex) {
      throw new RuntimeException(ex);
    } catch (FOPException fop) {
      throw new RuntimeException(fop);
    } catch (TransformerException ex) {
      throw new RuntimeException(ex);
    } catch (IOException ex) {
      throw new RuntimeException(ex);
    }
  }

  public File render(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode) {
    File resultingFile;
    resultingFile = renderFop(documentFilename, xsltTemplateName, xmlGraphData, barcode, useTmpDir);
    return resultingFile;
  }


  public File renderPrint(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode) {
    File resultingFile;
    resultingFile = renderFop(documentFilename, xsltTemplateName, xmlGraphData, barcode, useTmpDir);
    print(resultingFile);
    return resultingFile;
  }

  public File renderView(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode) {
    File resultingFile;
    resultingFile = renderFop(documentFilename, xsltTemplateName, xmlGraphData, barcode, useTmpDir);
    view(resultingFile);
    return resultingFile;
  }

  public void view(File pdfFile) {
    try {
      Desktop.getDesktop().browse(pdfFile.toURI());
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }

  public void print(File pdfFile) {
    try {
      Desktop.getDesktop().print(pdfFile);
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }

  public void openUrl(String url) {
    try {
      Desktop.getDesktop().browse(new URI(url));
    } catch (IOException e) {
      throw new RuntimeException(e);
    } catch (URISyntaxException e) {
      throw new RuntimeException(e);
    }

  }


  public static void main(String[] args) {
    String dpocumentFilename = "doc.pdf";
    String[] fileNameWithEnding = dpocumentFilename.split("\\.");

    if (fileNameWithEnding.length != 2) {
      throw new RuntimeException("Provide a <filname>.<ending> when rendering (<filename>.pdf ?). You provided '" + dpocumentFilename + "'");
    }
    System.err.println("'" + (fileNameWithEnding[0] + "." + fileNameWithEnding[1]) + "'");
  }

}
