package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */


public class OFXFatClientPrintFactory implements IOFXPrintFactory {
  private static final String WINDOWS_FONT_PATH = "C:/windows/fonts";
  protected IPrintingServiceImpl printService;
  protected String templateClassLoaderFqName;
  protected String fallBackFileSystemTemplateLoadingPath;
  protected String printerOutputPath;
  protected boolean useTmpOutputDir;
  protected boolean useFoplandModfier;
  protected String fontPath;
  protected boolean autodetectFont;



  public OFXFatClientPrintFactory(String templateClassLoaderFqName, String fallBackFileSystemTemplateLoadingPath, String printerOutputPath, boolean useFoplandModifier) {
    this.templateClassLoaderFqName = templateClassLoaderFqName.trim();
    this.fallBackFileSystemTemplateLoadingPath = fallBackFileSystemTemplateLoadingPath.trim();
    this.printerOutputPath = printerOutputPath.trim();
    this.useFoplandModfier = useFoplandModifier;
    this.fontPath = WINDOWS_FONT_PATH;
    this.autodetectFont = true;
    // eg. at.hafina.fwww.data.myrepo
    // eg. /Users/danielstieger/javaware/eFWWS/templates
    // e.g ""
    // false
    // false

    useTmpOutputDir = false;
    if ("".equals(this.printerOutputPath)) {
      useTmpOutputDir = true;
    }
  }

  public OFXFatClientPrintFactory(String templateClassLoaderFqName, String fallBackFileSystemTemplateLoadingPath, String printerOutputPath, boolean useFoplandModifier, String fontPath) {
    this(templateClassLoaderFqName, fallBackFileSystemTemplateLoadingPath, printerOutputPath, useFoplandModifier);

    this.fontPath = fontPath.trim();
    // compatibility fallback
    if ("0".equals(this.fontPath) || "1".equals(this.fontPath) || "".equals(this.fontPath)) {
      this.fontPath = WINDOWS_FONT_PATH;
    }
  }

  public OFXFatClientPrintFactory(String templateClassLoaderFqName, String fallBackFileSystemTemplateLoadingPath, String printerOutputPath, boolean useFoplandModifier, String fontPath, boolean autodetect) {
    this(templateClassLoaderFqName, fallBackFileSystemTemplateLoadingPath, printerOutputPath, useFoplandModifier, fontPath);
    this.autodetectFont = autodetect;
  }

  public void createInitialService(IOFXUserEnvironment ev) {
    printService = new OFXFatClientFopUserPrintService(ev, templateClassLoaderFqName, fallBackFileSystemTemplateLoadingPath, printerOutputPath, useFoplandModfier, useTmpOutputDir, autodetectFont);

    ((OFXFatClientFopUserPrintService) printService).selfconfigureFopFactory(fontPath);
  }

  public IPrintingServiceImpl createConfiguredUserPrintService(Object tecHandle, IOFXUserEnvironment dummy) {
    if (printService == null) {
      createInitialService(dummy);
    }
    return printService;
  }

  public void gcClean() {
    printService.gcClean();
    printService = null;
  }


}
