package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import java.util.List;
import java.util.ArrayList;
import org.modellwerkstatt.manmap.runtime.MMStaticAccessHelper;

/**
 * TODO: OFXObjectKeyReference can also handly ValueObjects.
 * However, ValueObject have to be able to compair agains "", what is sutable as no key! 
 * 
 * @param <ENTITY> 
 */
public class OFXKeyReference<KEY, ENTITY extends IOFXEntity<KEY>> implements IOFXMetaDTO<ENTITY>, IOFXMetaReferences<ENTITY>, IOFXRevertableAttribute<OFXKeyReference<KEY, ENTITY>> {
  private boolean enabled = true;
  private boolean optional = false;
  private String label = null;

  private boolean opposite = false;
  private Class keyClass;
  private ENTITY value;
  private ENTITY origRef2Value;
  private KEY key;
  private List<ENTITY> scope;

  private String scopeHint = "";

  public OFXKeyReference(boolean op, Class keyClass) {
    // for optimization puropos, all Datatypes do not inherit from each other
    // TODO: persist ignore dirty is an entity, not in IntkeyRefClass
    this.opposite = op;
    this.keyClass = keyClass;


    // Dan, MoWare MRS, initialization changed.
    // get ReferenceKey in map_Entity checked for null key in case of integer, to return 0
    // removed due to this initialization
    this.key = getNullKeyInstance();
  }

  public void setEnabled(boolean enbl) {
    this.enabled = enbl;
  }
  public boolean getEnabled() {
    return this.enabled;
  }
  public void setOptional(boolean opt) {
    this.optional = opt;
  }
  public boolean getOptional() {
    return this.optional;
  }
  public void setLabel(String lbl) {
    this.label = lbl;
  }
  public String getLabel() {
    return this.label;
  }
  public void setOpposite(boolean opt) {
    this.opposite = opt;
  }
  public boolean getOpposite() {
    return this.opposite;
  }

  @Override
  public String getHintForScope() {
    return scopeHint;
  }

  public void setHintForScope(String val) {
    scopeHint = val;
  }

  public boolean setValue(ENTITY val) {

    if (val == null) {
      // the references is set to null on purpose
      this.value = null;

      // introduced inKeyReference Summer 2015
      if (!(isNullKey(this.key))) {
        key = getNullKeyInstance();
        return true;
      }

      // just to be save.... we will return above.
      key = getNullKeyInstance();
    } else {
      // val is not null
      this.value = val;


      // Bug 17. Feb 2016, if object is set as ref but objects key is still 0
      // ref should trigger a dirty. moware60 R4
      if (!(SaveObjectComperator.equals(val.getIM3Key(), this.key))) {
        // okay, clearly this results in a dirty
        this.key = val.getIM3Key();
        return true;
      }
      // okay, keys are the same. are we null and object's key is null?
      if (isNullKey(val.getIM3Key())) {
        // just to be save, than we are dirty!
        this.key = val.getIM3Key();
        return true;
      }
    }

    return false;
  }
  public ENTITY getValue() {
    if (this.value == null && !(isNullKey(this.key))) {
      throw new OFXNotInitializedException("OFXIntKeyReference: key " + this.key + " present, but reference not initialized.");
    }
    return this.value;
  }

  public void checkReferenceBeforeSave() {
    // no key at all or null key?
    if (this.value != null && (this.value.getIM3Key() == null || isNullKey(this.value.getIM3Key()))) {
      throw new IllegalStateException("Saving a reference without saving the referred entity first. (value = " + this.value + " / key = " + this.value.getIM3Key() + ")");
    }

  }

  public KEY getKey() {
    if (this.value != null) {
      this.key = this.value.getIM3Key();
    }
    return this.key;
  }

  public void setKey(KEY key) {
    this.key = key;
  }
  public void setScope(List<ENTITY> scope) {
    this.scope = scope;
  }
  public List<ENTITY> getScope() {
    return this.scope;
  }
  public boolean isInitialized() {
    if (this.value == null) {
      // key could be null to?  In that case it s not initialized by def.
      // in order one can check isInitialized() to dive into, without gettint a NPE
      if (isNullKey(this.key)) {
        return false;
      }
      // of course, if key not null and value is null, then it s not initialized.
      return false;
    }
    if (!(this.value.getIM3Key().equals(this.key))) {
      throw new OFXIllegalAccessException("Key " + this.key + " not in sync with ref.getIM3Key() " + this.value.getIM3Key() + ".");
    }
    return true;
  }

  public OFXKeyReference<KEY, ENTITY> copy() {
    OFXKeyReference<KEY, ENTITY> i = new OFXKeyReference<KEY, ENTITY>(this.opposite, keyClass);

    i.enabled = this.enabled;
    i.optional = this.optional;
    i.label = this.label;


    // store the original reference ...
    i.origRef2Value = this.value;

    if (!(i.opposite) && this.value != null && !(this.value.getReadOnly())) {
      // WE SHOULD WORK WITH A CACHE HERE, copy of ENTITIES ARE CREATED MULTIPLE TIMES using up mem
      i.value = ((ENTITY) this.value.copy());

    } else {
      i.value = this.value;
    }

    if (this.key instanceof IOFXRevertableObject) {
      // ValueObject
      KEY keyCopy = (KEY) ((IOFXRevertableObject) this.key).copy();
      i.key = keyCopy;

    } else {
      i.key = this.key;
    }

    if (this.scope != null) {
      // scopes have to be readonly anyway ... SCOPES ARE NOT DEEP COPIED
      i.scope = new ArrayList<ENTITY>();
      i.scope.addAll(this.scope);

    } else {
      i.scope = this.scope;
    }
    return i;
  }
  public void load(OFXKeyReference<KEY, ENTITY> cp, boolean fullRevertNotMerge) {
    if (fullRevertNotMerge) {
      this.enabled = cp.enabled;
      this.optional = cp.optional;
      this.label = cp.label;

      this.opposite = cp.opposite;

      if (cp.scope != null) {
        this.scope.clear();
        this.scope.addAll(cp.scope);

      } else {
        this.scope = cp.scope;
      }


      this.keyClass = cp.keyClass;

      // okay, now what should we do with the value?
      this.value = cp.origRef2Value;
      // should we restore the value's object?
      if (this.value != null && !(this.opposite) && !(this.value.getReadOnly())) {
        // yes, we have to
        this.value.load(cp.value, fullRevertNotMerge);
      }

      this.key = cp.key;

    } else {
      // this is the merge operation for references .. 
      this.key = getNullKeyInstance();
      this.value = null;

    }


  }

  public KEY getNullKeyInstance() {
    if (keyClass == null) {
      return null;
    }
    if (keyClass.equals(Integer.class)) {
      return ((KEY) new Integer(0));
    }
    if (keyClass.equals(String.class)) {
      return ((KEY) "");
    }

    try {
      if (IOFXValueObject.class.isAssignableFrom(keyClass)) {

        return ((KEY) ((IOFXValueObject) keyClass.newInstance()).createNullKey());
      }

    } catch (IllegalAccessException e) {
      throw new RuntimeException(e);
    } catch (InstantiationException e) {
      throw new RuntimeException(e);
    }
    throw new RuntimeException("Unknown KEY class in OFXKeyRefence: " + keyClass);
  }

  public static boolean isNullKey(Object key) {
    return MMStaticAccessHelper.isNullKeyStaticHelper(key);
  }

  @Override
  public String toString() {
    return "OFXKeyRef " + this.key;
  }

  private Boolean requestFocus;
  public void requestFocus() {
    requestFocus = new Boolean(true);
  }
  public boolean getFocusAndClearIt() {
    if (requestFocus != null && requestFocus.equals(true)) {
      requestFocus = null;
      return true;
    }
    requestFocus = null;
    return false;
  }
  private String validationErrorText;
  @Override
  public void setValidationError(String val) {
    validationErrorText = val;
  }
  @Override
  public String getValidationError() {
    return validationErrorText;
  }
}
