package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import org.joda.time.LocalDate;

public class OFXLocalDate implements IOFXMetaRange<LocalDate>, IOFXRevertableAttribute<OFXLocalDate> {
  private boolean enabled = true;
  private boolean optional = false;
  private String label;

  private LocalDate value;
  private LocalDate min;
  private LocalDate max;


  public OFXLocalDate() {
    // for optimization puropos, all Datatypes do not inherit from each other
  }

  public void setEnabled(boolean enbl) {
    this.enabled = enbl;
  }
  public boolean getEnabled() {
    return this.enabled;
  }
  public void setOptional(boolean opt) {
    this.optional = opt;
  }
  public boolean getOptional() {
    return this.optional;
  }
  public void setLabel(String lbl) {
    this.label = lbl;
  }
  public String getLabel() {
    return this.label;
  }
  public boolean setValue(LocalDate val) {
    if (this.value == null) {
      if (val == null) {
        // nothing do to...
      } else {
        this.value = val;
        return true;
      }
    } else if (val == null || !(this.value.equals(val))) {
      this.value = val;
      return true;
    }

    return false;
  }
  public LocalDate getValue() {
    return this.value;
  }

  public OFXLocalDate copy() {
    OFXLocalDate i = new OFXLocalDate();
    i.enabled = this.enabled;
    i.optional = this.optional;
    i.label = this.label;

    i.value = this.value;
    i.min = this.min;
    i.max = this.max;
    return i;
  }
  public void load(OFXLocalDate cp, boolean fullRevertNotMerge) {
    if (fullRevertNotMerge) {
      this.enabled = cp.enabled;
      this.optional = cp.optional;
      this.label = cp.label;
      this.min = cp.min;
      this.max = cp.max;
    }

    this.value = cp.value;
  }

  /**
   * Generator convenience method only. 
   * 
   * @return value is null or not?
   */
  public boolean isNull() {
    return this.value == null;
  }
  public void setMinMax(LocalDate min, LocalDate max) {
    this.min = min;
    this.max = max;
  }
  public LocalDate getMin() {
    return this.min;
  }
  public LocalDate getMax() {
    return this.max;
  }


  private Boolean requestFocus;
  public void requestFocus() {
    requestFocus = new Boolean(true);
  }
  public boolean getFocusAndClearIt() {
    if (requestFocus != null && requestFocus.equals(true)) {
      requestFocus = null;
      return true;
    }
    requestFocus = null;
    return false;
  }
  @Override
  public String toString() {
    return "" + this.value;
  }
  private String validationErrorText;
  @Override
  public void setValidationError(String val) {
    validationErrorText = val;
  }
  @Override
  public String getValidationError() {
    return validationErrorText;
  }

}
