package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import java.io.StringWriter;
import java.io.PrintWriter;
import java.util.Set;
import mjson.Json;

/**
 * OFXLogger is used as last resort, where we could not draw on appFactory for logging.
 * 
 * OFXLogger will always use log file / mail logging to report incidences.
 * OFXLogger supports a file interface called portJ for jobs, but for apps also.
 * 
 */
public class OFXLogger {
  private static boolean portJLoggingEnabled = false;
  private static boolean batchJoblogOnConsole = false;
  private static Log portJLog;

  public static OFXLogger enablePortJ() {
    portJLoggingEnabled = true;
    portJLog = LogFactory.getLog("org.modellwerkstatt.portj");

    return null;
  }
  public static boolean isEnabledPortJ() {
    return portJLoggingEnabled;
  }
  public static void enableBatchJobLogOnConsole() {
    batchJoblogOnConsole = true;
  }

  public static void log(String packageName, IOFXCoreReporter.LogPriority level, String msg, Throwable t) {
    Log log = LogFactory.getLog(packageName);
    logInternal(log, level, msg, t);
  }

  public static void log(Class packageClass, IOFXCoreReporter.LogPriority level, String msg, Throwable t) {
    Log log = LogFactory.getLog(packageClass);
    logInternal(log, level, msg, t);
  }

  public static void logConsole(String str) {
    // use err, since log() will also log to err
    System.err.println(str);
  }

  private static String stackTrace2String(Throwable t) {
    StringWriter sw = new StringWriter();
    t.printStackTrace(new PrintWriter(sw));
    return sw.toString();
  }

  public static String convertToString(CoreReporterInfo cri) {
    StringBuilder sb = new StringBuilder();
    sb.append(String.format("%20s: %45s %55s %7s ", cri.getMsgType(), MoVersion.getCapitalizedShortNameFromFQ(cri.getCmdFqName()), MoVersion.getCapitalizedShortNameFromFQ(cri.getSource()), cri.getPrio()));

    sb.append(cri.getDescription() + " ");

    if (cri.getParameters().containsKey(CoreReporterInfo.PARAM)) {
      sb.append(cri.getParameters().get(CoreReporterInfo.PARAM) + " ");
      cri.getParameters().remove(CoreReporterInfo.PARAM);
    }

    Set<String> allKeys = cri.getParameters().keySet();
    for (String key : allKeys) {
      sb.append(" " + key + ": " + cri.getParameters().get(key));
    }

    if (cri.getException() != null) {
      sb.append(OFXConsoleHelper.stackTrace2String(cri.getException()));
    }

    return sb.toString();
  }

  public static String simpleInfo(Json json) {
    String msg = "";

    if (json.has("Source")) {
      msg += json.at("Source").asString() + " / ";
    }
    if (json.has("UserName")) {
      msg += json.at("UserName").asString() + " / ";
    }
    if (json.has("CmdFqName")) {
      msg += json.at("CmdFqName").asString() + " / ";
    }
    if (json.has("Description")) {
      msg += json.at("Description").asString() + " / ";
    }

    return msg;
  }

  public static Json convertToJSON(CoreReporterInfo cri) {
    Json obj = Json.object();

    obj.set("logstamp", System.currentTimeMillis());
    obj.set("MsgType", "" + cri.getMsgType());
    obj.set("AppFqName", cri.getAppFqName());
    obj.set("AppVersion", cri.getAppVersion());

    obj.set("Source", cri.getSource());
    obj.set("CmdFqName", cri.getCmdFqName());
    obj.set("SessionId", cri.getSessionLogId());
    obj.set("Description", cri.getDescription());
    obj.set("Prio", "" + cri.getPrio());

    obj.set("UserId", cri.getUserId());
    obj.set("UserName", cri.getUserName());
    obj.set("ActorDevice", cri.getActorDevice());
    obj.set("ActorDeviceId", cri.getActorDeviceId());
    obj.set("ActorDeviceConnInfo", cri.getActorDeviceConnInfo());

    obj.set("MowareVersion", cri.getMowareVersion());
    obj.set("MowarePlatform", "" + cri.getMowarePlatform());
    obj.set("SystemName", cri.getSystemName());


    Set<String> allKeys = cri.getParameters().keySet();
    Json params = Json.object();
    for (String key : allKeys) {
      Object paramValue = cri.getParameters().get(key);
      try {
        if (paramValue instanceof String) {
          String stParamValue = ((String) paramValue).trim();
          if (stParamValue.startsWith("{")) {
            paramValue = Json.read(stParamValue);
          }
        }

      } catch (Throwable t) {
        paramValue = "MoWare convertToJSON: While converting " + paramValue + "\n\nEXCEPTION\n" + OFXConsoleHelper.stackTrace2String(t);
      }
      params.set(key, paramValue);
    }
    obj.set("Params", params);

    if (cri.getException() != null) {
      obj.set("Exception", OFXConsoleHelper.stackTrace2String(cri.getException()));
    }

    return obj;
  }

  public static void logCoreInfoToJOrConsole(CoreReporterInfo info) {

    if (portJLoggingEnabled) {
      logInternal(portJLog, info.getPrio(), convertToJSON(info).toString(), null);

    } else if (batchJoblogOnConsole) {
      System.err.println(convertToString(info));

    } else {
      log(info.getSource(), info.getPrio(), convertToString(info), null);
    }
  }

  private static void logInternal(Log log, IOFXCoreReporter.LogPriority level, String msg, Throwable t) {

    if (t != null) {
      switch (level) {
        case FATAL:
          log.fatal(msg, t);
          break;
        case ERROR:
          log.error(msg, t);
          break;
        case WARN:
          log.warn(msg, t);
          break;
        case INFO:
          log.info(msg, t);
          break;
        case DEBUG:
          log.debug(msg, t);
          break;
        case TRACE:
          log.trace(msg, t);
          break;
        default:
          throw new RuntimeException("This can not happen! Level is " + level);
      }

    } else {
      switch (level) {
        case FATAL:
          log.fatal(msg);
          break;
        case ERROR:
          log.error(msg);
          break;
        case WARN:
          log.warn(msg);
          break;
        case INFO:
          log.info(msg);
          break;
        case DEBUG:
          log.debug(msg);
          break;
        case TRACE:
          log.trace(msg);
          break;
        default:
          throw new RuntimeException("This can not happen! Level is " + level);
      }
    }


  }



  public static void main(String[] args) {
    Json obj = Json.object();

    obj.set("Source", "SrcFld");
    obj.set("CmdFqName", "CmdFld");
    obj.set("Description", "DscFld");

    obj.set("UserName", "UsrFld");
    System.err.println("> " + simpleInfo(obj));
  }




}
