package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import java.util.HashMap;

public class OFXProblem implements IOFXProblem {
  private String problemDesc;
  private String instanceDesc;
  private Throwable forwarded;
  private boolean wasGuard;
  private IOFXProblem.Opt[] options;
  private HashMap<String, Object> propertiesMap;
  private IOFXSession.IUxEventActionable basisCmdStart;


  public OFXProblem(String problem, String instance, HashMap<String, Object> paramMap, IOFXProblem.Opt... opts) {
    problemDesc = problem;
    instanceDesc = instance;
    options = opts;
    wasGuard = false;
    propertiesMap = paramMap;
  }

  public OFXProblem(IOFXSession.IUxEventActionable cmdStart, String problem, String instance, HashMap<String, Object> paramMap, IOFXProblem.Opt... opts) {
    problemDesc = problem;
    instanceDesc = instance;
    options = opts;
    wasGuard = false;
    basisCmdStart = cmdStart;
    propertiesMap = paramMap;
  }

  public OFXProblem(boolean fromGuard, String problem, String instance, Throwable forwardedFromGuard) {
    // no options then, used from guard.
    this(problem, instance, null);

    // might still be null, just to indicate that a guard was used
    forwarded = forwardedFromGuard;
    // e.g. unexpected ex in doFinalCancel of map_cmd is not from guard. 
    wasGuard = fromGuard;
  }

  public HashMap<String, Object> getPropMapOrNull() {
    return propertiesMap;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();

    if (getProblemDescOrNull() != null) {
      sb.append(getProblemDescOrNull() + ". ");
    }
    if (getInstanceDescOrNull() != null) {
      sb.append(getInstanceDescOrNull() + ". ");
    }
    if (hasForwardedEx()) {
      sb.append(getForwardedEx().getClass().getName() + ": " + getForwardedEx().getMessage());
    }
    if (isWarningOnly()) {
      sb.append(" (warning)");
    }
    return sb.toString();
  }
  public String getProblemDescOrNull() {
    return problemDesc;
  }
  public String getInstanceDescOrNull() {
    return instanceDesc;
  }



  public boolean hasForwardedEx() {
    return forwarded != null;
  }
  public Throwable getForwardedEx() {
    return forwarded;
  }
  public boolean isFromGuard() {
    return wasGuard;
  }

  public boolean isWarningOnly() {
    return hasOption(IOFXProblem.Opt.WARNING_HINT);
  }
  public boolean isJobIgnore() {
    return hasOption(IOFXProblem.Opt.JOB_IGNORE);
  }
  public boolean isJobItemAlreadDone() {
    return hasOption(IOFXProblem.Opt.JOB_ITEM_ALREAD_DONE);
  }

  public boolean noPrioOptionGiven() {
    if (options != null) {
      for (IOFXProblem.Opt opt : options) {
        if (opt.equals(IOFXProblem.Opt.PRIO_FATAL) || opt.equals(IOFXProblem.Opt.PRIO_ERROR) || opt.equals(IOFXProblem.Opt.PRIO_INFO)) {
          return false;
        }
      }
    }
    return true;
  }
  public boolean isPrioInfo() {
    if (hasOption(IOFXProblem.Opt.PRIO_INFO)) {
      return true;
    }
    if (isWarningOnly() && noPrioOptionGiven()) {
      return true;
    }
    return false;
  }

  public boolean isPrioError() {
    if (hasOption(IOFXProblem.Opt.PRIO_ERROR)) {
      return true;
    }
    if (!(isWarningOnly()) && noPrioOptionGiven()) {
      return true;
    }
    return false;
  }

  public boolean isPrioFatal() {
    return hasOption(IOFXProblem.Opt.PRIO_FATAL);
  }

  @Override
  public IOFXCoreReporter.LogPriority translatedLogPrio() {
    if (isPrioInfo()) {
      return IOFXCoreReporter.LogPriority.INFO;
    }
    if (isPrioError()) {
      return IOFXCoreReporter.LogPriority.ERROR;
    }
    return IOFXCoreReporter.LogPriority.FATAL;
  }

  public String getSimpleUserText() {
    String msg = getProblemDescOrNull();

    if (getForwardedEx() != null) {
      if (msg == null) {
        msg = getForwardedEx().getClass().getName() + ": " + getForwardedEx().getMessage();
      } else {
        msg += " [" + getForwardedEx().getClass().getName() + ": " + getForwardedEx().getMessage() + "]";
      }

    } else {
      if (msg == null) {
        msg = "[?]";
      }
    }

    return msg;
  }
  public boolean hasOption(IOFXProblem.Opt lookingFor) {
    if (options != null) {
      for (IOFXProblem.Opt opt : options) {
        if (opt.equals(lookingFor)) {
          return true;
        }
      }
    }
    return false;
  }

  @Override
  public IOFXSession.IUxEventActionable getResolveActionOrNull() {
    return basisCmdStart;
  }

}
