package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;

public class OFXRunCmdContainer {
  protected String surroundingPackage;


  protected OFXRunCmdContainer outer;

  private IOFXUserEnvironment __userEnvironment;
  private IOFXUserServices __userServices;
  private IOFXApplicationFactory __localApplicationFactory;

  private String cmdFqName;
  private Object[] commandParams;
  private boolean successorSituation;

  private IOFXCommand command;
  private IOFXCommand successorCommand;

  private IOFXPageHandler commandPages;
  private IOFXPageHandler successorPages;

  public OFXRunCmdContainer(OFXRunCmdContainer outerContainer) {
    outer = outerContainer;

    surroundingPackage = outer.surroundingPackage;
    __localApplicationFactory = outer.__localApplicationFactory;
    __userEnvironment = outer.__userEnvironment;
    __userServices = outer.__userServices;
  }

  public OFXRunCmdContainer(String aPackage, IOFXApplicationFactory appFactory, IOFXUserEnvironment userEnv, IOFXUserServices userSrv) {
    surroundingPackage = aPackage;
    __localApplicationFactory = appFactory;
    __userEnvironment = userEnv;
    __userServices = userSrv;
  }

  public void parameterize(String aCmdFqName, Object[] theParams, boolean needsSuccessor) {
    cmdFqName = aCmdFqName;
    commandParams = theParams;
    successorSituation = needsSuccessor;
  }

  public void setCommandPages(IOFXPageHandler cmdPages) {
    commandPages = cmdPages;
  }
  public void setSuccessorPages(IOFXPageHandler cmdPages) {
    successorPages = cmdPages;
  }

  public void run() throws Exception {
    IOFXCmdModule module = __localApplicationFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName(cmdFqName));

    IOFXSession session = (outer != null ? outer.command.getCommandSession() : null);
    command = module.startCommand(IOFXCmdModule.CmdExecStrategy.SINGLE, cmdFqName, commandParams, session, __userEnvironment, __userServices);

    try {
      command.initCommand();

      commandPages.handlePages(command, command.getCommandSession());

      // successor final_ok checked in handleSuccessor
      if (successorSituation) {
        handleSuccessor();
      }

      reportResidualWarnings(__userServices, command);

      if (outer != null) {
        List<Object> selections = (command.isTerminatedOk() ? command.getTerminateOkSelections() : ((command.isTerminatedCancel() ? command.getTerminateCancelSelections() : null)));

        outer.childTerminated(true, command.isTerminatedOk(), selections);
      }

      if (!(command.isCommandType(IOFXCommand.OFXCmdTyp.SEARCH_CMD)) && !(command.isTerminatedOk())) {
        throw new IllegalStateException("GraphOWNER / GraphEDIT Command " + command.getCommandFqName() + " still not terminated in final ok, after all pages handled.");
      }
      if (command.isCommandType(IOFXCommand.OFXCmdTyp.SEARCH_CMD) && !(isTerminated(command))) {
        throw new IllegalStateException("SEARCH Command " + command.getCommandFqName() + " still not terminated ok/cancel/user_cancel, after all pages handled.");
      }


    } catch (OFXAbortedException userFlag) {
      List<IOFXProblem> lop = command.getCommandSession().getAndclearProblemState();
      cancel(lop, null);
      throw new OFXJobWorkCanceledException(command.getCommandFqName(), lop);

    } catch (OFXJobWorkCanceledException cancelEx) {
      // obviously we are in go now... 
      if (outer != null) {
        throw new RuntimeException("This can not happen.");
      }
      cancel(cancelEx.getSessionProblems(), null);
      throw cancelEx;

    } catch (Exception e) {
      cancel(null, e);
      throw e;

    } finally {
      if (successorSituation && successorCommand != null) {
        if (!(isTerminated(successorCommand))) {
          OFXLogger.log(surroundingPackage, IOFXCoreReporter.LogPriority.ERROR, "Framework-error, succesor command " + successorCommand + " neither terminated in final ok, cancel nor in exception conclusion.", null);
        }
      }

      if (!(isTerminated(command))) {
        OFXLogger.log(surroundingPackage, IOFXCoreReporter.LogPriority.ERROR, "Framework-error, command " + command.getCommandFqName() + " neither terminated in final ok, cancel nor in exception conclusion.", null);
      }
    }


  }


  private void handleSuccessor() throws Exception {
    if (!(command.isReadyForSuccessor())) {
      throw new IllegalStateException("Command " + cmdFqName + " not ready to run successor command, but expected to after pages processed.");
    }

    OFXSuccessorCommandConfig cfg = command.getSuccessorCommandConfig();
    IOFXCmdModule successorModule = __localApplicationFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName(cfg.getCmdName()));

    successorCommand = successorModule.startCommand(IOFXCmdModule.CmdExecStrategy.INNER_NO_NEW_SESSION, cfg.getCmdName(), cfg.getParams(), command.getCommandSession(), __userEnvironment, __userServices);
    successorCommand.manageAlsoPredecessor(command);

    successorCommand.initCommand();
    boolean successorPagesHandled = successorPages.handlePages(successorCommand, successorCommand.getCommandSession());

    if (!(successorPagesHandled)) {
      throw new IllegalStateException("Successor " + successorCommand.getCommandFqName() + " and pages not handled correctly in RunCommand.");
    }
    if (!(successorCommand.isTerminatedOk())) {
      throw new IllegalStateException("Successor Command " + successorCommand.getCommandFqName() + " still not terminated in final ok/cancel, after all pages handled.");
    }

    reportResidualWarnings(__userServices, successorCommand);
  }

  public void childTerminated(boolean child, boolean wasOk, List<Object> selections) throws Exception {
    if (successorSituation) {
      // successor should not be terminated then, child could solely stem from successor
      if (successorCommand == null) {
        throw new IllegalStateException("This can not happen. Successor not initialized yet");
      }
      if (isTerminated(successorCommand)) {
        throw new IllegalStateException("This can not happen. Successor is terminated.");
      }
      successorCommand.handleCmdTermAndClearGeFqName(child, wasOk, selections, new OFXFakePagePane());

    } else {
      command.handleCmdTermAndClearGeFqName(child, wasOk, selections, new OFXFakePagePane());
    }
  }
  public void cancel(List<IOFXProblem> lop, Exception unexpetedExOrNull) {
    try {
      // successor also cancel predecessor in final_cancel
      if (successorSituation && successorCommand != null) {
        if (!(isTerminated(successorCommand))) {
          successorCommand.doFinalCancelConclusion(lop, unexpetedExOrNull);
        }
      }

      if (!(isTerminated(command))) {
        command.doFinalCancelConclusion(lop, unexpetedExOrNull);
      }

    } catch (Exception exInCancelConclusion) {
      OFXLogger.log(surroundingPackage, IOFXCoreReporter.LogPriority.ERROR, "Framework-error, ex in cancel() of " + command.getCommandFqName() + " container.", exInCancelConclusion);
      // not escalated, we are in a shutdown of cmd anyway. 
    }

    // 
    if (outer != null) {
      try {
        List<Object> selections = (command.isTerminatedOk() ? command.getTerminateOkSelections() : ((command.isTerminatedCancel() ? command.getTerminateCancelSelections() : null)));

        outer.childTerminated(true, command.isTerminatedOk(), selections);

      } catch (OFXAbortedException e) {
        List<IOFXProblem> prblms = outer.command.getCommandSession().getCopyOfProblemState();
        String msgs = OFXConsoleHelper.asSimpleString(prblms);
        OFXLogger.log(surroundingPackage, IOFXCoreReporter.LogPriority.ERROR, "Precondition in cmd-term handler of " + outer.command.getCommandFqName() + " while canceling " + command.getCommandFqName() + ":\n" + msgs, null);

      } catch (Throwable t) {
        OFXLogger.log(surroundingPackage, IOFXCoreReporter.LogPriority.ERROR, "Exception in cmd-term handler of " + outer.command.getCommandFqName() + " while canceling " + command.getCommandFqName() + ":\n", t);

      }



    }


  }

  private boolean isTerminated(IOFXCommand cmd) {
    return cmd.isTerminatedOk() || cmd.isTerminatedCancel() || cmd.isUserCancelTerminated();
  }

  private void reportResidualWarnings(IOFXUserServices __userServices, IOFXCommand cmd) {
    String sessId = cmd.getCommandSession().getSessionLoggingId();
    List<IOFXProblem> allProblems = cmd.getCommandSession().getAndclearProblemState();


    for (int i = 0; i < ListSequence.fromList(allProblems).count(); i++) {
      IOFXProblem prblm = ListSequence.fromList(allProblems).getElement(i);

      if (!(prblm.isWarningOnly())) {
        throw new IllegalStateException("This can not happen: '" + prblm.getSimpleUserText() + "' is not a warning.");
      }

      IOFXCoreReporter.LogPriority prio = IOFXCoreReporter.LogPriority.WARN;
      if (prblm.isPrioError()) {
        prio = IOFXCoreReporter.LogPriority.ERROR;
      } else if (prblm.isPrioFatal()) {
        prio = IOFXCoreReporter.LogPriority.FATAL;
      }
      __userServices.logOnCoreReporter(cmd.getCommandFqName(), sessId, IOFXCoreReporter.EVENT, prio, prblm.getSimpleUserText(), prblm.getPropMapOrNull());
    }
  }

  public Object getTerminateOkObjectForId(String id) {
    return command.getTerminateOkObjectForId(id);
  }

  public interface IOFXPageHandler {
    boolean handlePages(IOFXCommand __cmd, IOFXSession __manMapSession) throws Exception;
  }
}
