package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import org.modellwerkstatt.manmap.runtime.MMSession;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.joda.time.DateTime;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.joda.time.LocalDate;
import org.springframework.transaction.TransactionStatus;
import org.modellwerkstatt.manmap.runtime.MMShutdownRequestException;
import org.modellwerkstatt.manmap.runtime.IM3Entity;
import org.modellwerkstatt.manmap.runtime.MMAdditionalInfoException;
import org.modellwerkstatt.manmap.runtime.IM3UserEnvironment;

public class OFXSimpleManMapSession extends MMSession implements IOFXSession {
  private PlatformTransactionManager transactionManager;
  private DefaultTransactionDefinition transactionDefinition;

  private boolean isShared;
  private boolean alwaysRollbackSession;
  private volatile boolean isLocked;
  private String lockedByUser;
  private boolean immediateTransactionExecuted = false;
  private DateTime lastTransactionStart = null;

  private List<IOFXSessionOperation> okOperations = ListSequence.fromList(new ArrayList<IOFXSessionOperation>());
  private IOFXSessionOperation postTransactionOperation;

  private List<IOFXProblem> sessionProblems = ListSequence.fromList(new ArrayList<IOFXProblem>());

  private String sessionOwnerFqName;
  private String graphEditFqName;
  private IOFXSession.IUxEvent registeredEvent;

  @Deprecated
  private IOFXUserServices usersServices;
  private IOFXUserEnvironment userEnviormentInformation;



  @Autowired
  public OFXSimpleManMapSession(DefaultTransactionDefinition definition, PlatformTransactionManager manager) {
    super();
    this.isShared = false;
    this.isLocked = false;
    this.alwaysRollbackSession = false;
    this.lockedByUser = null;

    this.transactionDefinition = definition;
    this.transactionManager = manager;
    this.sessionOwnerFqName = "";
    this.graphEditFqName = null;
    this.postTransactionOperation = null;
    this.registeredEvent = null;
  }

  public void initSession(IOFXUserEnvironment evn, IOFXUserServices srv, boolean rollbackAlways) {
    userEnviormentInformation = evn;
    usersServices = srv;
    alwaysRollbackSession = rollbackAlways;
  }

  public synchronized void setLockedByOtherUser(String whom) {
    setReadOnly();
    lockedByUser = whom;
    isLocked = true;
  }
  public boolean isLockedByOtherUser() {
    return isLocked;
  }
  public String getLockedByUser() {
    return lockedByUser;
  }
  public void setSharedSession() {
    this.isShared = true;
  }
  public boolean inSuccessorPattern() {
    return this.isShared;
  }
  public IOFXUserEnvironment getUserEnvironment() {
    return this.userEnviormentInformation;
  }
  public IOFXUserServices getUserServices() {
    return this.usersServices;
  }
  @Override
  public void registerUxEvent(IOFXSession.IUxEvent uxEvent) {
    if (registeredEvent != null) {
      throw new RuntimeException("There is already the event " + uxEvent.name() + " [" + uxEvent.paramInfo() + "] registered, while you are registering " + uxEvent.name());
    }
    registeredEvent = uxEvent;
  }
  @Override
  public IOFXSession.IUxEvent getRegisteredUxEvent() {
    return registeredEvent;
  }
  public DateTime getCurrentTransactionTimestamp() {
    if (this.lastTransactionStart == null) {
      throw new IllegalStateException("Requesting timestamp, but no transaction started. ");
    }
    return this.lastTransactionStart;
  }

  public LocalDate getCurrentTransactionLocalDate() {
    return this.getCurrentTransactionTimestamp().toLocalDate();
  }

  public void addProblem(IOFXProblem problem) {
    ListSequence.fromList(sessionProblems).addElement(problem);
  }


  public List<IOFXProblem> getAndclearProblemState() {
    List<IOFXProblem> currentProblems = sessionProblems;
    sessionProblems = ListSequence.fromList(new ArrayList<IOFXProblem>());
    return currentProblems;
  }

  public List<IOFXProblem> getCopyOfProblemState() {
    List<IOFXProblem> currentProblems = ListSequence.fromList(new ArrayList<IOFXProblem>());
    ListSequence.fromList(currentProblems).addSequence(ListSequence.fromList(sessionProblems));
    return currentProblems;
  }

  public boolean hasProblemsOtherThanWarnings() {
    for (IOFXProblem prb : sessionProblems) {
      if (!(prb.isWarningOnly())) {
        return true;
      }
    }
    return false;
  }

  public void reportProblemsByEx() {
    if (hasProblemsOtherThanWarnings()) {
      throw new OFXAbortedException();
    }
  }

  @Override
  public void setPostTransactionOperation(IOFXSessionOperation operation) {
    postTransactionOperation = operation;
  }

  public void startTransactionAndFlush() throws Exception {
    TransactionStatus status = null;

    if (ListSequence.fromList(sessionProblems).any((it) -> !(it.isWarningOnly()))) {
      throw new RuntimeException("Programming error: We can not start a transaction and flush it, when we have non-warning problems in the session. " + sessionProblems);
    }
    if (this.isReadOnly()) {
      throw new RuntimeException("Programming error: Trying execute startTransactionAndFlush() on a readonly session.");
    }
    if (immediateTransactionExecuted) {
      throw new RuntimeException("There was alread an immediateTransactionExecuted in this session. No more transactions are available within this session.");
    }
    if (Thread.currentThread().isInterrupted()) {
      throw new MMShutdownRequestException("starting transaction - Thread.interrupted()=true, raising ShutDownRequest Exception.");
    }
    if (userEnviormentInformation == null) {
      throw new RuntimeException("UserEnv is null! This can not happen.");
    }

    try {
      status = transactionManager.getTransaction(transactionDefinition);

      // This should be replace by service name sometime ..
      lastTransactionStart = DeprecatedServerDateProvider.getSqlServerDateTime();
      ListSequence.fromList(transactionEntities).clear();

      // execute operations, e.g. insert, delete, update ..
      for (int i = 0; i < ListSequence.fromList(okOperations).count(); i++) {
        ListSequence.fromList(okOperations).getElement(i).execute();
      }

      if (alwaysRollbackSession) {
        transactionManager.rollback(status);
      } else {
        transactionManager.commit(status);
      }

      // mark as commited .. nothing should go wrong now .. no errors please
      for (int i = 0; i < ListSequence.fromList(transactionEntities).count(); i++) {
        IM3Entity entity = ListSequence.fromList(transactionEntities).getElement(i);
        entity.clearDirtySetReadonly(false);
      }

      if (postTransactionOperation != null) {
        postTransactionOperation.execute();
        postTransactionOperation = null;
      }

    } catch (Exception eWhileTransaction) {
      if (status != null) {
        // we do have to rollback the ex.
        try {
          transactionManager.rollback(status);

          if (postTransactionOperation != null) {
            postTransactionOperation.execute();
            postTransactionOperation = null;
          }

          for (int i = 0; i < ListSequence.fromList(transactionEntities).count(); i++) {
            IM3Entity entity = ListSequence.fromList(transactionEntities).getElement(i);
            entity.rollback();
          }


        } catch (Throwable tWhileRollback) {
          eWhileTransaction.addSuppressed(new MMAdditionalInfoException("Additionally exception while trying to rollback the transaction" + OFXConsoleHelper.stackTrace2String(tWhileRollback)));
        }

      }
      throw eWhileTransaction;

    } finally {
      ListSequence.fromList(okOperations).clear();
      ListSequence.fromList(transactionEntities).clear();
      lastTransactionStart = null;

    }
    // locks are released by command and not by
    // transaction... OK_CONCLUSION, CANCEL_CONCLUSION as well es EXCEPTION_CONCLUSION
    // call closeSessionAndFreeGC()
    // therefore one can save, even if locks lead to some sort of problem.
  }



  public void immediateTransactionForOperation(IOFXSessionOperation markerOp, IOFXSessionOperation journalOp) throws Exception {
    TransactionStatus status = null;


    // ignore problems completely
    if (this.isReadOnly()) {
      throw new RuntimeException("Programming error: Trying execute immediateTransactionForOperation on a readonly session.");
    }
    if (immediateTransactionExecuted) {
      throw new RuntimeException("There was alread an immediateTransactionExecuted in this session. No more transactions are available within this session.");
    }
    if (Thread.currentThread().isInterrupted()) {
      throw new MMShutdownRequestException("starting transaction - Thread.interrupted()=true, raising ShutDownRequest Exception.");
    }
    if (userEnviormentInformation == null) {
      throw new RuntimeException("UserEnv is null! This can not happen.");
    }

    try {
      status = transactionManager.getTransaction(transactionDefinition);

      // This should be replace by service name sometime ..
      lastTransactionStart = DeprecatedServerDateProvider.getSqlServerDateTime();

      ListSequence.fromList(transactionEntities).clear();
      // execute operations, e.g. insert, delete, update ..
      if (markerOp != null) {
        markerOp.execute();
      }
      if (journalOp != null) {
        journalOp.execute();
      }
      if (alwaysRollbackSession) {
        transactionManager.rollback(status);
      } else {
        transactionManager.commit(status);
      }

      // mark as commited .. nothing should go wrong now .. no errors please
      for (int i = 0; i < ListSequence.fromList(transactionEntities).count(); i++) {
        ListSequence.fromList(transactionEntities).getElement(i).clearDirtySetReadonly(false);
      }

      if (postTransactionOperation != null) {
        postTransactionOperation.execute();
        postTransactionOperation = null;
      }


    } catch (Exception ex) {
      if (status != null) {
        // we do have to rollback the ex.
        try {
          transactionManager.rollback(status);

          if (postTransactionOperation != null) {
            postTransactionOperation.execute();
            postTransactionOperation = null;
          }

        } catch (Throwable tWhileRollback) {
          ex.addSuppressed(new MMAdditionalInfoException("Additionally exception while trying to rollback the transaction" + OFXConsoleHelper.stackTrace2String(tWhileRollback)));
        }
      }
      throw ex;

    } finally {
      ListSequence.fromList(transactionEntities).clear();
      lastTransactionStart = null;
      immediateTransactionExecuted = true;
    }
  }

  public List<IOFXSessionOperation> getOperations() {
    return this.okOperations;
  }

  public void addOperation(IOFXSessionOperation operation) {
    ListSequence.fromList(okOperations).addElement(operation);
  }

  @Override
  public String toString() {
    return this.getSessionInformation();
  }
  @Override
  public String getCurrentCmdName() {
    if (graphEditFqName == null) {
      return sessionOwnerFqName;
    }
    return graphEditFqName;
  }
  @Override
  public void setSessionOwnerFqName(String cmdFqName) {
    sessionOwnerFqName = cmdFqName;
  }
  @Override
  public void setGraphEditFqName(String cmdFqName) {
    graphEditFqName = cmdFqName;
  }
  @Override
  public void clearGraphEditFqName() {
    graphEditFqName = null;
  }

  @Override
  public String getSessionLoggingId() {
    return "" + this.hashCode();
  }
  public String getSessionInformation() {
    StringBuilder st = new StringBuilder();

    st.append("x - x - x - x - x - x - x - x - this is a OFXSimpleManMapSession - x - x - x - x - x - x - x - x\n");
    st.append("Session owner fqName: " + this.sessionOwnerFqName + "\n");
    st.append("Graph edit fqName: " + this.graphEditFqName + "\n");
    st.append("Read only session: " + this.isReadOnly() + "\n\n");
    st.append(this.getKeyStoreInfo());
    st.append("\n\n\n");


    for (int i = 0; i < ListSequence.fromList(okOperations).count(); i++) {
      st.append(" Operation " + i + ":" + ListSequence.fromList(okOperations).getElement(i).getInformation() + "\n");
    }

    for (int i = 0; i < ListSequence.fromList(transactionEntities).count(); i++) {
      st.append(" Entity to commit " + i + ":" + ListSequence.fromList(transactionEntities).getElement(i).getClass().getName() + " - " + ListSequence.fromList(transactionEntities).getElement(i) + "\n");
    }

    st.append("\n\nCurrent problems:");
    for (IOFXProblem prob : sessionProblems) {
      st.append("\n" + prob.getProblemDescOrNull() + " / " + prob.getInstanceDescOrNull());
    }

    return st.toString();
  }



  public void clearAllKeystoresAndOperations() {
    super.clearAllKeystores();
    ListSequence.fromList(this.okOperations).clear();
  }


  public void closeSessionAndfreeGC() {
    // can be called multiple times .. do not clear problems list!
    clearAllKeystoresAndOperations();
    usersServices = null;
  }


  public IM3UserEnvironment getIM3UserEnvironment() {
    return userEnviormentInformation;
  }

  @Deprecated
  public boolean hasSessionProblems_Lgcy() {
    return ListSequence.fromList(sessionProblems).count() > 0;
  }

  @Deprecated
  public IOFXProblem getLastProblem_Lgcy() {
    if (!(hasSessionProblems_Lgcy())) {
      throw new RuntimeException("This can not happen. Session Problems are 0, but getLastProblem_Lgcy requesgted.");
    }
    return ListSequence.fromList(sessionProblems).last();
  }
}
