package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import java.util.List;
import java.util.ArrayList;
import java.util.Arrays;
import jetbrains.mps.internal.collections.runtime.ListSequence;

public class OFXUrlParams {
  public static final String PICKUPURL = "__startcmd__";
  protected List<String> segments;

  public OFXUrlParams() {
    segments = new ArrayList<String>();
  }

  public OFXUrlParams(List<String> path) {
    // vaadin can perfectly work with segments.

    segments = path;
  }

  public void parse(String path) {
    if (path == null) {
      segments.clear();

    } else {

      int endIndex = path.indexOf("?");
      String basePath;
      if (endIndex >= 0) {
        basePath = path.substring(0, endIndex);
      } else
      if (path.contains("#")) {
        basePath = path.substring(0, path.indexOf(35));
      } else {
        basePath = path;
      }

      if (basePath.startsWith("/")) {
        basePath = basePath.substring(1);
      }

      segments = Arrays.asList(basePath.split("/"));
    }
  }

  public boolean isPickup() {
    if (segments.size() == 0) {
      return false;
    }
    return PICKUPURL.equals(segments.get(0));
  }

  public boolean hasCmdName() {
    if (segments.size() == 0) {
      return false;
    }
    String name = segments.get(0);

    if (name == null || "".equals(name.trim())) {
      return false;
    }
    return true;
  }

  public String getCmdName() {
    return segments.get(0);
  }

  public String getFirstOrEmpty() {
    if (hasCmdName()) {
      return getCmdName();
    }
    return "";
  }

  public int numParams() {
    int num = segments.size() - 1;
    if (num < 0) {
      num = 0;
    }
    return num;
  }

  public String getStringParamOrNull(int index) {
    index++;

    if (index < segments.size()) {
      return segments.get(index);

    } else {
      return null;

    }
  }
  public Integer getIntParamOr0(int index) {
    index++;

    if (index < segments.size()) {
      return Integer.valueOf(segments.get(index));

    } else {
      return 0;

    }
  }

  public IOFXMetaStatus.IOFXStatusElement getStatusParamOrNull(int index, IOFXMetaStatus.IOFXStatusElement onCreate) {
    IOFXMetaStatus.IOFXStatusElement[] allElements = (IOFXMetaStatus.IOFXStatusElement[]) onCreate.getAllStatusElements();

    index++;
    String lookingFor = segments.get(index);
    for (IOFXMetaStatus.IOFXStatusElement elem : allElements) {
      if (elem.getDbValue().equals(lookingFor)) {
        return elem;
      }
    }

    throw new IllegalArgumentException("'" + lookingFor + "' is not a valid status value for " + onCreate.getClass().getName());
  }
  public static String cmdParamObjectToString(Object o) {
    if (o instanceof IOFXMetaStatus.IOFXStatusElement) {
      return ((IOFXMetaStatus.IOFXStatusElement) o).getDbValue();
    } else {
      return "" + o;
    }
  }
  public String asUrl() {
    return "/" + "".join("/", segments);
  }

  public boolean same(String someUrl) {
    return asUrl().equals(someUrl);
  }

  @Override
  public String toString() {
    return "Params: size " + segments.size() + " as URL '" + asUrl() + "'";
  }

  public static void main(String[] args) {
    List<String> segments = new ArrayList<String>();
    segments.add("dan");
    segments.add("man");

    OFXUrlParams p = new OFXUrlParams(segments);
    System.err.println(p.asUrl());


    p = new OFXUrlParams();
    p.parse("/dan/man//////////");
    System.err.println(p.asUrl());
    System.err.println(p.numParams());

    p.parse("dan/man");
    System.err.println(p.asUrl());



    p = new OFXUrlParams(ListSequence.fromList(new ArrayList<String>()));
    System.err.println(p.hasCmdName());
  }

  public interface OFXUrlCmdParams {
    Object[] calc(OFXUrlParams params);
  }
}
