package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */


public class OFXValueObject<T> implements IOFXMetaBasis<T>, IOFXRevertableAttribute<OFXValueObject<T>> {
  private boolean enabled = true;
  private boolean optional = false;
  private String label = null;

  private T value;

  public OFXValueObject() {
  }

  public void setEnabled(boolean enbl) {
    this.enabled = enbl;
  }
  public boolean getEnabled() {
    return this.enabled;
  }
  public void setOptional(boolean opt) {
    this.optional = opt;
  }
  public boolean getOptional() {
    return this.optional;
  }
  public void setLabel(String lbl) {
    this.label = lbl;
  }
  public String getLabel() {
    return this.label;
  }
  public boolean setValue(T val) {
    if (this.value == null) {
      if (val == null) {
        // nothing do to...
      } else {
        this.value = val;
        return true;
      }

    } else if (val == null) {
      this.value = val;
      return true;

    } else {
      boolean sameObject = this.value.equals(val);
      // set it anyway.
      this.value = val;

      // dirty? when not same. -> No
      return !(sameObject);
    }

    return false;
  }
  public T getValue() {
    return this.value;
  }
  public OFXValueObject copy() {
    OFXValueObject i = new OFXValueObject();
    i.enabled = this.enabled;
    i.optional = this.optional;
    i.label = this.label;
    // value object should be immutable by definition... should we still copy an object?
    // no problem yet, we do not copy..
    i.value = this.value;
    return i;
  }
  public void load(OFXValueObject<T> cp, boolean fullRevertNotMerge) {
    if (fullRevertNotMerge) {
      this.enabled = cp.enabled;
      this.optional = cp.optional;
      this.label = cp.label;
    }

    this.value = cp.value;
  }

  private Boolean requestFocus;
  public void requestFocus() {
    requestFocus = new Boolean(true);
  }
  public boolean getFocusAndClearIt() {
    if (requestFocus != null && requestFocus.equals(true)) {
      requestFocus = null;
      return true;
    }
    requestFocus = null;
    return false;
  }

  @Override
  public String toString() {
    return "" + this.value;
  }

  private String validationErrorText;
  @Override
  public void setValidationError(String val) {
    validationErrorText = val;
  }
  @Override
  public String getValidationError() {
    return validationErrorText;
  }

}
