package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import java.util.concurrent.atomic.AtomicInteger;

public class TelemetricsLongSampler {
  private int max;
  private long[] samples;
  private AtomicInteger index;

  public TelemetricsLongSampler(int m) {
    max = m;
    index = new AtomicInteger(0);
    samples = new long[max];
    for (int i = 0; i < max; i++) {
      samples[i] = 0;
    }
  }

  public void reset() {
    for (int i = 0; i < max; i++) {
      samples[i] = 0;
    }
    index.set(0);
  }

  public int getAndIncrement() {
    while (true) {
      int current = index.get();
      int next = (current + 1) % max;
      if (index.compareAndSet(current, next)) {
        return current;
      }
    }
  }

  public void addSample(long smpl) {
    samples[getAndIncrement()] = smpl;
  }

  public long getAverageTotal() {
    long avg = 0;
    int cnt = 0;

    for (int i = 0; i < max; i++) {
      if (samples[i] == 0) {
        continue;
      }
      avg += samples[i];
      cnt++;
    }

    if (cnt > 0) {
      avg = avg / cnt;
    }

    return avg;
  }
  public long getAverage(int backward) {
    long avg = 0;
    int cnt = 0;
    int currentIndex = index.get();
    if (currentIndex == 0) {
      currentIndex = max;
    }
    int diff = currentIndex - backward;

    if (diff < 0) {

      for (int i = max + diff; i < max; i++) {
        if (samples[i] == 0) {
          continue;
        }
        avg += samples[i];
        cnt++;
      }
      for (int i = 0; i < currentIndex; i++) {
        if (samples[i] == 0) {
          continue;
        }
        avg += samples[i];
        cnt++;
      }

    } else {
      for (int i = diff; i < currentIndex; i++) {
        if (samples[i] == 0) {
          continue;
        }
        avg += samples[i];
        cnt++;
      }
    }


    if (cnt > 0) {
      avg = avg / cnt;
    }

    return avg;
  }
  public long getMax(int backward) {
    long maxTime = 0;
    int currentIndex = index.get();
    if (currentIndex == 0) {
      currentIndex = max;
    }
    int diff = currentIndex - backward;

    if (diff < 0) {
      for (int i = max + diff; i < max; i++) {
        if (samples[i] == 0) {
          continue;
        }
        if (samples[i] > maxTime) {
          maxTime = samples[i];
        }
      }
      for (int i = 0; i < currentIndex; i++) {
        if (samples[i] == 0) {
          continue;
        }
        if (samples[i] > maxTime) {
          maxTime = samples[i];
        }


      }

    } else {
      for (int i = diff; i < currentIndex; i++) {
        if (samples[i] == 0) {
          continue;
        }
        if (samples[i] > maxTime) {
          maxTime = samples[i];
        }

      }
    }

    return maxTime;
  }
  public long getCount(long boundary) {
    boolean boundaryPassed = false;
    int cnt = 0;
    int currentIndex = index.get() - 1;


    if (currentIndex == -1) {
      currentIndex = max - 1;
    }

    // we can go back from current Index
    // but merley max times
    while (cnt < max && !(boundaryPassed)) {
      if (samples[currentIndex] > boundary) {
        cnt++;
      } else {
        boundaryPassed = true;
      }

      if (currentIndex == 0) {
        currentIndex = max - 1;
      } else {
        currentIndex--;
      }

    }

    return cnt;
  }




  public static void main(String[] args) {
    TelemetricsLongSampler m = new TelemetricsLongSampler(10000);
    m.addSample(10);

    System.out.println("" + m.getMax(100));
    System.out.println("" + m.getMax(10));
    System.out.println("" + m.getMax(1000));
  }
}
