package org.modellwerkstatt.objectflow.sdservices;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.serdes.IConvSerdes;
import org.modellwerkstatt.objectflow.serdes.IConvFormatOptions;
import org.joda.time.LocalDate;
import org.modellwerkstatt.objectflow.serdes.SerdesException;
import org.joda.time.DateTime;
import java.math.BigDecimal;

public abstract class BaseSerdes<T> implements IConvSerdes<T> {

  protected IConvFormatOptions formatters;
  protected MoWareEntityReflector reflector;

  protected Class<T> rootClass;
  protected CObjectField objTreeMeta;

  protected boolean arraySerdes;
  protected boolean useCompactingArrays;



  public BaseSerdes(Class<T> cls, IConvFormatOptions frmt) {
    rootClass = cls;
    formatters = frmt;
    reflector = new MoWareEntityReflector();

    useCompactingArrays = formatters.hasMode(IConvFormatOptions.Mode.SIMPLE_ARRAYS_TO_DTO);

    String className = rootClass.getName();
    if (className.startsWith("[L") && className.endsWith(";")) {
      className = className.substring(2, className.length() - 1);
      try {
        rootClass = ((Class<T>) rootClass.forName(className));
      } catch (ClassNotFoundException e) {
        throw new RuntimeException(e);
      }
      expectArrayAtRoot();
    }

    objTreeMeta = new CObjectField(rootClass.getSimpleName(), CField.OFXType.OFX_VALUE_OBJ, rootClass);
    reflector.constructCObjectTree(objTreeMeta);

  }

  public void expectArrayAtRoot() {
    arraySerdes = true;
  }

  public static Integer parseInt(String value) {
    return (value == null ? -1 : Integer.parseInt(value));
  }
  public static LocalDate parseLocalDate(IConvFormatOptions frmt, String value) {
    try {
      if (value == null || "".equals(value)) {
        return null;
      }
      LocalDate date = frmt.parseLocalDate(value);
      return date;
    } catch (Throwable t) {
      throw new SerdesException("Expected LocalDate but got '" + value + "' (wrong format?).");
    }
  }
  public static DateTime parseDateTime(IConvFormatOptions frmt, String value) {
    try {
      if (value == null || "".equals(value)) {
        return null;
      }
      DateTime dt = frmt.parseDateTime(value);
      return dt;
    } catch (Throwable t) {
      throw new SerdesException("Expected DateTime but got '" + value + "' (wrong format?).");
    }
  }
  public static BigDecimal parseBigDecimal(IConvFormatOptions frmt, String value) {
    try {
      if (value == null || "".equals(value)) {
        return null;
      }
      BigDecimal deci = frmt.parseBigDecimal(value);
      return deci;
    } catch (Throwable t) {
      throw new SerdesException("Expected BigDecimal but got '" + value + "' (wrong format?).");
    }
  }
  public static Object parseStatus(Class statusClass, String value) {
    try {
      return MoWareEntityReflector.statusFromString(statusClass, value);
    } catch (Exception ex) {
      throw new SerdesException("Can not convert '" + value + "' to status " + statusClass.getSimpleName() + ".");
    }

  }

  protected Object valueToObjectByType(String value, CField.OFXType type) {

    if (type == CField.OFXType.OFX_INT) {
      return parseInt(value);
    }
    if (type == CField.OFXType.OFX_STRING) {
      return value;
    }

    if (type == CField.OFXType.OFX_LOCALDATE) {
      return parseLocalDate(formatters, value);
    }

    if (type == CField.OFXType.OFX_DATETIME) {
      return parseDateTime(formatters, value);
    }

    if (type == CField.OFXType.OFX_BIGDECIMAL) {
      return parseBigDecimal(formatters, value);
    }

    throw new RuntimeException("This can not happen. Unknown type " + type);
  }
}
