package org.modellwerkstatt.objectflow.sdservices;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.serdes.IConvFormatOptions;
import org.modellwerkstatt.objectflow.serdes.SerdesException;
import java.lang.reflect.Array;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.List;
import java.io.StringWriter;

public class JackyGraphSerdes<T> extends JackyFieldSerdes<T> {


  public JackyGraphSerdes(Class<T> cls, IConvFormatOptions frmt) {
    super(new JackyInfra(), cls, frmt);
  }
  public JackyGraphSerdes(JackyInfra infra, Class<T> cls, IConvFormatOptions frmt) {
    super(infra, cls, frmt);
  }


  protected void deserObject(String basePath, Object currentInstance, CObjectField objMeta, VElement objData) {
    if (objData instanceof VObject) {
      Object resultInstance = deserToObject(basePath, objMeta, ((VObject) objData));
      objMeta.set(currentInstance, resultInstance);

    } else if (objData instanceof VField) {
      VField nullField = ((VField) objData);
      if (nullField.type == VField.VType.NULL) {
        objMeta.set(currentInstance, null);
      } else {
        throw new SerdesException("Expected object value but found a field value " + nullField + " instead.");
      }

    } else if (objData == null) {
      objMeta.set(currentInstance, null);

    }
  }
  protected void deserList(String basePath, Object currentInstance, CListField listMeta, VElement objData) {

    if (objData != null) {
      if (objData instanceof VField) {
        VField nullField = ((VField) objData);
        if (nullField.type == VField.VType.NULL) {
          if (!(formatters.hasMode(IConvFormatOptions.Mode.NULL_ARRAY_TO_EMPTY))) {
            listMeta.set(currentInstance, null);
          }

        } else {
          throw new SerdesException("Expecting list for " + listMeta.name + " but found " + nullField.value + " in json.");
        }

      } else {
        VList realItemsInList = ((VList) objData);
        Object listObject = listMeta.get(currentInstance);

        String path = basePath + "." + listMeta.name;
        for (VObject listValueItem : realItemsInList.objects) {

          Object resultInstance = deserToObject(path, listMeta, listValueItem);
          reflector.callListAdder(listObject, resultInstance);
        }
      }
    }
    // else do nothing, leave list in instance as it is.. 
  }

  protected <OBJTYPE> OBJTYPE deserToObject(String basePath, CObjectField curConcept, VObject data) {
    OBJTYPE currentInstance = curConcept.<OBJTYPE>newInstance();

    if (formatters.hasMode(IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY)) {
      if (curConcept.fields.size() != data.fields.size()) {
        throw new SerdesException("Number of fields in json data '" + data + "' do not match " + curConcept + " " + curConcept.fields + " (mode " + IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY + ")");
      }
    }

    for (CField trgt : curConcept.fields) {
      String fqPath = basePath + "." + trgt.name;

      if (trgt instanceof CListField) {
        CListField listField = ((CListField) trgt);
        VElement itemsInList = resolveJSonField(data, curConcept, listField.name);
        deserList(basePath, currentInstance, listField, itemsInList);

      } else if (trgt instanceof CObjectField) {
        CObjectField objField = ((CObjectField) trgt);
        VElement valueElem = resolveJSonField(data, curConcept, objField.name);
        deserObject(fqPath, currentInstance, objField, valueElem);

      } else {
        CField fldMeta = ((CField) trgt);
        VField fldDAta = ((VField) resolveJSonField(data, curConcept, fldMeta.name));
        deserField(fqPath, currentInstance, fldMeta, fldDAta);
      }

    }

    return currentInstance;
  }


  protected T deserToRootObject(CObjectField objectMeta, VObject dataObj) {
    return deserToObject("ROOT", objTreeMeta, dataObj);
  }

  protected T deserToRootArray(CObjectField objectMeta, VList theList) {
    int arrayLength = theList.objects.size();
    Object ar = Array.newInstance(rootClass, arrayLength);

    for (int i = 0; i < arrayLength; i++) {
      VObject valueItem = theList.objects.get(i);
      Object item = deserToObject("ROOT", objTreeMeta, valueItem);
      Array.set(ar, i, item);
    }

    return ((T) ar);
  }

  @Override
  public T deser(String st) {
    JackyParsed parser = new JackyParsed();
    VParent rootObject = parser.parse(infra.createParser(st));

    if (formatters.hasMode(IConvFormatOptions.Mode.DEBUG_TO_STDERR)) {
      JackyInfra.printDebugObject("", rootObject);
      JackyInfra.printDebugObject("", objTreeMeta);
    }

    if (arraySerdes) {
      return deserToRootArray(objTreeMeta, ((VList) rootObject));
    } else {
      return deserToRootObject(objTreeMeta, ((VObject) rootObject));
    }
  }

  public T internalDeser(VParent rootObject) {
    if (arraySerdes) {
      return deserToRootArray(objTreeMeta, ((VList) rootObject));
    } else {
      return deserToRootObject(objTreeMeta, ((VObject) rootObject));
    }
  }


  protected void serObject(JsonGenerator gen, String fqPath, CObjectField objMeta, Object dto, boolean compactThis) throws IOException {
    gen.writeFieldName(formatters.fieldPathToJson(objMeta.name));
    if (dto != null) {
      gen.writeStartObject();
      serDispatchFields(gen, fqPath, objMeta.fields, dto, compactThis);
      gen.writeEndObject();

    } else {
      gen.writeNull();
    }

  }

  protected void serList(JsonGenerator gen, String fqPath, CListField listMeta, List listOfObject, boolean compactThis) throws IOException {

    gen.writeFieldName(formatters.fieldPathToJson(listMeta.name));
    if (listOfObject != null) {
      gen.writeStartArray();

      boolean toCompact = useCompactingArrays && listMeta.fields.size() == 1;

      for (Object listItem : listOfObject) {
        if (!(toCompact)) {
          gen.writeStartObject();
        }
        serDispatchFields(gen, fqPath, listMeta.fields, listItem, toCompact);
        if (!(toCompact)) {
          gen.writeEndObject();
        }

      }
      gen.writeEndArray();

    } else {
      gen.writeNull();
    }
  }

  protected void serDispatchFields(JsonGenerator gen, String partentPath, List<CField> fields, Object dto, boolean compactThis) throws IOException {

    for (CField trgt : fields) {
      String fqPath = partentPath + "." + trgt.name;

      if (trgt instanceof CListField) {
        CListField listField = ((CListField) trgt);
        List listObject = ((List) listField.get(dto));
        serList(gen, fqPath, listField, listObject, compactThis);

      } else if (trgt instanceof CObjectField) {
        CObjectField objField = ((CObjectField) trgt);
        Object dtoOfProperty = objField.get(dto);
        serObject(gen, fqPath, objField, dtoOfProperty, compactThis);

      } else {
        CField fldConcept = ((CField) trgt);
        Object fieldValue = fldConcept.get(dto);
        JackyFieldSerdes.serField(gen, formatters, fldConcept.type, fldConcept.name, fieldValue, compactThis);

      }

    }
  }

  protected void serRootObject(JsonGenerator gen, Object dto) throws IOException {
    gen.writeStartObject();
    serDispatchFields(gen, "ROOT", objTreeMeta.fields, dto, false);
    gen.writeEndObject();
  }

  protected void serRootArray(JsonGenerator gen, Object graph) throws IOException {
    int arrayLength = Array.getLength(graph);
    boolean toCompact = useCompactingArrays && objTreeMeta.fields.size() == 1;


    gen.writeStartArray();
    for (int i = 0; i < arrayLength; i++) {
      Object item = Array.get(graph, i);

      if (!(toCompact)) {
        gen.writeStartObject();
      }
      serDispatchFields(gen, "ROOT", objTreeMeta.fields, item, toCompact);
      if (!(toCompact)) {
        gen.writeEndObject();
      }

    }
    gen.writeEndArray();
  }

  public void internalSer(JsonGenerator gen, String fldName, T graph, boolean compactThis) throws IOException {
    if (!(compactThis)) {
      gen.writeFieldName(fldName);
    }

    if (!(arraySerdes)) {
      serRootObject(gen, graph);
    } else {
      serRootArray(gen, graph);
    }
  }

  @Override
  public String ser(T graph) {
    JsonGenerator gen = null;
    String result;

    if (formatters.hasMode(IConvFormatOptions.Mode.DEBUG_TO_STDERR)) {
      JackyInfra.printDebugObject("", objTreeMeta);
    }

    try (StringWriter sw = new StringWriter()) {
      gen = infra.createGenerator(sw, formatters.hasMode(IConvFormatOptions.Mode.PRETTY));

      if (!(arraySerdes)) {
        serRootObject(gen, graph);
      } else {
        serRootArray(gen, graph);
      }

      gen.close();
      gen = null;
      result = sw.toString();

    } catch (IOException e) {
      throw new RuntimeException(e);
    } finally {
      if (gen != null) {
        try {
          gen.close();
        } catch (IOException e) {
        }
      }
    }

    return result;
  }



}
