package org.modellwerkstatt.objectflow.sdservices;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.serdes.IConvFormatOptions;
import org.joda.time.LocalDate;
import org.joda.time.DateTime;
import java.math.BigDecimal;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;
import java.util.List;
import java.lang.reflect.Array;

public class StringSer<T> extends BaseSerdes<T> {
  public static final String INDENT = "   ";

  public StringSer(Class<T> cls, IConvFormatOptions frmt) {
    super(cls, frmt);
  }

  public void serializeExpected(StringBuilder sb, String indent, IConvFormatOptions formatters, CField fld, Object value, boolean compactArrayMem) {

    String fieldname = formatters.fieldPathToJson(fld.name);
    if (compactArrayMem) {
      fieldname = "(fld name compacted)";
    }

    if (value == null) {
      sb.append(indent + fieldname + ": " + value + "\n");

    } else {

      if (fld.type == CField.OFXType.OFX_INT || fld.type == CField.OFXType.OFX_STRING) {
        sb.append(indent + fieldname + ": " + value + "\n");

      } else if (fld.type == CField.OFXType.OFX_LOCALDATE) {
        LocalDate ld = ((LocalDate) value);
        sb.append(indent + fieldname + ": " + formatters.printLocalDate(ld) + "\n");

      } else if (fld.type == CField.OFXType.OFX_DATETIME) {
        DateTime dt = ((DateTime) value);
        sb.append(indent + fieldname + ": " + formatters.printDateTime(dt) + "\n");

      } else if (fld.type == CField.OFXType.OFX_BIGDECIMAL) {
        BigDecimal bd = ((BigDecimal) value);
        sb.append(indent + fieldname + ": " + formatters.printBigDecimal(bd) + "\n");

      } else if (fld.type == CField.OFXType.OFX_STATUS) {
        IOFXMetaStatus.IOFXStatusElement elem = ((IOFXMetaStatus.IOFXStatusElement) value);
        String dbVal = elem.getDbValue();

        sb.append(indent + fieldname + ": " + dbVal + "\n");

      } else {
        throw new RuntimeException("This can not happen. Unknown type " + fld.type);

      }
    }
  }

  public void serialize(StringBuilder sb, String indent, CObjectField curConcept, Object dto, boolean compactThis) {

    for (CField trgt : curConcept.fields) {
      if (trgt instanceof CListField) {
        CListField listField = ((CListField) trgt);
        List listObject = ((List) listField.get(dto));

        sb.append(indent + formatters.fieldPathToJson(listField.name));

        if (listObject == null) {
          sb.append(" (List): null\n");

        } else {
          sb.append(" (List): \n");

          boolean toCompact = useCompactingArrays && listField.fields.size() == 1;

          for (Object listItem : listObject) {
            serialize(sb, indent + INDENT, listField, listItem, toCompact);
            if (!(toCompact)) {
              sb.append("\n");
            }
          }

        }

      } else if (trgt instanceof CObjectField) {
        CObjectField objField = ((CObjectField) trgt);
        Object dtoOfProperty = objField.get(dto);

        if (dtoOfProperty == null) {
          sb.append(indent + formatters.fieldPathToJson(objField.name) + ": null\n");

        } else {
          sb.append(indent + formatters.fieldPathToJson(objField.name) + ": \n");
          serialize(sb, indent + INDENT, objField, dtoOfProperty, compactThis);
        }

      } else {
        CField fldConcept = ((CField) trgt);
        Object fieldValue = fldConcept.get(dto);

        serializeExpected(sb, indent, formatters, fldConcept, fieldValue, compactThis);
      }

    }
  }



  @Override
  public String ser(T graph) {
    StringBuilder result = new StringBuilder();

    if (!(arraySerdes)) {
      serialize(result, "", objTreeMeta, graph, false);
      result.append("\n");

    } else {
      int arrayLength = Array.getLength(graph);
      boolean toCompact = useCompactingArrays && objTreeMeta.fields.size() == 1;

      for (int i = 0; i < arrayLength; i++) {
        Object item = Array.get(graph, i);

        if (!(toCompact)) {
          result.append("(List): \n");
        }
        serialize(result, "", objTreeMeta, item, toCompact);
        if (!(toCompact)) {
          result.append("\n");
        }
      }
      result.append("\n");
    }

    return result.toString();
  }

  @Override
  public T deser(String st) {
    throw new RuntimeException("Not implemented yet");
  }
}
