package org.modellwerkstatt.objectflow.sdservices;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.serdes.IConvSerdes;
import org.modellwerkstatt.objectflow.serdes.IConvFormatOptions;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import java.util.List;
import org.modellwerkstatt.objectflow.serdes.SerdesException;
import java.lang.reflect.Array;
import org.w3c.dom.Element;

public class XmlGraphSerdes<T> extends XmlFieldSerdes<T> implements IConvSerdes<T> {

  private XmlInfra infra;

  public XmlGraphSerdes(Class<T> cls, IConvFormatOptions frmt) {
    this(cls, frmt, new XmlInfra());
    infra.init();
  }
  public XmlGraphSerdes(Class<T> cls, IConvFormatOptions frmt, XmlInfra aInfra) {
    super(cls, frmt);
    infra = aInfra;
  }

  protected void deserObject(String basePath, Object currentInstance, CObjectField objConcept, Document xmlRootDoc, Node domObject) {

    List<Node> domObjectContent = filterOnElements(domObject);


    if (objConcept.type == CField.OFXType.OFX_VALUE_OBJ && domObjectContent.size() > 1) {
      // object brackets missing? be greatfull ?
      Object resultInstance = deserToObject(basePath, objConcept, xmlRootDoc, domObject);
      objConcept.set(currentInstance, resultInstance);

    } else if (domObjectContent.size() == 1) {
      Object resultInstance = deserToObject(basePath, objConcept, xmlRootDoc, domObjectContent.get(0));
      objConcept.set(currentInstance, resultInstance);

    } else if (domObjectContent.size() == 0) {
      objConcept.set(currentInstance, null);

    } else {
      throw new SerdesException("Expected an object for field " + objConcept.name + " but found in xml:\n" + infra.DEBUG_DOMNODE(domObject));
    }

  }
  protected void deserList(String basePath, Object currentInstance, CListField listConcept, Document xmlRootDoc, Node domListItem) {
    List<Node> domListItemContent = filterOnElements(domListItem);

    if (domListItem != null) {
      if (domListItemContent.size() == 0) {
        // there should be no null in xml anyway 
        // do not set anything ... 
      } else {
        Object listObject = listConcept.get(currentInstance);
        String path = basePath + "." + listConcept.name;

        for (int i = 0; i < domListItemContent.size(); i++) {
          Node domObject = domListItemContent.get(i);

          Object resultInstance = deserToObject(path, listConcept, xmlRootDoc, domObject);
          reflector.callListAdder(listObject, resultInstance);
        }
      }


    }
  }

  protected <OBJTYPE> OBJTYPE deserToObject(String basePath, CObjectField curConcept, Document xmlRootDoc, Node domNode) {

    OBJTYPE currentInstance = curConcept.<OBJTYPE>newInstance();
    List<Node> domCurrentElems = filterOnElements(domNode);


    if (formatters.hasMode(IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY)) {
      if (curConcept.fields.size() != domCurrentElems.size()) {
        throw new SerdesException("Mode is " + IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY + " but number of fields in " + curConcept + " (" + curConcept.fields.size() + ")" + " do not match " + domNode.getNodeName() + " (" + domCurrentElems.size() + ")" + ".");
      }
    }

    for (CField trgt : curConcept.fields) {
      String fqPath = basePath + "." + trgt.name;

      if (trgt instanceof CListField) {
        CListField listField = ((CListField) trgt);
        Node domListItem = resolveXMLField(domCurrentElems, curConcept, listField.name);

        deserList(fqPath, currentInstance, listField, xmlRootDoc, domListItem);


      } else if (trgt instanceof CObjectField) {
        CObjectField objField = ((CObjectField) trgt);
        Node domObject = resolveXMLField(domCurrentElems, curConcept, objField.name);

        deserObject(fqPath, currentInstance, objField, xmlRootDoc, domObject);

      } else {
        CField fldConcept = ((CField) trgt);
        Node domElement = resolveXMLField(domCurrentElems, curConcept, fldConcept.name);

        deserField(fqPath, currentInstance, fldConcept, xmlRootDoc, domNode, domElement);
      }

    }

    return currentInstance;
  }

  protected T deserRootObject(Document xmlRootDoc) {
    List<Node> rootDocElements = filterOnElements(xmlRootDoc);

    if (rootDocElements.size() != 1) {
      throw new SerdesException("Expected one root object in xml to deserialize, but found " + rootDocElements.size() + ".\n" + infra.DEBUG_DOMNODE(xmlRootDoc));
    }

    return deserToObject("ROOT", objTreeMeta, xmlRootDoc, rootDocElements.get(0));
  }

  protected T deserRootList(Document xmlRootDoc) {
    List<Node> rootDocElements = filterOnElements(xmlRootDoc);

    if (rootDocElements.size() != 1) {
      throw new SerdesException("Expected list in one root object in xml to deserialize, but found " + rootDocElements.size() + ".\n" + infra.DEBUG_DOMNODE(xmlRootDoc));
    }

    Node rootList = rootDocElements.get(0);
    List<Node> listOfObjs = filterOnElements(rootList);
    int arrayLength = listOfObjs.size();
    Object ar = Array.newInstance(rootClass, arrayLength);

    for (int i = 0; i < arrayLength; i++) {
      Node domObj = listOfObjs.get(i);
      Object item = deserToObject("ROOT", objTreeMeta, xmlRootDoc, domObj);
      Array.set(ar, i, item);
    }

    return ((T) ar);
  }

  @Override
  public T deser(String st) {
    Document xmlRootDoc = infra.parseDoc(st);

    if (formatters.hasMode(IConvFormatOptions.Mode.DEBUG_TO_STDERR)) {
      JackyInfra.printDebugObject("", objTreeMeta);
    }

    if (arraySerdes) {
      return deserRootList(xmlRootDoc);

    } else {
      return deserRootObject(xmlRootDoc);
    }
  }

  protected void serObject(Document xmlRootDoc, String fqPath, Element curXmlElem, CObjectField objConcept, Object dtoOfProp, boolean compactThis) {
    Element elm = xmlRootDoc.createElement(formatters.fieldPathToJson(objConcept.name));
    if (dtoOfProp != null) {
      Element obj = xmlRootDoc.createElement(objConcept.getTypeShortName());
      serDispatchFields(xmlRootDoc, fqPath, obj, objConcept, dtoOfProp, compactThis);
      elm.appendChild(obj);

    } else {
      // null - is empty
    }
    curXmlElem.appendChild(elm);
  }
  protected void serList(Document xmlRootDoc, String fqPath, Element curXmlElem, CListField listConcept, List listOfObject, boolean compactThis) {

    Element elm = xmlRootDoc.createElement(formatters.fieldPathToJson(listConcept.name));
    if (listOfObject != null) {
      boolean toCompact = useCompactingArrays && listConcept.fields.size() == 1;

      for (Object listItem : listOfObject) {
        if (!(toCompact)) {
          Element obj = xmlRootDoc.createElement(listConcept.getTypeShortName());
          serDispatchFields(xmlRootDoc, fqPath, obj, listConcept, listItem, toCompact);
          elm.appendChild(obj);

        } else {
          serDispatchFields(xmlRootDoc, fqPath, elm, listConcept, listItem, toCompact);
        }
      }

    } else {
      // null - no content
    }
    curXmlElem.appendChild(elm);
  }

  protected void serDispatchFields(Document xmlRootDoc, String parentPath, Element curXmlElem, CObjectField curConcept, Object dto, boolean compactThis) {

    for (CField trgt : curConcept.fields) {
      String fqPath = parentPath + "." + trgt.name;

      if (trgt instanceof CListField) {
        CListField listField = ((CListField) trgt);
        List listObject = ((List) listField.get(dto));
        serList(xmlRootDoc, fqPath, curXmlElem, listField, listObject, compactThis);

      } else if (trgt instanceof CObjectField) {
        CObjectField objField = ((CObjectField) trgt);
        Object dtoOfProperty = objField.get(dto);
        serObject(xmlRootDoc, fqPath, curXmlElem, objField, dtoOfProperty, compactThis);

      } else {
        CField fldConcept = ((CField) trgt);
        Object fieldValue = fldConcept.get(dto);

        Element elm = serField(xmlRootDoc, fqPath, fldConcept, fieldValue, compactThis);
        curXmlElem.appendChild(elm);
      }

    }
  }

  protected void serRootObject(Document xmlRootDoc, Object graph) {
    Element obj = xmlRootDoc.createElement(formatters.fieldPathToJson(objTreeMeta.getTypeShortName()));
    serDispatchFields(xmlRootDoc, "ROOT", obj, objTreeMeta, graph, false);
    xmlRootDoc.appendChild(obj);
  }
  protected void serRootList(Document xmlRootDoc, Object graph) {
    Element listElem = xmlRootDoc.createElement(formatters.fieldPathToJson(objTreeMeta.getTypeShortName() + "List"));

    int arrayLength = Array.getLength(graph);
    boolean toCompact = useCompactingArrays && objTreeMeta.fields.size() == 1;

    for (int i = 0; i < arrayLength; i++) {
      Object item = Array.get(graph, i);

      if (!(toCompact)) {
        Element obj = xmlRootDoc.createElement(formatters.fieldPathToJson(objTreeMeta.getTypeShortName()));
        serDispatchFields(xmlRootDoc, "ROOT", obj, objTreeMeta, item, toCompact);
        listElem.appendChild(obj);

      } else {
        serDispatchFields(xmlRootDoc, "ROOT", listElem, objTreeMeta, item, toCompact);
      }

    }
    xmlRootDoc.appendChild(listElem);
  }

  @Override
  public String ser(T graph) {
    Document xmlRootDoc = null;

    if (formatters.hasMode(IConvFormatOptions.Mode.DEBUG_TO_STDERR)) {
      JackyInfra.printDebugObject("", objTreeMeta);
    }

    xmlRootDoc = infra.newRootDoc();

    if (!(arraySerdes)) {
      serRootObject(xmlRootDoc, graph);

    } else {
      serRootList(xmlRootDoc, graph);

    }

    String result = infra.writeXml(xmlRootDoc);
    return result;
  }


}
