package org.modellwerkstatt.objectflow.sdservices;

/*Generated by MPS */

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.OutputKeys;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import java.io.StringReader;
import org.xml.sax.SAXException;
import java.io.IOException;
import javax.xml.transform.dom.DOMSource;
import java.io.StringWriter;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

public class XmlInfra {
  private DocumentBuilder builder;
  private DocumentBuilderFactory docFactory;
  private TransformerFactory transformerFactory;
  private Transformer transformer;

  public XmlInfra() {
  }

  public void init() {
    try {
      this.docFactory = DocumentBuilderFactory.newInstance();
      this.builder = docFactory.newDocumentBuilder();

      this.transformerFactory = TransformerFactory.newInstance();
      this.transformer = transformerFactory.newTransformer();
      this.transformer.setOutputProperty(OutputKeys.INDENT, "no");

    } catch (ParserConfigurationException e) {
      throw new RuntimeException(e);
    } catch (TransformerConfigurationException e) {
      throw new RuntimeException(e);
    }
  }

  public Document newRootDoc() {
    return this.builder.newDocument();
  }
  public Document parseDoc(String content) {
    try {
      Document theDoc = this.builder.parse(new InputSource(new StringReader(content)));
      theDoc.normalizeDocument();
      return theDoc;
    } catch (SAXException e) {
      throw new RuntimeException(e);
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }

  public String writeXml(Document doc) {
    try {
      DOMSource source = new DOMSource(doc);
      StringWriter writer = new StringWriter();
      StreamResult result = new StreamResult(writer);

      transformer.transform(source, result);
      return writer.getBuffer().toString();

    } catch (TransformerException e) {
      throw new RuntimeException(e);
    }
  }

  public String DEBUG_DOMNODE(Node node) {
    if (node == null) {
      return "(no node/node missing)\n";
    }
    String st = "";
    st += node.getNodeName() + ": " + node.getNodeValue() + "\n";
    for (int i = 0; i < node.getChildNodes().getLength(); i++) {
      Node cld = node.getChildNodes().item(i);
      st += "    " + cld.getNodeName() + ": " + cld.getNodeValue() + "\n";
    }
    return st;
  }
}
