package org.modellwerkstatt.objectflow.services;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.runtime.IMoLdapService;
import javax.naming.ldap.LdapContext;
import javax.naming.directory.SearchControls;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import javax.naming.NamingException;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import javax.naming.directory.Attribute;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.ldap.InitialLdapContext;

public class DeprMoLdapService implements IMoLdapService {
  public static final String DEFAULT_INITIAL_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
  public static final String DEFAULT_SECURITY_AUTHENTICATION = "Simple";



  private String initialBindSearchbase;
  private String initialBindPrincipal;
  private String initialBindPrincipalPassword;
  private String ldapServerAddress;
  private boolean useSsl;




  public DeprMoLdapService(String server, String principal, String pwd, String searchbase) {
    useSsl = false;
    ldapServerAddress = server;
    initialBindPrincipal = principal;
    initialBindPrincipalPassword = pwd;
    initialBindSearchbase = searchbase;
  }
  public DeprMoLdapService(String server, String principal, String pwd, String searchbase, boolean aUseSsl) {
    this(server, principal, pwd, searchbase);
    useSsl = aUseSsl;
  }


  public void setBindUserPassword(String pwd) {
    initialBindPrincipalPassword = pwd;
  }

  public boolean authenticateUser(String username, String pwd) {
    LdapContext bindContext = null;
    boolean usernamePwdOk = false;
    String distinguishedName = null;

    // prevent anonymous binds with ldap
    if (pwd == null || "".equals(pwd)) {
      return false;
    }


    try {
      bindContext = getContextToUserPwd(initialBindPrincipal, initialBindPrincipalPassword);

      SearchControls constraints = new SearchControls();
      constraints.setSearchScope(SearchControls.SUBTREE_SCOPE);
      String[] attrIDs = {"distinguishedName", "sn", "givenname"};
      constraints.setReturningAttributes(attrIDs);

      NamingEnumeration answer = bindContext.search(initialBindSearchbase, "sAMAccountName=" + username, constraints);

      // more than one ore none retrieved?
      // if notne, thats not an error, just was not able to find the username att all - correctly typed?
      if (answer.hasMore()) {
        Attributes attrs = ((SearchResult) answer.next()).getAttributes();
        distinguishedName = ((String) attrs.get("distinguishedName").get());
      }
      if (answer.hasMore()) {
        throw new RuntimeException("More then one distinguishedName for sAMAccountName " + username + " retrieved, contact directory admin.");
      }

    } catch (NamingException nex) {
      throw new RuntimeException("Ldap Bind: Connection failed", nex);

    } finally {
      closeIfNotNull(bindContext);
    }

    if (distinguishedName != null) {
      // proceed with check.
      LdapContext userContext = null;
      try {
        userContext = getContextToUserPwd(distinguishedName, pwd);
        usernamePwdOk = true;

      } catch (NamingException ex) {
        // no, can not log in ..
      } finally {
        closeIfNotNull(userContext);
      }
    }

    return usernamePwdOk;
  }

  public List<IMoLdapService.ICnInfo> getGroupsOfUser(String username) {
    LdapContext bindContext = null;
    String distinguishedName = null;
    List<IMoLdapService.ICnInfo> groupInfo = ListSequence.fromList(new ArrayList<IMoLdapService.ICnInfo>());

    try {
      bindContext = getContextToUserPwd(initialBindPrincipal, initialBindPrincipalPassword);

      SearchControls constraints = new SearchControls();
      constraints.setSearchScope(SearchControls.SUBTREE_SCOPE);
      String[] attrIDs = {"distinguishedName", "sn", "givenname", "memberOf"};
      constraints.setReturningAttributes(attrIDs);

      NamingEnumeration answer = bindContext.search(initialBindSearchbase, "sAMAccountName=" + username, constraints);

      // more than one are none retrieved?
      // if notne, thats not an error, just was not able to find the username att all - correctly typed?
      if (answer.hasMore()) {
        Attributes attrs = ((SearchResult) answer.next()).getAttributes();

        Attribute memberOf = attrs.get("memberOf");
        if (memberOf != null) {
          for (Enumeration e1 = memberOf.getAll(); e1.hasMoreElements();) {
            ListSequence.fromList(groupInfo).addElement(processGroupInformation(e1.nextElement().toString()));
          }
        }
      }

      if (answer.hasMore()) {
        throw new RuntimeException("More then one distinguishedName for sAMAccountName " + username + " retrieved, contact directory admin.");
      }

    } catch (NamingException nex) {
      throw new RuntimeException("Ldap Bind: Connection failed", nex);

    } finally {
      closeIfNotNull(bindContext);
    }

    return groupInfo;
  }
  public List<IMoLdapService.ICnInfo> getGroupsOfCommonName(String searchBase, String commonName) {
    LdapContext bindContext = null;
    String distinguishedName = null;
    List<IMoLdapService.ICnInfo> groupInfo = ListSequence.fromList(new ArrayList<IMoLdapService.ICnInfo>());

    try {
      bindContext = getContextToUserPwd(initialBindPrincipal, initialBindPrincipalPassword);

      SearchControls constraints = new SearchControls();
      constraints.setSearchScope(SearchControls.SUBTREE_SCOPE);
      String[] attrIDs = {"distinguishedName", "sn", "memberOf"};
      constraints.setReturningAttributes(attrIDs);

      NamingEnumeration answer = bindContext.search(searchBase, "cn=" + commonName, constraints);

      // more than one are none retrieved?
      // if notne, thats not an error, just was not able to find the username att all - correctly typed?
      if (answer.hasMore()) {
        Attributes attrs = ((SearchResult) answer.next()).getAttributes();

        Attribute memberOf = attrs.get("memberOf");
        if (memberOf != null) {
          for (Enumeration e1 = memberOf.getAll(); e1.hasMoreElements();) {
            ListSequence.fromList(groupInfo).addElement(processGroupInformation(e1.nextElement().toString()));
          }
        }
      }

      if (answer.hasMore()) {
        throw new RuntimeException("More then one entry for commonName " + commonName + " retrieved, contact directory admin.");
      }

    } catch (NamingException nex) {
      throw new RuntimeException("Ldap Bind: Connection failed", nex);

    } finally {
      closeIfNotNull(bindContext);
    }

    return groupInfo;
  }

  private GroupInformation processGroupInformation(String rawInfo) {
    GroupInformation info = new GroupInformation(rawInfo, getCommonName(rawInfo));
    return info;
  }


  private String getCommonName(String cnName) {
    if (cnName != null && cnName.toUpperCase().startsWith("CN=")) {
      cnName = cnName.substring(3);
    }
    int position = cnName.indexOf(',');
    if (position == -1) {
      return cnName;
    } else {
      return cnName.substring(0, position);
    }
  }


  private void closeIfNotNull(LdapContext context) {
    if (context != null) {
      try {
        context.close();
      } catch (NamingException ex) {
        throw new RuntimeException("LdapContext : Error while closing context", ex);
      }
    }
  }

  public LdapContext getContextToUserPwd(String distuingishedName, String pwd) throws NamingException {
    Hashtable<String, String> userEnv = new Hashtable<String, String>();

    userEnv = new Hashtable<String, String>();
    userEnv.put(Context.INITIAL_CONTEXT_FACTORY, DEFAULT_INITIAL_CONTEXT_FACTORY);
    userEnv.put(Context.SECURITY_AUTHENTICATION, DEFAULT_SECURITY_AUTHENTICATION);
    userEnv.put(Context.SECURITY_PRINCIPAL, distuingishedName);
    userEnv.put(Context.SECURITY_CREDENTIALS, pwd);
    userEnv.put(Context.PROVIDER_URL, ldapServerAddress);
    if (useSsl) {
      userEnv.put(Context.SECURITY_PROTOCOL, "ssl");
    }

    return new InitialLdapContext(userEnv, null);
  }

  public static class GroupInformation implements IMoLdapService.ICnInfo {
    private String unprocessedName;
    private String processedName;

    public GroupInformation(String unprocessed, String processed) {
      unprocessedName = unprocessed;
      processedName = processed;
    }


    public String getProcessedName() {
      return processedName;
    }
    public String getUnprocessedName() {
      return unprocessedName;
    }
  }


  @Override
  public List<IMoLdapService.ICnInfo> getNamesToAttrAndCommonName(String searchBase, String attr, String commonName) {
    throw new RuntimeException("Not implemented.");
  }
}
