package org.modellwerkstatt.objectflow.services;

/*Generated by MPS */

import java.util.Map;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class HttpConnection {

  public static String jsonConIoEx(RequestType rqType, String targetUrl, Map<String, String> headers, String reqContent) throws IOException {
    HttpURLConnection con = null;

    try {
      URL url = new URL(targetUrl);
      con = (HttpURLConnection) url.openConnection();
      con.setConnectTimeout(10000);
      con.setReadTimeout(10000);
      con.setInstanceFollowRedirects(false);
      if (rqType == RequestType.POST || rqType == RequestType.PUT || rqType == RequestType.PATCH) {
        con.setRequestProperty("Content-Type", "application/json");
      } else {
        con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
      }

      con.setRequestProperty("Accept", "application/json");
      if (headers != null) {
        for (String key : headers.keySet()) {
          // String encoded = new String(Base64.getEncoder().encode(headers.get(key).getBytes()));
          con.setRequestProperty(key, headers.get(key));
        }
      }
      con.setRequestMethod("" + rqType);

      if (reqContent != null) {
        con.setDoOutput(true);
        DataOutputStream out = new DataOutputStream(con.getOutputStream());
        out.writeBytes(reqContent);
        out.flush();
        out.close();

      }
      con.connect();

      int status = con.getResponseCode();
      String errorStatus = null;

      StringBuilder content = new StringBuilder();
      InputStream stream;

      if (status >= 200 && status < 300) {
        stream = con.getInputStream();

        if (status == 202) {
          errorStatus = "Http Status 202 (operation not completed) ";
        }

      } else {
        errorStatus = "Http Status " + status + " - " + con.getResponseMessage();
        stream = con.getErrorStream();
      }

      BufferedReader in = new BufferedReader(new InputStreamReader(stream));
      String inputLine;
      while ((inputLine = in.readLine()) != null) {
        content.append(inputLine);
      }
      in.close();

      if (errorStatus != null) {
        throw new IOException(errorStatus + "\n" + content.toString());
      }
      return content.toString();

    } finally {
      if (con != null) {
        con.disconnect();
      }
    }
  }

  public static String jsonCon(RequestType rqType, String targetUrl, Map<String, String> headers, String reqContent) {
    try {
      return jsonConIoEx(rqType, targetUrl, headers, reqContent);
    } catch (IOException e) {
      throw new RuntimeException(e);
    }

  }

  public enum RequestType {
    GET(),
    POST(),
    PUT(),
    DELETE(),
    PATCH()
  }

}
