package org.modellwerkstatt.objectflow.testsuit;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import java.util.Map;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import java.util.HashMap;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;

public class MoTestSuitHandler implements IOFXTestSuit.IOFXTestSuitHandler {
  private int testsPassed;
  private int testsDone;
  private boolean instantiateNew;

  private StringBuilder reportLines;
  private Map<String, IOFXTestSuit> testSuit = MapSequence.fromMap(new HashMap<String, IOFXTestSuit>());

  public MoTestSuitHandler() {
    testsPassed = 0;
    testsDone = 0;
    reportLines = new StringBuilder();
    instantiateNew = true;
  }

  public IOFXTestSuit getOrCreateTestSuit(String fqName) {

    // we have to bypass spring ioc with our own system here, since we do
    // not want to handle testsuit like components in apps.
    if (MapSequence.fromMap(testSuit).get(fqName) != null) {
      return MapSequence.fromMap(testSuit).get(fqName);
    }
    if (!(instantiateNew)) {
      throw new RuntimeException("Test " + fqName + " requested but not initialized in this setup (possibly a moware bug?)");
    }

    try {
      Class testSuitClass = Class.forName(fqName);
      MapSequence.fromMap(testSuit).put(fqName, ((IOFXTestSuit) OFXConsoleHelper.createBean(testSuitClass)));

    } catch (ClassNotFoundException e) {
      throw new RuntimeException("Can not retrieve Class for test " + fqName, e);
    }

    return MapSequence.fromMap(testSuit).get(fqName);
  }
  public void testSuitCreateInitDone() {
    instantiateNew = false;
  }




  public void startingTest() {
    testsDone++;
  }

  public void testDone(IOFXSession __manMapSession, String testsuitFqName, String testName, boolean passed) {
    if (passed) {
      String msg = "* * * * * PASSED " + testName + " * * * * * \n";
      reportLines.append(msg + "\n");
      __manMapSession.getUserServices().logOnCoreReporter("", "", testsuitFqName, IOFXCoreReporter.LogPriority.INFO, msg, null);
      testsPassed++;
    }

  }

  public void logError(IOFXSession __manMapSession, String testsuitFqName, String testName, Throwable t) {

    String msg = t.getClass().getName() + ": " + t.getMessage() + "\n";
    msg += getSessionProblemInfo(__manMapSession);

    msg += "\n\n" + OFXConsoleHelper.stackTrace2String(t);
    msg = "\n   " + msg.replace("\n", "\n     ");

    String s = "! ! ! ! ! NOT PASSED " + testName + "\n  " + msg + "\n\n";
    reportLines.append(s);
    __manMapSession.getUserServices().logOnCoreReporter("", "", testsuitFqName, IOFXCoreReporter.LogPriority.FATAL, s, null);

  }

  public void logError(IOFXSession __manMapSession, String testFqName, String testName, String st) {

    String s = "! ! ! ! ! NOT PASSED " + testName + "\n  " + st + "\n\n";
    s += getSessionProblemInfo(__manMapSession);

    reportLines.append(s);
    __manMapSession.getUserServices().logOnCoreReporter("", "", testFqName, IOFXCoreReporter.LogPriority.FATAL, s, null);

  }

  public void print(IOFXSession __manMapSession, String testFqName, String msg) {
    __manMapSession.getUserServices().logOnCoreReporter("", "", testFqName, IOFXCoreReporter.LogPriority.INFO, msg, null);

  }

  public void breakLine(IOFXSession __manMapSession, String testFqName, String testName) {
    __manMapSession.getUserServices().logOnCoreReporter("", "", testFqName, IOFXCoreReporter.LogPriority.INFO, "\n\n- - - - - - - - - " + testName + " - - - - - - - - -", null);
  }

  public void debug(IOFXSession __manMapSession, String testFqName, String msg) {
    __manMapSession.getUserServices().logOnCoreReporter("", "", testFqName, IOFXCoreReporter.LogPriority.INFO, msg, null);
  }

  public String getSessionProblemInfo(IOFXSession __manMapSession) {
    List<IOFXProblem> problems = __manMapSession.getAndclearProblemState();
    StringBuilder infos = new StringBuilder();
    for (IOFXProblem problm : problems) {
      infos.append("\nPROBLEM > " + problm.getSimpleUserText());
    }

    return infos.toString();
  }

  public boolean allTestsPassed() {
    if (testsPassed != 0 && testsPassed == testsDone) {
      return true;
    }
    return false;
  }

  public String summary() {
    StringBuilder b = new StringBuilder();
    b.append("\n\n");
    if (allTestsPassed()) {
      // all tests passed obviously
      b.append("\n\n");
      b.append("+ + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + \n");
      b.append("     _    _ _   _            _                                      _ _ \n");
      b.append("    / \\  | | | | |_ ___  ___| |_ ___   _ __   __ _ ___ ___  ___  __| | |\n");
      b.append("   / _ \\ | | | | __/ _ \\/ __| __/ __| | '_ \\ / _` / __/ __|/ _ \\/ _` | |\n");
      b.append("  / ___ \\| | | | ||  __/\\__ \\ |_\\__ \\ | |_) | (_| \\__ \\__ \\  __/ (_| |_|\n");
      b.append(" /_/   \\_\\_|_|  \\__\\___||___/\\__|___/ | .__/ \\__,_|___/___/\\___|\\__,_(_)\n");
      b.append("                                      |_|                               \n");
      b.append(" " + testsPassed + " out of " + testsDone + " in total \n");


    } else {
      b.append("\n\n");
      b.append("- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - \n");
      b.append("- - - - -    In TOTAL " + testsPassed + " of " + testsDone + " were PASSED.\n");
      b.append("- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - \n");


    }



    return b.toString();
  }
}
