package org.modellwerkstatt.objectflow.testsuit;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.runtime.IOFXTestSuit;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.IOFXUserServices;
import javax.sql.DataSource;
import org.modellwerkstatt.objectflow.runtime.IOFXApplicationFactory;
import java.util.Map;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import java.util.HashMap;
import java.lang.reflect.Method;
import java.util.List;
import java.util.ArrayList;
import org.modellwerkstatt.objectflow.runtime.OFXTestMethod;
import java.util.Comparator;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import org.joda.time.DateTime;
import java.lang.reflect.InvocationTargetException;
import org.springframework.transaction.CannotCreateTransactionException;
import java.lang.reflect.Field;
import org.modellwerkstatt.objectflow.runtime.OFXIncludedSuit;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;

public abstract class OFXTestSuit implements IOFXTestSuit {
  public static final DateTimeFormatter US_DTPARSER = DateTimeFormat.forPattern("MM/dd/yyyy hh:mm:ss");

  @Autowired
  protected IOFXUserEnvironment __userEnvironment;
  @Autowired
  protected IOFXUserServices __userServices;
  @Autowired
  protected DataSource __localDataSource;
  @Autowired
  protected IOFXApplicationFactory __localApplicationFactory;

  protected Map<String, IOFXTestSuit> allIncludedSuitsInstances = MapSequence.fromMap(new HashMap<String, IOFXTestSuit>());



  public void run(IOFXTestSuit.IOFXTestSuitHandler reporter) {
    String testSuitFqNAme = this.getClass().getName();


    Method[] allMethods = this.getClass().getMethods();
    List<TestMethodInfo> testMethodInfos = new ArrayList<TestMethodInfo>();

    for (Method mth : allMethods) {
      OFXTestMethod tmAnnotation = mth.getAnnotation(OFXTestMethod.class);
      if (tmAnnotation != null) {
        testMethodInfos.add(new TestMethodInfo(mth, tmAnnotation));
      }
    }

    testMethodInfos.sort(new Comparator<TestMethodInfo>() {
      @Override
      public int compare(TestMethodInfo p1, TestMethodInfo p2) {
        return p1.annotation.id() - p2.annotation.id();
      }
    });


    for (TestMethodInfo info : testMethodInfos) {

      if (info.annotation.enabled()) {
        // execute test pls... :)

        IOFXSession __manMapSession = createSession();

        try {
          reporter.startingTest();

          DeprecatedServerDateProvider.fixServerDatetimeToConstant(null);
          if (!("".equals(info.annotation.runAt()))) {
            DateTime dtToRunTestAd = US_DTPARSER.parseDateTime(info.annotation.runAt());
            DeprecatedServerDateProvider.fixServerDatetimeToConstant(dtToRunTestAd);
          }
          info.method.invoke(this, __manMapSession, reporter);
          reporter.testDone(__manMapSession, testSuitFqNAme, info.annotation.name(), true);

        } catch (IllegalAccessException e) {
          // introspection problem ??
          throw new RuntimeException("This can not happen.", e);

        } catch (InvocationTargetException e) {
          // introspection problem or ex while calling test method?

          Throwable t = e.getCause();
          if (t != null) {
            reporter.logError(__manMapSession, testSuitFqNAme, info.annotation.name(), t);
            reporter.testDone(__manMapSession, testSuitFqNAme, info.annotation.name(), false);

          } else {
            throw new RuntimeException("This can not happen.", e);
          }

        } catch (CannotCreateTransactionException ccte) {
          // Typically: no db connection
          reporter.logError(__manMapSession, testSuitFqNAme, info.annotation.name(), ccte);
          reporter.testDone(__manMapSession, testSuitFqNAme, info.annotation.name(), false);
          // do not exec testsuit any further.
          reporter.logError(__manMapSession, testSuitFqNAme, info.annotation.name(), "OFXTestSuit - execution stopped due to CannotCreateTransactionException!");
          return;

        } catch (Throwable t) {
          reporter.logError(__manMapSession, testSuitFqNAme, info.annotation.name(), t);
          reporter.testDone(__manMapSession, testSuitFqNAme, info.annotation.name(), false);

        }

      }

    }
  }

  public void setupFieldsOfSuit(IOFXTestSuit.IOFXTestSuitHandler hndlr, IOFXTestSuit suit) {


    try {
      Field[] allFields = suit.getClass().getFields();
      for (Field fld : allFields) {
        OFXIncludedSuit fldAnnotation = fld.getAnnotation(OFXIncludedSuit.class);
        if (fldAnnotation != null) {
          fld.setAccessible(true);
          IOFXTestSuit objToSet = hndlr.getOrCreateTestSuit(fldAnnotation.name());
          fld.set(suit, objToSet);
        }
      }

    } catch (IllegalAccessException e) {
      throw new RuntimeException("While initializing fields for " + suit.getClass().getName(), e);
    }



  }

  public boolean setupIncludedSuits(String[] allIncludedTests, String[] includedTestsToRun) {
    MoTestSuitHandler hndlr = new MoTestSuitHandler();

    //  create all included suits
    for (String fqName : allIncludedTests) {
      IOFXTestSuit instance = hndlr.getOrCreateTestSuit(fqName);
      MapSequence.fromMap(allIncludedSuitsInstances).put(fqName, instance);
    }
    hndlr.testSuitCreateInitDone();


    try {
      // run all onStartups
      for (String fqName : allIncludedTests) {
        IOFXTestSuit instance = MapSequence.fromMap(allIncludedSuitsInstances).get(fqName);

        setupFieldsOfSuit(hndlr, instance);
        instance.onStartup(hndlr, createSession());
      }
      this.onStartup(hndlr, createSession());

      // run all included suits to run
      for (String fqName : includedTestsToRun) {
        IOFXTestSuit instance = MapSequence.fromMap(allIncludedSuitsInstances).get(fqName);
        instance.run(hndlr);
      }
      run(hndlr);

    } catch (Throwable t) {
      System.err.println("---- TestSuit setup problems ----");
      System.err.println(OFXConsoleHelper.stackTrace2String(t));


    } finally {
      try {
        this.onShutdown(hndlr, createSession());

      } catch (Throwable t) {
        System.err.println("---- TestSuit setup problems while shutdown ----");
        System.err.println(OFXConsoleHelper.stackTrace2String(t));
      }

      // run all onShutdown in reverse
      for (int i = allIncludedTests.length - 1; i >= 0; i--) {
        IOFXTestSuit instance = MapSequence.fromMap(allIncludedSuitsInstances).get(allIncludedTests[i]);
        instance.onShutdown(hndlr, createSession());
      }

    }

    hndlr.print(createSession(), this.getClass().getName(), hndlr.summary());

    return hndlr.allTestsPassed();
  }


  public IOFXSession createSession() {
    return __localApplicationFactory.createNewSession(__userEnvironment, __userServices);
  }

  public static void runAsMain(String config, Class testSuitClass, String[] allIncludedTests, String[] includedTestsToRun) {
    boolean passed = false;

    try {
      if (config.trim().equals("")) {
        System.err.println("The configuration given in this suite is empty: '" + config + "'");
      }

      OFXTestSuit thisTestSuit = (OFXTestSuit) OFXConsoleHelper.initializeForTestSuit(config, testSuitClass);

      passed = thisTestSuit.setupIncludedSuits(allIncludedTests, includedTestsToRun);

    } catch (Throwable t) {
      System.err.println("----- TestSuit setup problems -----");
      System.err.println(OFXConsoleHelper.stackTrace2String(t));

    } finally {
      OFXConsoleHelper.unbindJmxRmiNaming(passed);

    }
  }



}
