package org.modellwerkstatt.fx8forms.delegates;

/*Generated by MPS */

import javafx.scene.control.TextField;
import javafx.scene.control.ContextMenu;
import java.util.List;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import javafx.scene.input.KeyEvent;
import javafx.event.EventHandler;
import javafx.scene.input.KeyCode;
import org.modellwerkstatt.fx8forms.windows.FX8TraversalHelper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import javafx.scene.control.Label;
import javafx.scene.control.CustomMenuItem;
import javafx.event.ActionEvent;
import javafx.geometry.Side;

@Deprecated
public class AutoCompleteContextMenu extends TextField {
  private ContextMenu contextMenu = new ContextMenu();
  private List<String> items;
  private boolean populateContextMenu;
  private IDataUxDelegate delegate;

  @Deprecated
  public AutoCompleteContextMenu() {
    super();
    populateContextMenu = true;


    contextMenu.addEventFilter(KeyEvent.ANY, new EventHandler<KeyEvent>() {
      @Override
      public void handle(KeyEvent keyEvent) {
        if (keyEvent.getCode().equals(KeyCode.ESCAPE)) {
          keyEvent.consume();
          if (keyEvent.getEventType().equals(KeyEvent.KEY_RELEASED)) {
            contextMenu.hide();
          }
        } else if (keyEvent.getCode().equals(KeyCode.ENTER)) {
          if (keyEvent.getEventType().equals(KeyEvent.KEY_RELEASED)) {
            // KeyHandler for Enter on DelegateForm does not work when context menu is open
            // This event is consumed, in case any action for menu selection was triggered.
            // so if we receive it, simply move on with the focus ...

            FX8TraversalHelper.traverseNext(AutoCompleteContextMenu.this);

            keyEvent.consume();
          }

        }
      }
    });

    this.addEventFilter(KeyEvent.ANY, new EventHandler<KeyEvent>() {
      @Override
      public void handle(KeyEvent keyEvent) {
        if (keyEvent.getEventType().equals(KeyEvent.KEY_TYPED)) {
          if (keyEvent.isControlDown() && keyEvent.getCharacter().trim().equals("")) {
            keyEvent.consume();
            showCompletionAndBind(true, false);
          }

        }
      }
    });


    this.textProperty().addListener(new ChangeListener<String>() {
      @Override
      public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
        if (populateContextMenu) {
          if (AutoCompleteContextMenu.this.getScene() != null) {
            // Bug ? do not showCompletion if not already displayed on screen...
            if (newValue.length() == 0) {
              if (contextMenu != null) {
                contextMenu.hide();
              }

            } else {
              showCompletionAndBind(false, false);
            }
          }
        }
      }
    });
    this.focusedProperty().addListener(new ChangeListener<Boolean>() {
      @Override
      public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        if (newValue == false) {
          // loosing focus ...
          // try to bind
          showCompletionAndBind(false, true);
          // close menu anyway
          if (contextMenu.isShowing()) {
            contextMenu.hide();
          }
          // check if entry can be bind to list ??
          delegate.isInputValid();
        }
        // Call onUpdate() here ....
        if (AutoCompleteContextMenu.this.getOnKeyTyped() != null) {
          AutoCompleteContextMenu.this.getOnKeyTyped().handle(null);
        }
      }
    });



    this.items = ListSequence.fromList(new ArrayList<String>());
  }

  public void setDelegate(IDataUxDelegate dlgt) {
    delegate = dlgt;
  }


  private void populateMenu(List<String> items) {
    contextMenu.getItems().clear();
    for (String result : items) {
      Label itemLabel = new Label(result);
      CustomMenuItem menuItem = new CustomMenuItem(itemLabel, true);
      menuItem.setUserData(itemLabel.getText());
      contextMenu.getItems().add(menuItem);
      //  handle item selection
      menuItem.setOnAction(new EventHandler<ActionEvent>() {
        @Override
        public void handle(ActionEvent actionEvent) {
          AutoCompleteContextMenu.this.setItem((String) ((CustomMenuItem) actionEvent.getSource()).getUserData());
          // Call onUpdate() here ....
          if (AutoCompleteContextMenu.this.getOnKeyTyped() != null) {
            AutoCompleteContextMenu.this.getOnKeyTyped().handle(null);
          }
        }
      });

    }
  }
  public void setItems(List<String> items) {
    this.items = items;
  }
  public String getItem() {
    for (int i = 0; i < this.items.size(); i++) {
      if (this.getText().toLowerCase().equals(items.get(i).toLowerCase())) {
        return items.get(i);
      }
    }
    return null;
  }
  public void setItem(String item) {
    if (item != null) {

      for (int i = 0; i < this.items.size(); i++) {
        if (item.toLowerCase().equals(items.get(i).toLowerCase())) {
          // disable update handler ...
          populateContextMenu = false;
          this.setText(items.get(i));
          this.selectAll();
          delegate.isInputValid();

          populateContextMenu = true;
          return;
        }
      }
      if (this.items.size() > 0) {
        String error = "'" + item + "' not in reference scope (len " + this.items.size() + "). programming error.";
        this.setText(error);
        throw new RuntimeException(error);

      } else {
        // accept text ??? no scope given ... hopefully in disabled mode : )
        populateContextMenu = false;
        this.setText(item);
        this.selectAll();
        delegate.isInputValid();

        populateContextMenu = true;
      }

    } else {
      populateContextMenu = false;
      this.setText("");
      populateContextMenu = true;
    }
  }
  public List<String> filterItems(String searchText) {
    searchText = searchText.toLowerCase();
    List<String> result = new ArrayList<String>();

    for (int i = 0; i < this.items.size(); i++) {
      if (this.items.get(i).toLowerCase().contains(searchText)) {
        result.add(this.items.get(i));
      }
    }
    return result;
  }
  public void showCompletionAndBind(boolean all, boolean focusChanged) {
    String text = this.getText().trim();
    List<String> results;

    if (text.trim().equals("")) {
      all = true;
    }

    if (all) {
      results = items;
    } else {
      results = filterItems(text);
    }

    if (results.size() >= 20) {
      results = results.subList(0, 20);
    }


    // okay, when loosing focus and the result is only one, but the txt equals nothing, we should
    // not bind ...
    if (focusChanged && results.size() == 1 && !(all)) {
      setItem(results.get(0));
      // Call onUpdate() here ....
      if (AutoCompleteContextMenu.this.getOnKeyTyped() != null) {
        AutoCompleteContextMenu.this.getOnKeyTyped().handle(null);
      }
      if (contextMenu.isShowing()) {
        contextMenu.hide();
      }
    } else if (!(focusChanged)) {
      populateMenu(results);
      if (!(contextMenu.isShowing())) {
        contextMenu.show(AutoCompleteContextMenu.this, Side.BOTTOM, 10, -5);
      }
      contextMenu.requestFocus();
    }

  }
}
