package org.modellwerkstatt.fx8forms.delegates;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_ReferenceEditor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import javafx.geometry.Pos;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Clipboard;
import javafx.scene.control.Tooltip;
import java.util.List;
import javafx.scene.layout.HBox;
import javafx.event.ActionEvent;
import javafx.scene.layout.Priority;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;

public class FX8ReferenceEditor implements IToolkit_ReferenceEditor {
  protected AutoCompletePopupField autoCompleteField;
  protected Node complexRightPart;
  protected Button updateConclusionButton;

  protected Label label;
  protected IDataUxDelegate delegate;


  public FX8ReferenceEditor() {

    label = new Label();
    label.getStyleClass().add("delegateLabel");
    label.setLabelFor(autoCompleteField);
    label.setAlignment(Pos.TOP_RIGHT);

    autoCompleteField = new AutoCompletePopupField();
    autoCompleteField.getStyleClass().add("delegateControl");
    autoCompleteField.setMinHeight(FX8TextEditor.DELEGATE_EDITOR_MINHEIGH);
    autoCompleteField.setPrefWidth(250.0);
    complexRightPart = autoCompleteField;

    label.setOnMouseClicked(new EventHandler<MouseEvent>() {
      @Override
      public void handle(MouseEvent event) {
        if (event.getClickCount() == 2 && event.getButton().equals(MouseButton.PRIMARY)) {
          ClipboardContent allContent = new ClipboardContent();
          allContent.putString(autoCompleteField.getText());
          Clipboard.getSystemClipboard().setContent(allContent);
        }
      }
    });

  }

  public void setDelegate(IDataUxDelegate dlgt) {
    delegate = dlgt;
    autoCompleteField.setDelegate(delegate);
  }

  public void enableKeyReleaseEvents() {
    autoCompleteField.issueBoundEvent();
  }

  public void setLabelTooltip(String t) {
    label.setTooltip(new Tooltip(t));
  }

  public void setValidationErrorText(String text) {

    if (text == null || text.trim().equals("")) {
      // ToDO: Known JAVAFX Bug..
      autoCompleteField.setStyle("-fx-border-color: -error-red; -fx-border-width: 0;");
      autoCompleteField.setTooltip(null);

    } else {
      autoCompleteField.setStyle("-fx-border-color: -error-red; -fx-border-width: 1;");
      autoCompleteField.setTooltip(new Tooltip(text));

    }
  }

  public void setLabel(String labelString) {
    label.setText(FX8TextEditor.getLabelTextAdjustColon(labelString));
    label.setMinWidth(FX8TextEditor.getLabelWidthWRKRND(labelString));
  }

  public void setEnabled(boolean enabled) {
    autoCompleteField.setDisable(!(enabled));
    if (updateConclusionButton != null) {
      updateConclusionButton.setDisable(!(enabled));
    }
  }


  @Override
  public void newObjectBound() {
    autoCompleteField.newObjectBound();
  }
  public void setText(String text) {
    autoCompleteField.setItem(text);
  }
  public String getText() {
    return autoCompleteField.getItem();
  }
  public void setItems(List<String> items) {
    autoCompleteField.setItems(items);
  }
  public void setEditorPrompt(String promptText) {
    autoCompleteField.setPromptText(promptText);
  }
  public void setIssuesUpdateConclusion() {
    HBox box = new HBox();
    updateConclusionButton = FX8TextEditor.createUpdateButton();
    updateConclusionButton.setOnAction(new EventHandler<ActionEvent>() {
      public void handle(ActionEvent p0) {
        String text = autoCompleteField.getText().trim();

        if (delegate.isInputValid() == null) {
          String item = autoCompleteField.getItem();

          if (autoCompleteField.provideHintEnabled && item == null && !(text.equals(""))) {
            // cleared by getItem() ..
            autoCompleteField.setText(text);
            autoCompleteField.provideHint();

          } else {
            autoCompleteField.setLastItemIssuedUpdate(item);
            delegate.issueUpdateConclusionAfterContentChange();

          }

        }

      }
    });

    box.getChildren().addAll(autoCompleteField, updateConclusionButton);
    HBox.setHgrow(autoCompleteField, Priority.ALWAYS);
    complexRightPart = box;
    autoCompleteField.setIssueUpdate();
  }
  public Object getEditor() {
    return autoCompleteField;
  }
  public Object getLabel() {
    return label;
  }
  public Object getRightPartComponent() {
    return complexRightPart;
  }
  public void setOptionalAfterLoad(boolean optional) {
    autoCompleteField.setOptional(optional);
  }
  @Override
  public void setOption(IToolkit_TextEditor.Option... option) {
    if (IToolkit_TextEditor.has(IToolkit_TextEditor.Option.PROVIDE_HINT, option)) {
      autoCompleteField.setProvideHint();
    }
  }
  public void gcClear() {
    autoCompleteField.setOnKeyReleased(null);
    autoCompleteField.setDelegate(null);
  }
}
