package org.modellwerkstatt.fx8forms.delegates;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_StatusEditor;
import javafx.event.EventHandler;
import javafx.scene.input.KeyEvent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.Node;
import javafx.scene.control.Button;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Pos;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Clipboard;
import org.modellwerkstatt.fx8forms.windows.FX8Application;
import javafx.scene.input.KeyCode;
import org.modellwerkstatt.fx8forms.windows.FX8TraversalHelper;
import javafx.scene.control.Tooltip;
import java.util.List;
import javafx.scene.layout.HBox;
import javafx.event.ActionEvent;
import javafx.scene.layout.Priority;
import javafx.beans.value.ObservableValue;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;

public class FX8StatusEditor implements IToolkit_StatusEditor, EventHandler<KeyEvent> {

  protected ComboBox comboBox;
  protected Label label;
  protected Node complexRightPart;
  protected Button updateConclusionButton;

  protected IDataUxDelegate delegate;
  protected boolean notifyDelegateOnKeyPress;

  protected boolean issueUpdateConclusion;
  protected boolean programmaticValueChange;
  protected int lastIndexIssuedUpdate;
  protected ChangeListener<Object> changeListener;


  public FX8StatusEditor() {
    notifyDelegateOnKeyPress = false;
    lastIndexIssuedUpdate = -1;
    issueUpdateConclusion = false;
    changeListener = null;
    programmaticValueChange = false;

    label = new Label();
    label.getStyleClass().add("delegateLabel");
    label.setLabelFor(comboBox);
    label.setAlignment(Pos.TOP_RIGHT);

    comboBox = new ComboBox();
    comboBox.getStyleClass().add("delegateControl");
    comboBox.setMinHeight(FX8TextEditor.DELEGATE_EDITOR_MINHEIGH);
    // necessary for windows.
    comboBox.setMaxHeight(FX8TextEditor.DELEGATE_EDITOR_MINHEIGH);
    comboBox.setPrefWidth(250.0);
    complexRightPart = comboBox;

    label.setOnMouseClicked(new EventHandler<MouseEvent>() {
      @Override
      public void handle(MouseEvent event) {
        if (event.getClickCount() == 2 && event.getButton().equals(MouseButton.PRIMARY)) {
          ClipboardContent allContent = new ClipboardContent();
          allContent.putString(comboBox.getSelectionModel().getSelectedItem().toString());
          Clipboard.getSystemClipboard().setContent(allContent);
        }
      }
    });

    comboBox.addEventFilter(KeyEvent.KEY_PRESSED, this);
  }

  public void handle(KeyEvent event) {

    if (FX8Application.FX8_IS_HOTKEY_TO_FORWARD(event.getCode().getName(), true) && comboBox.getScene() != null) {
      comboBox.getScene().getOnKeyPressed().handle(event);

    } else if ((event.getCode() == KeyCode.TAB && !(event.isShiftDown())) || event.getCode() == KeyCode.ENTER) {
      event.consume();


      if (issueUpdateConclusion && !(getSelectedIndex() == lastIndexIssuedUpdate) && !(comboBox.isDisabled())) {
        lastIndexIssuedUpdate = getSelectedIndex();
        delegate.issueUpdateConclusionAfterContentChange();

      } else {
        FX8TraversalHelper.traverseNext(comboBox);

      }


    } else if ((event.getCode() == KeyCode.TAB && event.isShiftDown())) {
      event.consume();

      FX8TraversalHelper.traversePrevious(comboBox);
    }


  }


  public void setDelegate(IDataUxDelegate dlgt) {
    delegate = dlgt;
  }

  public void enableKeyReleaseEvents() {
    notifyDelegateOnKeyPress = true;

    comboBox.setOnKeyReleased(new EventHandler<KeyEvent>() {
      public void handle(KeyEvent p0) {
        if (notifyDelegateOnKeyPress) {
          delegate.keyReleasedEvent();
        }
      }
    });
  }

  public void setLabelTooltip(String t) {
    label.setTooltip(new Tooltip(t));
  }

  public void setEditorPrompt(String promptText) {
    comboBox.setPromptText(promptText);
  }
  public void setValidationErrorText(String text) {

    if (text == null || text.trim().equals("")) {
      // ToDO: Known JAVAFX Bug..
      comboBox.setStyle("-fx-border-color: red; -fx-border-width: 0;");
      comboBox.setTooltip(null);

    } else {
      comboBox.setStyle("-fx-border-color: red; -fx-border-width: 1;");
      comboBox.setTooltip(new Tooltip(text));
    }
  }

  public void setLabel(String labelString) {
    label.setText(FX8TextEditor.getLabelTextAdjustColon(labelString));
    label.setMinWidth(FX8TextEditor.getLabelWidthWRKRND(labelString));
  }

  public void setEnabled(boolean enabled) {
    comboBox.setDisable(!(enabled));
    if (updateConclusionButton != null) {
      updateConclusionButton.setDisable(!(enabled));
    }
  }


  @Override
  public void newObjectBound() {
    lastIndexIssuedUpdate = -1;
  }
  public void setText(String text) {
    throw new RuntimeException("not implemented.");
  }
  public String getText() {
    throw new RuntimeException("not implemented.");
  }
  public int getSelectedIndex() {
    return comboBox.getSelectionModel().getSelectedIndex();
  }
  public void setSelectedIndex(int i) {
    programmaticValueChange = true;
    comboBox.getSelectionModel().select(i);
    programmaticValueChange = false;
  }
  public void setItems(List<String> items) {
    programmaticValueChange = true;
    comboBox.getItems().clear();
    comboBox.getItems().addAll(items);
    programmaticValueChange = false;
  }


  public void setIssuesUpdateConclusion() {
    HBox box = new HBox();
    updateConclusionButton = FX8TextEditor.createUpdateButton();
    updateConclusionButton.setOnAction(new EventHandler<ActionEvent>() {
      public void handle(ActionEvent p0) {
        lastIndexIssuedUpdate = getSelectedIndex();
        delegate.issueUpdateConclusionAfterContentChange();
      }
    });

    box.getChildren().addAll(comboBox, updateConclusionButton);
    HBox.setHgrow(comboBox, Priority.ALWAYS);
    complexRightPart = box;

    changeListener = new ChangeListener<Object>() {
      public void changed(ObservableValue<? extends Object> p0, Object p1, Object p2) {

        if (programmaticValueChange) {
          return;
        }

        if (issueUpdateConclusion && !(getSelectedIndex() == lastIndexIssuedUpdate) && !(comboBox.isDisabled())) {
          lastIndexIssuedUpdate = getSelectedIndex();
          delegate.issueUpdateConclusionAfterContentChange();

        }
      }
    };

    comboBox.valueProperty().addListener(changeListener);

    issueUpdateConclusion = true;
  }
  public Object getEditor() {
    return comboBox;
  }
  public Object getLabel() {
    return label;
  }
  public Object getRightPartComponent() {
    return complexRightPart;
  }
  @Override
  public void setOption(IToolkit_TextEditor.Option... option) {
  }
  public void gcClear() {
    comboBox.removeEventFilter(KeyEvent.KEY_PRESSED, this);
    if (changeListener != null) {
      comboBox.valueProperty().removeListener(changeListener);
    }
    delegate = null;
  }
}
