package org.modellwerkstatt.fx8forms.windows;

/*Generated by MPS */

import javafx.scene.layout.HBox;
import java.util.List;
import org.modellwerkstatt.dataux.runtime.genspecifications.CmdAction;
import org.modellwerkstatt.dataux.runtime.genspecifications.Menu;
import javafx.scene.control.ContextMenu;
import javafx.geometry.Pos;
import org.modellwerkstatt.dataux.runtime.genspecifications.AbstractAction;
import javafx.scene.image.ImageView;
import javafx.scene.image.Image;
import javafx.event.EventHandler;
import javafx.event.ActionEvent;
import javafx.scene.control.MenuButton;
import javafx.geometry.Insets;
import javafx.scene.input.KeyEvent;
import jetbrains.mps.internal.collections.runtime.ListSequence;

public class FX8ActionHBox extends HBox {

  private List<CmdAction> cmdTrgs;

  public FX8ActionHBox(Menu folder, ContextMenu cm) {
    super();
    setAlignment(Pos.BASELINE_RIGHT);
    getStyleClass().add("conclusionButtonBox");
    getStyleClass().add("FX8ConclusionButtonsBox");

    List<AbstractAction> confs = folder.getAllItems();
    // top level items are simple buttons

    for (AbstractAction currentItem : confs) {
      // Former way of addin buttons directly
      // but actually deprecated ...
      if (currentItem instanceof CmdAction) {
        final CmdAction trigger = ((CmdAction) currentItem);
        final FX8Button b = new FX8Button(trigger.labelText, trigger.getToolTip());
        b.getStyleClass().add("FX8StatusButton");
        b.setGraphic(new ImageView(new Image(FX8UiFactory.getImage("label_white"))));

        b.setOnAction(new EventHandler<ActionEvent>() {
          @Override
          public void handle(ActionEvent p0) {
            b.setDisable(true);
            trigger.startCommand();

          }
        });


        trigger.attachButton1(b);
        this.getChildren().add(b);

      } else {

        // 2nd level items are in a menu button
        // null is a seperator
        if (currentItem.labelText == null) {
          // skip

        } else {
          // obviously a folder ..
          Image img = new Image(FX8UiFactory.getImage("menu"));
          MenuButton b = new MenuButton(currentItem.labelText, new ImageView(img));
          b.setPadding(new Insets(0, 0, 0, 0));
          FX8Application.createMenuStructure(b.getItems(), (Menu) currentItem, false);
          this.getChildren().add(b);

          // do we also have to add that to the context menu?
          if (cm != null) {
            FX8Application.createMenuStructure(cm.getItems(), (Menu) currentItem, true);
          }

        }

      }
    }

    // install those triggers and translate hotkeys ..
    cmdTrgs = folder.getAllCmdActionsOfMenu();
  }

  public void hotKeyReceived(KeyEvent event) {
    // right now used in FX8TableForm
    String key = event.getCode().getName().toUpperCase();
    // trg hotkey can be null
    for (CmdAction action : cmdTrgs) {
      if (key.equals(action.hotKey)) {
        event.consume();
        if (action.reevalEnabled()) {
          action.startCommand();
        }
        return;
      }
    }
  }

  public void doubleClickReceived() {
    // trg hotkey can be null
    for (CmdAction action : cmdTrgs) {
      if ("ENTER".equals(action.hotKey) && action.reevalEnabled()) {
        action.startCommand();
      }
    }
  }

  public void gcClear() {
    ListSequence.fromList(cmdTrgs).visitAll((it) -> it.gcClear());
  }
}
