package org.modellwerkstatt.fx8forms.windows;

/*Generated by MPS */

import javafx.scene.layout.GridPane;
import java.util.List;
import org.modellwerkstatt.dataux.runtime.utils.LayoutConstraint;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.Priority;
import javafx.scene.Node;

public class FX8ColFormContainer {
  private GridPane gridPane;
  private List<LayoutConstraint> colConstrains;
  private int colPos;
  public FX8ColFormContainer(List<LayoutConstraint> lc) {
    gridPane = new GridPane();
    colConstrains = lc;
    colPos = 0;


    final boolean usePxl = ListSequence.fromList(this.colConstrains).any((it) -> it.isPxl());
    ListSequence.fromList(this.colConstrains).visitAll((it) -> {
      ColumnConstraints colConstrain = new ColumnConstraints();
      // (1) see docu. On pxl use pixl, but for others grow
      // (2) for minimal use nothing
      // (3) for weight use percent, but only when not combined with pxl

      if (it.isPxl()) {
        colConstrain.setPrefWidth(it.getPixl());
      } else if (it.isMinimal()) {
        // nothing - minimal
      } else {
        if (usePxl) {
          colConstrain.setHgrow(Priority.ALWAYS);
        } else {
          colConstrain.setPercentWidth(it.getInPercent());

        }
      }

      gridPane.getColumnConstraints().add(colConstrain);
    });
  }
  public void addChild(Node child) {
    gridPane.add(child, colPos++, 0);
  }
  public Node getNode() {
    return gridPane;
  }
}
