package org.modellwerkstatt.fx8forms.windows;

/*Generated by MPS */

import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import org.modellwerkstatt.dataux.runtime.extensions.ITableCellStringConverter;
import org.modellwerkstatt.dataux.runtime.utils.ValueObjectReplacementFacility;
import javafx.geometry.Pos;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.input.KeyEvent;
import javafx.event.EventHandler;
import javafx.scene.input.KeyCode;
import javafx.scene.control.TablePosition;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;

public class FX8EditCellBigdeci<T> extends TableCell<T, Object> {
  private TextField textField;
  private String property;
  private ITableCellStringConverter convert;
  public FX8EditCellBigdeci(String p, ITableCellStringConverter conv) {
    convert = conv;
    property = p;
    getStyleClass().add("FX8EditCellBigdeci");

  }
  @Override
  public void startEdit() {
    if (!(isEmpty())) {
      super.startEdit();
      createTextField();
      setText(null);

      setGraphic(textField);
      textField.selectAll();
      textField.requestFocus();
    }
  }
  @Override
  public void cancelEdit() {
    super.cancelEdit();
    setText(convert.convert(getItem()));
    setGraphic(null);
  }

  public boolean commitChanges() {
    try {
      Object xxx = convert.convertBack(textField.getText());
      ValueObjectReplacementFacility.put(this.getTableView().getSelectionModel().getSelectedItem(), property, xxx);
      FX8EditCellBigdeci.this.commitEdit(xxx);
      // that results in a updateItem call ...
      // it s commented out on purpose ..

      return true;

    } catch (Exception e) {
      return false;
    }

  }

  @Override
  public void updateItem(Object item, boolean empty) {
    // empty is true, if we have a table cell at hand
    // which does not associated with a data item (item=null)
    super.updateItem(item, empty);
    setAlignment(Pos.BASELINE_RIGHT);

    if (empty) {
      setText(null);
      setGraphic(null);
    } else {

      if (isEditing()) {
        if (textField != null) {
          textField.setText(getString());
        }
        setText(null);
        setGraphic(textField);
      } else {
        setText(getString());
        setGraphic(null);
      }
    }
  }
  private void createTextField() {
    textField = new TextField(getString());
    textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2);
    textField.focusedProperty().addListener(new ChangeListener<Boolean>() {
      @Override
      public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldValue, Boolean newValue) {
        if (!(newValue) && isEditing()) {
          cancelEdit();
        }
      }
    });

    textField.addEventFilter(KeyEvent.KEY_PRESSED, new EventHandler<KeyEvent>() {
      @Override
      public void handle(KeyEvent keyEvent) {

        if (keyEvent.getCode().equals(KeyCode.ESCAPE)) {
          keyEvent.consume();
          cancelEdit();

        } else if (keyEvent.getCode().equals(KeyCode.ENTER)) {
          keyEvent.consume();
          adjustPosition(true, 1);

        } else if (keyEvent.getCode().equals(KeyCode.DOWN)) {
          keyEvent.consume();
          adjustPosition(true, 1);

        } else if (keyEvent.getCode().equals(KeyCode.UP)) {
          keyEvent.consume();
          adjustPosition(true, -1);

        }




      }
    });





  }


  public void adjustPosition(boolean commit, int posdiff) {
    boolean okay = true;
    TablePosition pos = FX8EditCellBigdeci.this.getTableView().getEditingCell();

    if (commit) {
      okay = commitChanges();
    } else {
      cancelEdit();
      okay = false;
    }

    if (okay) {
      // get current index ..

      // posdiff is -1 or 1
      final int requestedIndex = pos.getRow() + posdiff;
      final int colIndex = pos.getColumn();

      int total = getTableView().getItems().size();

      if (requestedIndex >= total || requestedIndex < 0) {
        // we r done.
        Platform.runLater(new Runnable() {
          public void run() {
            FX8EditCellBigdeci.this.getTableView().requestFocus();
          }
        });


      } else {
        // okay adjust ..


        // Changed 12 Oct 15 Dan
        // struggeling with javaFX fore some time now and came to a new solution.
        // adjust table selection by faking a UP / DOWN key event
        // which will end up in scrolling behaviour.
        if (posdiff == 1) {
          getTableView().fireEvent(new KeyEvent(this, getTableView(), KeyEvent.KEY_PRESSED, "DOWN", "DOWN", KeyCode.DOWN, false, false, false, false));

        } else if (posdiff == -1) {
          getTableView().fireEvent(new KeyEvent(this, getTableView(), KeyEvent.KEY_PRESSED, "UP", "UP", KeyCode.UP, false, false, false, false));

        } else {
          throw new RuntimeException("This can not be true.");

        }

        Platform.runLater(new Runnable() {
          public void run() {
            ObservableList<TableColumn<T, ?>> columnList = FX8EditCellBigdeci.this.getTableView().getColumns();
            if (colIndex < columnList.size()) {
              FX8EditCellBigdeci.this.getTableView().edit(requestedIndex, columnList.get(colIndex));
            }
          }
        });

      }
    }
  }

  private String getString() {
    return (getItem() == null ? "" : convert.convert(getItem()));
  }
}
