package org.modellwerkstatt.fx8forms.windows;

/*Generated by MPS */

import javafx.scene.control.TableCell;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;
import org.modellwerkstatt.dataux.runtime.delegates.TableCellStatusConverter;
import org.modellwerkstatt.dataux.runtime.extensions.ITableCellStringConverter;
import org.modellwerkstatt.dataux.runtime.utils.ValueObjectReplacementFacility;
import javafx.geometry.Pos;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import javafx.scene.input.KeyEvent;
import javafx.event.EventHandler;
import javafx.scene.input.KeyCode;
import javafx.scene.control.TablePosition;
import javafx.application.Platform;
import javafx.scene.layout.HBox;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class FX8EditCellStatus extends TableCell<Object, IOFXMetaStatus.IOFXStatusElement> {
  private RadioEditor statusField;
  private String property;
  private TableCellStatusConverter statusConverter;
  public FX8EditCellStatus(String p, ITableCellStringConverter conv) {
    statusConverter = ((TableCellStatusConverter) conv);
    property = p;
    getStyleClass().add("FX8EditCellStatus");
  }

  @Override
  public void startEdit() {
    if (!(isEmpty())) {
      super.startEdit();
      createRadioEditor();
      setText(null);

      setGraphic(statusField);
      statusField.myRequestFocus();
    }
  }
  @Override
  public void cancelEdit() {
    super.cancelEdit();
    setText(getItem().getShortDesc());
    setGraphic(null);
  }

  public boolean commitChanges(String shortDesc) {
    try {
      IOFXMetaStatus.IOFXStatusElement xxx = statusConverter.convertBack(shortDesc);
      ValueObjectReplacementFacility.put(this.getTableView().getSelectionModel().getSelectedItem(), property, xxx);
      FX8EditCellStatus.this.commitEdit(xxx);
      // that results in a updateItem call ...
      // it s commented out on purpose ..

      return true;
    } catch (Exception ex) {
      return false;
    }

  }

  @Override
  public void updateItem(IOFXMetaStatus.IOFXStatusElement item, boolean empty) {
    // empty is true, if we have a table cell at hand
    // which does not associated with a data item (item=null)
    super.updateItem(item, empty);
    setAlignment(Pos.BASELINE_RIGHT);

    if (empty) {
      setText(null);
      setGraphic(null);
    } else {

      if (isEditing()) {
        if (statusField != null) {
          statusField.setValue(getString());
        }
        setText(null);
        setGraphic(statusField);
      } else {
        setText(getString());
        setGraphic(null);
      }
    }
  }
  private void createRadioEditor() {
    List<String> allShortTexts = ListSequence.fromList(new ArrayList<String>());

    for (IOFXMetaStatus.IOFXStatusElement elem : statusConverter.getAllElements()) {
      ListSequence.fromList(allShortTexts).addElement(elem.getShortDesc());
    }
    statusField = new RadioEditor(getString(), allShortTexts, this);
    statusField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2);


    statusField.addEventFilter(KeyEvent.KEY_PRESSED, new EventHandler<KeyEvent>() {
      @Override
      public void handle(KeyEvent keyEvent) {

        if (keyEvent.getCode().equals(KeyCode.ESCAPE)) {
          keyEvent.consume();
          cancelEdit();

        } else if (keyEvent.getCode().equals(KeyCode.ENTER)) {
          keyEvent.consume();
          adjustPosition(true, 1);

        } else if (keyEvent.getCode().equals(KeyCode.DOWN)) {
          keyEvent.consume();
          adjustPosition(true, 1);

        } else if (keyEvent.getCode().equals(KeyCode.UP)) {
          keyEvent.consume();
          adjustPosition(true, -1);

        } else {
        }

      }
    });

  }


  public void adjustPosition(boolean commit, int posdiff) {
    boolean okay = true;
    TablePosition pos = FX8EditCellStatus.this.getTableView().getEditingCell();


    if (commit) {
      okay = commitChanges(statusField.getValue());
    } else {
      cancelEdit();
      okay = false;
    }

    if (okay) {
      // get current index ..


      final int requestedIndex = pos.getRow() + posdiff;
      final int colIndex = pos.getColumn();

      int total = getTableView().getItems().size();
      if (requestedIndex >= total || requestedIndex < 0) {
        // we r done.
        Platform.runLater(new Runnable() {
          public void run() {
            FX8EditCellStatus.this.getTableView().requestFocus();
          }
        });


      } else {
        // okay adjust ..

        // Changed 12 Oct 15 Dan
        // struggeling with javaFX fore some time now and came to a new solution.
        // adjust table selection by faking a UP / DOWN key event
        // which will end up in scrolling behaviour.
        if (posdiff == 1) {
          getTableView().fireEvent(new KeyEvent(this, getTableView(), KeyEvent.KEY_PRESSED, "DOWN", "DOWN", KeyCode.DOWN, false, false, false, false));

        } else if (posdiff == -1) {
          getTableView().fireEvent(new KeyEvent(this, getTableView(), KeyEvent.KEY_PRESSED, "UP", "UP", KeyCode.UP, false, false, false, false));

        } else {
          throw new RuntimeException("This can not be true.");

        }

        Platform.runLater(new Runnable() {
          public void run() {
            FX8EditCellStatus.this.getTableView().edit(requestedIndex, FX8EditCellStatus.this.getTableView().getColumns().get(colIndex));
          }
        });

      }
    }
  }

  private String getString() {
    return (getItem() == null ? "(null)" : getItem().getShortDesc());
  }


  public static class RadioEditor extends HBox {
    private List<ToggleButton> toggleButtons;
    private FX8EditCellStatus editCell;

    public RadioEditor(final String currentValue, List<String> values, FX8EditCellStatus eC) {
      super();
      setAlignment(Pos.BASELINE_RIGHT);
      editCell = eC;
      toggleButtons = new ArrayList<ToggleButton>();
      getStyleClass().add("FX8EditCellStatusRadioEditor");

      final ToggleGroup grp = new ToggleGroup();

      ListSequence.fromList(values).visitAll((val) -> {
        ToggleButton r1 = new ToggleButton(val);
        r1.setToggleGroup(grp);
        if (val.equals(currentValue)) {
          r1.setSelected(true);
        }

        r1.setOnKeyTyped(new EventHandler<KeyEvent>() {
          public void handle(KeyEvent p0) {
            if (p0.getCode().equals(KeyCode.ENTER)) {
              p0.consume();
              editCell.commitChanges(((ToggleButton) p0.getSource()).getText());

            }
          }
        });

        r1.setOnMouseClicked(new EventHandler<MouseEvent>() {
          public void handle(MouseEvent p0) {
            editCell.commitChanges(((ToggleButton) p0.getSource()).getText());
            // and refocus table ?
            Platform.runLater(new Runnable() {
              public void run() {
                editCell.getTableView().requestFocus();
              }
            });
          }
        });

        // check for focus property -> cancel Edit
        r1.focusedProperty().addListener(new ChangeListener<Boolean>() {
          @Override
          public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldValue, Boolean newValue) {
            if (oldValue && !(newValue) && editCell.isEditing()) {
              Platform.runLater(new Runnable() {
                public void run() {
                  // is any other button focussed?
                  boolean focussed = false;
                  for (int i = 0; i < toggleButtons.size(); i++) {
                    focussed |= toggleButtons.get(i).isFocused();
                  }

                  if (!(focussed)) {
                    editCell.cancelEdit();
                  }
                }
              });
            }
          }
        });

        toggleButtons.add(r1);
        RadioEditor.this.getChildren().add(r1);
      });
    }


    public void myRequestFocus() {
      ToggleButton currentButton;
      for (int i = 0; i < toggleButtons.size(); i++) {
        currentButton = toggleButtons.get(i);
        if (currentButton.isSelected()) {
          currentButton.requestFocus();
          return;
        }
      }
    }

    public void setValue(String val) {
      ToggleButton currentButton;
      for (int i = 0; i < toggleButtons.size(); i++) {
        currentButton = toggleButtons.get(i);
        if (currentButton.getText().equals(val)) {
          currentButton.setSelected(true);
          return;
        }
      }
    }
    public String getValue() {
      ToggleButton currentButton;
      for (int i = 0; i < toggleButtons.size(); i++) {
        currentButton = toggleButtons.get(i);
        if (currentButton.isSelected()) {
          return currentButton.getText();
        }
      }
      throw new IllegalStateException("This can not happen.");
    }

  }
}
