package org.modellwerkstatt.fx8forms.windows;

/*Generated by MPS */

import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.core.IApplication;
import javafx.event.EventHandler;
import javafx.event.ActionEvent;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import javafx.geometry.Insets;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.KeyCode;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import javafx.scene.control.TableView;
import javafx.scene.control.TableColumn;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;
import javafx.scene.control.TableCell;
import javafx.scene.image.ImageView;
import javafx.collections.FXCollections;
import javafx.scene.control.Label;

public class FX8ErrorReporter extends FX8Prompt {
  private static final String msgboxTextLabel = "msgboxTextLabel";
  private static final String msgboxImagePadding = "msgboxImagePadding";

  private boolean okButtonPressed = false;

  private Button okButton;
  private BorderPane buttonBox;
  private IToolkit_UiFactory factory;
  private IApplication.DlgRunnable runner;
  private int userLangIndex;
  private EventHandler<ActionEvent> confirmAction;

  private Image warningImg;
  private Image problemImg;

  public FX8ErrorReporter(IToolkit_UiFactory fact, Stage parentStage, int langIndex) {
    super(parentStage, new BorderPane(), FX8Prompt.Size.AUTO_FROMCONTENT);
    userLangIndex = langIndex;
    factory = fact;

    promptContent.setPadding(new Insets(10));
    buttonBox = new BorderPane();

    okButton = new Button(fact.getSystemLabel(userLangIndex, MoWareTranslations.Key.OK_BUTTON) + " (F12)");
    okButton.getStyleClass().add("FX8Button");

    confirmAction = new EventHandler<ActionEvent>() {
      public void handle(ActionEvent event) {
        close();

        okButtonPressed = true;
        if (runner != null) {
          runner.run(true);
        }
      }
    };
    okButton.setOnAction(confirmAction);

    warningImg = new Image(FX8UiFactory.getImage("warning"));
    problemImg = new Image(FX8UiFactory.getImage("problem"));


    promptStage.getScene().setOnKeyPressed(new EventHandler<KeyEvent>() {
      @Override
      public void handle(KeyEvent keyEvent) {
        if (keyEvent.getCode().equals(KeyCode.F12)) {
          keyEvent.consume();
          close();

          okButtonPressed = true;
          if (runner != null) {
            runner.run(true);
          }

        }
      }
    });

    promptContent.setBottom(buttonBox);
  }



  private void buildUi(String heading, List<IOFXProblem> info) {
    TableView table = new TableView();

    TableColumn msgType = new TableColumn("");
    TableColumn message = new TableColumn("Message");

    msgType.setCellValueFactory(new PropertyValueFactory<IOFXProblem, String>("warningOnly"));
    message.setCellValueFactory(new PropertyValueFactory<IOFXProblem, String>("simpleText_Lgcy"));

    msgType.setCellFactory(new Callback<TableColumn<Object, Object>, TableCell<Object, Object>>() {
      @Override
      public TableCell<Object, Object> call(TableColumn<Object, Object> p1) {

        TableCell<Object, Object> cell = new TableCell<Object, Object>() {
          @Override
          protected void updateItem(Object object, boolean b) {
            if (Boolean.TRUE.equals(object)) {
              this.setGraphic(new ImageView(warningImg));

            } else if (Boolean.FALSE.equals(object)) {
              this.setGraphic(new ImageView(problemImg));
            }
            super.updateItem(object, b);
          }
        };

        return cell;
      }
    });


    message.setMinWidth(550);
    table.getColumns().add(msgType);
    table.getColumns().add(message);
    table.setItems(FXCollections.observableArrayList(info));

    promptContent.setCenter(table);

    Label l2 = new Label(heading);
    l2.getStyleClass().add(FX8FormContainer.formTitleLabel);

    promptContent.setTop(l2);

    ImageView view;
    view = new ImageView(new Image(FX8UiFactory.getImage("big_information")));

    view.getStyleClass().add(msgboxImagePadding);
    BorderPane pane = new BorderPane();
    pane.getStyleClass().add(msgboxImagePadding);
    pane.setTop(view);
    promptContent.setLeft(pane);


    okButton.setDefaultButton(true);
    buttonBox.setRight(okButton);
  }





  public void showInformation(List<IOFXProblem> information, IApplication.DlgRunnable runnable) {

    buildUi(factory.getSystemLabel(userLangIndex, MoWareTranslations.Key.INFORMATION), information);

    runner = runnable;

    this.open();
  }




}
