package org.modellwerkstatt.fx8forms.windows;

/*Generated by MPS */

import javafx.scene.layout.VBox;
import javafx.geometry.Insets;
import javafx.scene.control.Label;
import org.modellwerkstatt.objectflow.runtime.Workarounds2;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import javafx.scene.layout.HBox;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.event.EventHandler;
import javafx.event.ActionEvent;

public class FX8FlagBox extends VBox {
  private Insets oneLineInsets = new Insets(6, 0, 6, 4);
  private Insets moreLineInsets = new Insets(0, 0, 2, 4);
  private static final int minHeight = 16;

  private String[] splittedTittles = new String[]{"", null};
  private Label defaultLabelForTitle;
  private Label defaultLabelForSubTitle;


  public FX8FlagBox() {
    super();

    this.setPadding(oneLineInsets);
    defaultLabelForTitle = new Label("");
    defaultLabelForTitle.getStyleClass().add(FX8FormContainer.formTitleLabel);
    defaultLabelForTitle.setMinHeight(minHeight);

    this.getChildren().add(defaultLabelForTitle);
  }

  public void inRootForm() {
    defaultLabelForTitle.getStyleClass().clear();
    defaultLabelForTitle.getStyleClass().add(FX8FormContainer.formMainTitleLabel);
  }

  public void setTitle(String t) {
    splittedTittles = Workarounds2.getMainAndSubTitle(t);
    adjustToTitle();
  }

  public void flag(List<IOFXProblem> listOfProblems) {

    if (ListSequence.fromList(listOfProblems).count() == 0) {
      // stop flagging
      adjustToTitle();

    } else {
      this.getChildren().clear();

      int numLines = 0;

      if (!("".equals(splittedTittles[0]))) {
        numLines++;
        this.getChildren().add(defaultLabelForTitle);
      }

      if (splittedTittles[1] != null) {
        numLines++;
        this.getChildren().add(defaultLabelForSubTitle);
      }

      numLines += ListSequence.fromList(listOfProblems).count();

      if (numLines > 1) {
        this.setPadding(moreLineInsets);
      } else {
        this.setPadding(oneLineInsets);
      }


      boolean shrink = ListSequence.fromList(listOfProblems).count() > 1;
      boolean conntainsAction = ListSequence.fromList(listOfProblems).any((it) -> it.getResolveActionOrNull() != null);
      Double extra = 1.5;

      for (IOFXProblem prblm : listOfProblems) {
        Label problemLabel = new Label(prblm.getSimpleUserText());

        if (conntainsAction) {

        } else if (shrink) {
          problemLabel.setMinHeight(minHeight * extra);
          problemLabel.setMaxHeight(minHeight * extra);

        }

        if (prblm.isWarningOnly()) {
          problemLabel.getStyleClass().add(FX8FormContainer.formWarningLabel);
        } else {
          problemLabel.getStyleClass().add(FX8FormContainer.formFlagLabel);
        }

        if (prblm.getResolveActionOrNull() == null) {
          this.getChildren().add(problemLabel);

        } else {
          final IOFXSession.IUxEventActionable resolveActionOrNull = prblm.getResolveActionOrNull();
          HBox vbox = new HBox();
          vbox.setMaxHeight(minHeight * extra);
          vbox.setMinHeight(minHeight * extra);
          vbox.setSpacing(20);
          vbox.setAlignment(Pos.BASELINE_LEFT);

          Button btn = new Button(resolveActionOrNull.getLabelText());
          btn.setOnAction(new EventHandler<ActionEvent>() {
            public void handle(ActionEvent p0) {
              resolveActionOrNull.performAction();
            }
          });
          vbox.getChildren().addAll(problemLabel, btn);
          this.getChildren().add(vbox);

        }

      }
    }
  }

  public void adjustToTitle() {
    this.getChildren().clear();

    defaultLabelForTitle.setText(splittedTittles[0]);
    this.getChildren().add(defaultLabelForTitle);

    if (splittedTittles[1] != null) {
      if (defaultLabelForSubTitle == null) {
        defaultLabelForSubTitle = new Label("");
        defaultLabelForSubTitle.getStyleClass().add(FX8FormContainer.formTitleLabel);
        defaultLabelForSubTitle.setMinHeight(minHeight);
        defaultLabelForSubTitle.setPadding(new Insets(2, 0, 0, 0));

      }

      defaultLabelForSubTitle.setText(splittedTittles[1]);
      this.getChildren().add(defaultLabelForSubTitle);
      this.setPadding(moreLineInsets);

    } else {
      this.setPadding(oneLineInsets);

    }
  }

  public static void main(String[] args) {
    String test = "";
    String[] splitted = test.split("\n");

    System.err.println("Len " + splitted.length);
  }

}
