package org.modellwerkstatt.fx8forms.windows;

/*Generated by MPS */

import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_MainWindow;
import org.modellwerkstatt.dataux.runtime.core.IApplication;
import javafx.event.EventHandler;
import javafx.event.ActionEvent;
import javafx.stage.Stage;
import javafx.geometry.Insets;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import javafx.scene.image.ImageView;
import javafx.scene.image.Image;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.VBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.application.Platform;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Clipboard;
import java.util.List;
import javafx.scene.control.TreeTableView;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;

public class FX8MsgBox extends FX8Prompt {
  private static final String msgboxTextLabel = "msgboxTextLabel";
  private static final String msgboxImagePadding = "msgboxImagePadding";

  private boolean okButtonPressed = false;
  private boolean escAllowed = true;

  private Button okButton;
  private Button cancelButton;
  private BorderPane buttonBox;
  private IToolkit_UiFactory factory;
  private IToolkit_MainWindow.DlgType msgType;
  private IApplication.DlgRunnable runner;
  private int userLangIndex;
  private EventHandler<ActionEvent> confirmAction;

  public FX8MsgBox(IToolkit_UiFactory fact, Stage parentStage, IToolkit_MainWindow.DlgType type, int langIndex) {
    super(parentStage, new BorderPane(), (type == IToolkit_MainWindow.DlgType.INFO_LARGE || type == IToolkit_MainWindow.DlgType.ERROR_LARGE ? FX8Prompt.Size.FULLSSCREEN : FX8Prompt.Size.DEFAULT));
    userLangIndex = langIndex;
    factory = fact;
    msgType = type;

    promptContent.setPadding(new Insets(10));
    buttonBox = new BorderPane();

    okButton = new Button(fact.getSystemLabel(userLangIndex, MoWareTranslations.Key.OK_BUTTON) + " (F12)");
    okButton.getStyleClass().add("FX8Button");

    confirmAction = new EventHandler<ActionEvent>() {
      public void handle(ActionEvent event) {
        close();

        okButtonPressed = true;
        if (runner != null) {
          runner.run(true);
        }
      }
    };
    okButton.setOnAction(confirmAction);

    cancelButton = new Button(fact.getSystemLabel(userLangIndex, MoWareTranslations.Key.ESC_BUTTON));
    cancelButton.setOnAction(new EventHandler<ActionEvent>() {
      public void handle(ActionEvent event) {
        close();
        if (runner != null && msgType == IToolkit_MainWindow.DlgType.QUESTIONCLOSE_SMALL) {
          runner.run(false);
        }
      }
    });
    cancelButton.setGraphic(new ImageView(new Image(FX8UiFactory.getImage("arrow_back"))));


    promptStage.getScene().setOnKeyPressed(new EventHandler<KeyEvent>() {
      @Override
      public void handle(KeyEvent keyEvent) {
        if (keyEvent.getCode().equals(KeyCode.ESCAPE) && escAllowed) {
          keyEvent.consume();
          close();

          okButtonPressed = false;
          if (runner != null && msgType == IToolkit_MainWindow.DlgType.QUESTIONCLOSE_SMALL) {
            runner.run(false);
          }

        }
        if (keyEvent.getCode().equals(KeyCode.F12)) {
          keyEvent.consume();
          close();

          okButtonPressed = true;
          if (runner != null) {
            runner.run(true);
          }

        }
      }
    });

    promptContent.setBottom(buttonBox);
  }


  private void askCloseQuestion(String question, IApplication.DlgRunnable runnable) {
    escAllowed = true;

    VBox centerContent = new VBox();

    if (question.contains("\n")) {
      String redPart = question.substring(0, question.indexOf("\n"));
      // keep \n
      question = question.substring(question.indexOf("\n"));

      Label red = new Label(redPart);
      red.setWrapText(true);
      red.getStyleClass().add(FX8FormContainer.formFlagLabel);
      centerContent.getChildren().add(red);

    }


    Label notRed = new Label(question);
    notRed.setWrapText(true);
    notRed.getStyleClass().add(msgboxTextLabel);
    centerContent.getChildren().add(notRed);


    promptContent.setCenter(centerContent);

    Label l2 = new Label(factory.getSystemLabel(userLangIndex, MoWareTranslations.Key.QUESTION));
    l2.getStyleClass().add(FX8FormContainer.formTitleLabel);
    promptContent.setTop(l2);

    ImageView view;
    view = new ImageView(new Image(FX8UiFactory.getImage("big_question")));
    BorderPane pane = new BorderPane();
    pane.getStyleClass().add(msgboxImagePadding);
    pane.setCenter(view);
    promptContent.setLeft(pane);

    cancelButton.setText(factory.getSystemLabel(userLangIndex, MoWareTranslations.Key.NO_BUTTON) + " (ESC)");
    okButton.setText(factory.getSystemLabel(userLangIndex, MoWareTranslations.Key.DISCARD_BUTTON) + " (F12)");
    okButton.setStyle("-fx-background-color: #4482b6;");

    cancelButton.setDefaultButton(true);
    buttonBox.setLeft(cancelButton);
    buttonBox.setRight(okButton);

    runner = runnable;
    this.open();

  }

  private void small(String img, String heading, String info) {
    Label l = new Label(info);
    l.setWrapText(true);
    l.getStyleClass().add(msgboxTextLabel);
    promptContent.setCenter(l);

    Label l2 = new Label(heading);
    l2.getStyleClass().add(FX8FormContainer.formTitleLabel);

    promptContent.setTop(l2);

    ImageView view;
    view = new ImageView(new Image(FX8UiFactory.getImage(img)));

    view.getStyleClass().add(msgboxImagePadding);
    BorderPane pane = new BorderPane();
    pane.getStyleClass().add(msgboxImagePadding);
    pane.setTop(view);
    promptContent.setLeft(pane);


    okButton.setDefaultButton(true);
    buttonBox.setRight(okButton);
  }

  private void large(String img, String heading, final String info) {
    ScrollPane scrollPane = new ScrollPane();
    scrollPane.setPadding(new Insets(10));
    Label l = new Label(info);
    l.setWrapText(true);
    scrollPane.setContent(l);

    EventHandler<KeyEvent> keyEventHandler;
    keyEventHandler = new EventHandler<KeyEvent>() {
      @Override
      public void handle(KeyEvent keyEvent) {
        if (!(keyEvent.getEventType().equals(KeyEvent.KEY_PRESSED))) {
          return;
        }
        // already destroyed ? JavaFX - why do they still dispatch that event?


        // this is very strange, but the application s scene
        // does not receive the ESC when the table is focussed ...
        // CRTL-C to copy content to clipboard
        if (keyEvent.getCode().equals(KeyCode.C) && keyEvent.isControlDown()) {
          Platform.runLater(new Runnable() {
            public void run() {
              StringBuilder rowContent = new StringBuilder();
              ClipboardContent allContent = new ClipboardContent();
              allContent.putString(info);
              Clipboard.getSystemClipboard().setContent(allContent);
            }
          });
        }
      }
    };
    scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
    scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);

    Label l2 = new Label(heading);
    l2.getStyleClass().add(FX8FormContainer.formTitleLabel);

    promptContent.setCenter(scrollPane);
    promptContent.setTop(l2);

    ImageView view;
    view = new ImageView(new Image(FX8UiFactory.getImage(img)));

    view.getStyleClass().add(msgboxImagePadding);
    BorderPane pane = new BorderPane();
    pane.getStyleClass().add(msgboxImagePadding);
    pane.setTop(view);

    promptContent.setLeft(pane);


    okButton.setDefaultButton(true);
    buttonBox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
    buttonBox.setRight(okButton);

    // Crtl c handler
    promptStage.addEventHandler(KeyEvent.ANY, keyEventHandler);
  }


  public void showGraphDebugger(List<Object> graph, String controllerInfo) {
    escAllowed = false;

    FX8GraphDebuggerFactory gdf = new FX8GraphDebuggerFactory();
    TreeTableView<String> ttv = gdf.createGraphAndCrtlInfo(graph, controllerInfo);
    final String asString = gdf.createGraphAndCrtlInfoAsString(graph, controllerInfo);

    EventHandler<KeyEvent> keyEventHandler;
    keyEventHandler = new EventHandler<KeyEvent>() {
      @Override
      public void handle(KeyEvent keyEvent) {
        if (!(keyEvent.getEventType().equals(KeyEvent.KEY_PRESSED))) {
          return;
        }
        // this is very strange, but the application s scene
        // does not receive the ESC when the table is focussed ...
        // CRTL-C to copy content to clipboard
        if (keyEvent.getCode().equals(KeyCode.C) && keyEvent.isControlDown()) {
          Platform.runLater(new Runnable() {
            public void run() {
              ClipboardContent allContent = new ClipboardContent();
              allContent.putString(asString);
              Clipboard.getSystemClipboard().setContent(allContent);
            }
          });
        }
      }
    };

    Label l2 = new Label("MoWare Graph Debugger");
    l2.getStyleClass().add(FX8FormContainer.formTitleLabel);

    promptContent.setCenter(ttv);
    promptContent.setTop(l2);

    ImageView view;
    view = new ImageView(new Image(FX8UiFactory.getImage("big_information")));

    view.getStyleClass().add(msgboxImagePadding);
    BorderPane pane = new BorderPane();
    pane.getStyleClass().add(msgboxImagePadding);
    pane.setTop(view);
    promptContent.setLeft(pane);

    okButton.setDefaultButton(true);
    buttonBox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
    buttonBox.setRight(okButton);

    promptStage.addEventHandler(KeyEvent.ANY, keyEventHandler);

    runner = null;
    this.open();
  }


  public void showInformation(String information, IApplication.DlgRunnable runnable) {
    escAllowed = false;

    if (msgType == IToolkit_MainWindow.DlgType.INFO_SMALL) {
      small("big_information", factory.getSystemLabel(userLangIndex, MoWareTranslations.Key.INFORMATION), information);
    } else if (msgType == IToolkit_MainWindow.DlgType.ERROR_SMALL) {
      small("big_error", factory.getSystemLabel(userLangIndex, MoWareTranslations.Key.ERROR), information);
    } else if (msgType == IToolkit_MainWindow.DlgType.ERROR_LARGE) {
      large("big_error", factory.getSystemLabel(userLangIndex, MoWareTranslations.Key.ERROR), information);
    } else if (msgType == IToolkit_MainWindow.DlgType.INFO_LARGE) {
      large("big_information", factory.getSystemLabel(userLangIndex, MoWareTranslations.Key.INFORMATION), information);
    } else if (msgType == IToolkit_MainWindow.DlgType.QUESTIONCLOSE_SMALL) {
      askCloseQuestion(information, runnable);
    }

    runner = runnable;

    this.open();
  }



  public void showProblems(List<IOFXProblem> problems, IApplication.DlgRunnable runnable) {
    escAllowed = false;

    if (msgType != IToolkit_MainWindow.DlgType.INFO_SMALL) {
      throw new RuntimeException("This can not happen, Problems Dialog supports only INFO_SMALL");
    }

    runner = runnable;

    VBox vBoxForProblemLabels = new VBox();
    vBoxForProblemLabels.setPadding(new Insets(25.0, 0.0, 0.0, 30.0));
    for (IOFXProblem prblm : problems) {
      Label l = new Label(prblm.getSimpleUserText());
      l.setWrapText(true);
      if (prblm.isWarningOnly()) {
        l.getStyleClass().add(FX8FormContainer.formWarningLabel);
      } else {
        l.getStyleClass().add(FX8FormContainer.formFlagLabel);
      }
      vBoxForProblemLabels.getChildren().add(l);
    }
    promptContent.setCenter(vBoxForProblemLabels);

    Label l2 = new Label(factory.getSystemLabel(userLangIndex, MoWareTranslations.Key.INFORMATION));
    l2.getStyleClass().add(FX8FormContainer.formTitleLabel);
    promptContent.setTop(l2);

    ImageView view;
    view = new ImageView(new Image(FX8UiFactory.getImage("big_information")));

    view.getStyleClass().add(msgboxImagePadding);
    BorderPane pane = new BorderPane();
    pane.getStyleClass().add(msgboxImagePadding);
    pane.setTop(view);
    promptContent.setLeft(pane);


    okButton.setDefaultButton(true);
    buttonBox.setRight(okButton);


    this.open();
  }



}
