package org.modellwerkstatt.fx8forms.windows;

/*Generated by MPS */

import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.stage.StageStyle;
import javafx.stage.Modality;
import javafx.event.EventHandler;
import javafx.stage.WindowEvent;
import javafx.animation.FadeTransition;
import javafx.util.Duration;
import javafx.application.Platform;

public class FX8Prompt {
  protected Stage promptStage;
  protected Scene promptScene;
  protected BorderPane promptContent;
  protected Size promptSize;


  public FX8Prompt(Stage parentStage, BorderPane content, Size size) {
    double width = 700;
    double height = 200;
    promptSize = size;

    promptStage = new Stage(StageStyle.UNDECORATED);
    promptStage.initModality(Modality.APPLICATION_MODAL);
    promptStage.initOwner(parentStage);

    // do not set always on top, that will result in sort of a tooltip window..

    promptContent = content;
    promptContent.getStyleClass().add("FX8PromptBorder");

    if (size.equals(Size.FULLSSCREEN)) {
      width = parentStage.getWidth() - 60;
      height = parentStage.getHeight() - 40;

      // now it depends .. if Fullscreen is request but window is smaller than 200, we have a problem!
      // then use min height
      if (parentStage.getHeight() <= 400) {
        height = parentStage.getHeight() - 10;
      }

      promptStage.setWidth(width);
      promptStage.setHeight(height);


    } else if (size.equals(Size.AUTO_FROMCONTENT)) {
      // calc width . . . .
      double parentWidth = parentStage.getWidth();
      double diff = 0.0;
      if (parentWidth < 800.0) {
        diff = 40.0;
      } else if (parentWidth < 1000.0) {
        diff = 100;
      } else {
        diff = parentWidth * 0.8 - 534.0;
      }
      width = parentWidth - diff;
      promptStage.setWidth(width);

    } else {
      promptStage.setWidth(width);
      promptStage.setHeight(height);
    }

    promptStage.setX(parentStage.getX() + ((parentStage.getWidth() - width) / 2));
    promptStage.setY(parentStage.getScene().getY() + parentStage.getY() + parentStage.getScene().getRoot().getLayoutY());

    promptStage.onCloseRequestProperty().set(new EventHandler<WindowEvent>() {
      public void handle(WindowEvent p0) {
        p0.consume();
      }
    });

    promptScene = new Scene(promptContent);
    promptStage.setScene(promptScene);
  }

  public void open() {
    FadeTransition fadeTransition = new FadeTransition(Duration.millis(400), promptContent);
    fadeTransition.setFromValue(0.0);
    fadeTransition.setToValue(1.0);
    fadeTransition.play();

    promptStage.show();
    adjustHeight();
  }

  public Stage getStage() {
    return promptStage;
  }
  public void close() {
    // close stage in background, doing it in foreground leads to F12 sent
    // to mainwindow, althought keypress event closes the stage()
    Platform.runLater(new Runnable() {
      public void run() {
        promptStage.close();
      }
    });
  }

  public void adjustHeight() {
    if (promptSize != Size.FULLSSCREEN) {
      double width = this.getStage().getWidth();
      promptContent.setPrefWidth(width);
      promptContent.setMinHeight(200.0);
      this.getStage().sizeToScene();
    }
  }

  public enum Size {
    FULLSSCREEN(),
    AUTO_FROMCONTENT(),
    DEFAULT()
  }
}
