package org.modellwerkstatt.fx8forms.windows;

/*Generated by MPS */

import javafx.scene.control.TabPane;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TabForm;
import org.modellwerkstatt.dataux.runtime.core.FocusController;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.Tab;
import javafx.beans.value.ObservableValue;
import javafx.application.Platform;
import javafx.scene.Node;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Form;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;

public class FX8TabForm<T> extends TabPane implements IToolkit_TabForm<T> {
  private FocusController focusController;
  private boolean uiInitialized;

  public FX8TabForm() {
    super();
    focusController = new FocusController();
    this.getStyleClass().add("FX8TabForm");
    uiInitialized = false;

    this.getSelectionModel().selectedItemProperty().addListener(new ChangeListener<Tab>() {
      public void changed(ObservableValue<? extends Tab> p0, Tab old, Tab newTab) {

        if (uiInitialized) {
          Platform.runLater(new Runnable() {
            public void run() {
              // Also changed due to focus request handling in Oct 2015, Dan
              final int i = FX8TabForm.this.getSelectionModel().getSelectedIndex();
              if (i >= 0 && i < FX8TabForm.this.getTabs().size()) {
                Node toFocus = ((Node) focusController.myRequestFocusOnChild(i));
                Node currentlyFocussed = FX8TabForm.this.getScene().getFocusOwner();

                if (currentlyFocussed != toFocus) {
                  // Java 1.8_181 migration, this should not happen. request focus not wokring as expected.
                }
              }
            }
          });
        }

      }
    });


  }
  public void flag(String msg) {
  }
  public void loadList(List<T> objects, IOFXSelection<T> selection) {
  }
  public boolean selectionChanged(IOFXSelection<T> selection) {
    return false;
  }
  public void addTab(IToolkit_Form form, String label) {
    focusController.addChild(form);

    Tab t = new Tab();
    t.setClosable(false);
    t.setText(label);
    t.setContent((Node) form);
    this.getTabs().add(t);
  }

  public void gcClear() {
    focusController.gcClear();
    for (int i = 0; i < this.getTabs().size(); i++) {
      this.getTabs().get(i).setContent(null);
    }
    this.getTabs().clear();
  }

  public Object myRequestFocus() {
    // okay, check which tab is selected an distribute the request focus to the right form ..
    int i = this.getSelectionModel().getSelectedIndex();
    return focusController.myRequestFocusOnChild(i);
  }

  public void afterFullUiInitialized() {
    focusController.afterFullUiInitialized();
    uiInitialized = true;
  }
  public void setTitleText(String text) {
    throw new RuntimeException("not implemented for FX8TabForm");
  }
  public void setProblems(List<IOFXProblem> problems) {
    throw new RuntimeException("not implemented for FX8TabForm");
  }
  public IToolkit_TabForm<T> getToolkitImplementation() {
    return this;
  }

}
