package org.modellwerkstatt.fx8forms.windows;

/*Generated by MPS */

import javafx.scene.layout.BorderPane;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TableForm;
import javafx.scene.control.TableView;
import javafx.scene.layout.HBox;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenSelControlled;
import javafx.scene.control.Label;
import java.util.List;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.TextField;
import javafx.collections.ObservableList;
import javafx.collections.ListChangeListener;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.scene.input.KeyEvent;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.scene.input.KeyCode;
import javafx.scene.text.Text;
import javafx.application.Platform;
import java.util.Set;
import java.util.HashSet;
import java.util.Arrays;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Clipboard;
import javafx.geometry.Pos;
import javafx.scene.text.TextAlignment;
import javafx.scene.control.SelectionMode;
import org.modellwerkstatt.objectflow.runtime.Selection;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.MouseButton;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.dataux.runtime.genspecifications.Menu;
import org.modellwerkstatt.dataux.runtime.extensions.ITableCellStringConverter;
import javafx.util.Callback;
import javafx.beans.value.ObservableValue;
import org.modellwerkstatt.dataux.runtime.delegates.TableCellBigDecimalConverter;
import javafx.scene.control.TableCell;
import org.modellwerkstatt.dataux.runtime.delegates.TableCellStatusConverter;
import javafx.scene.Node;
import org.modellwerkstatt.dataux.runtime.utils.MoJSON;

public class FX8TableForm<T> extends BorderPane implements IToolkit_TableForm<T> {
  private TableView<T> table;
  private BorderPane topPane;
  private HBox onTheRight;

  private FX8ActionHBox actionHBox;
  private IGenSelControlled genParent;
  private Class elementClass;
  private boolean selectionHandlerEnabled;
  private boolean selectionChangedEnabled;

  private FX8FlagBox titleLabel;

  private Label selectionPosition;
  private List<javafx.scene.control.TableColumn> notVisibleColummns;
  private boolean visible;
  private Label selectionSummaryLine;
  private Label tableSummaryLine;

  private ContextMenu contextMenu;
  private TextField searchField;
  private boolean searchEnabled;
  private boolean editEnabled;
  private boolean editPreview;
  private boolean scroll;


  private List<PropertyAndConverter> columnWithConverter;
  private ObservableList<T> allItems;
  private ObservableList<T> currentItems;
  private ListChangeListener<Integer> selectionListener;
  private ChangeListener<Boolean> focusListener;
  private EventHandler<KeyEvent> keyEventHandler;
  private EventHandler<KeyEvent> workaroundKeyHandler;
  private EventHandler<KeyEvent> menuButtonEventHandler;
  private EventHandler<KeyEvent> contextMenuHandler;


  public FX8TableForm(boolean scrollAdjustEnbld) {
    super();
    notVisibleColummns = ListSequence.fromList(new ArrayList<javafx.scene.control.TableColumn>());
    columnWithConverter = ListSequence.fromList(new ArrayList<PropertyAndConverter>());
    currentItems = FXCollections.observableArrayList();
    allItems = FXCollections.observableArrayList();
    scroll = scrollAdjustEnbld;
    visible = false;
    // changed by dan 15.Oct 2015, editEnabled was default true? for sure not correct.
    editEnabled = false;
    editPreview = false;
    this.getStyleClass().add("FX8TableForm");


    contextMenu = new ContextMenu();
    contextMenuHandler = new EventHandler<KeyEvent>() {
      @Override
      public void handle(KeyEvent keyEvent) {
        if (keyEvent.getCode().equals(KeyCode.ESCAPE)) {
          keyEvent.consume();
          if (keyEvent.getEventType().equals(KeyEvent.KEY_RELEASED)) {
            contextMenu.hide();
          }
        }
      }
    };
    contextMenu.addEventFilter(KeyEvent.ANY, contextMenuHandler);


    table = new TableView();
    table.setEditable(true);

    table.setPlaceholder(new Text(""));
    table.setItems(FXCollections.<T>observableArrayList());
    table.setContextMenu(contextMenu);

    keyEventHandler = new EventHandler<KeyEvent>() {
      @Override
      public void handle(KeyEvent keyEvent) {
        if (!(keyEvent.getEventType().equals(KeyEvent.KEY_PRESSED))) {
          return;
        }
        // already destroyed ? JavaFX - why do they still dispatch that event?


        // this is very strange, but the application s scene
        // does not receive the ESC when the table is focussed ...
        if (keyEvent.getCode().equals(KeyCode.ESCAPE)) {
          table.getScene().getOnKeyPressed().handle(keyEvent);
        }


        // not editing right now
        if (editEnabled && keyEvent.getCode().equals(KeyCode.ENTER)) {
          // are we already editing ?
          keyEvent.consume();
          myRequestFocus();
        }


        // CRTL-C to copy content to clipboard
        if (keyEvent.getCode().equals(KeyCode.C) && keyEvent.isControlDown()) {
          Platform.runLater(new Runnable() {
            public void run() {
              Set<Integer> selectedIndices = new HashSet<Integer>(table.getSelectionModel().getSelectedIndices());

              // reformat array ..
              int[] ar = new int[selectedIndices.size()];
              int someI = 0;
              for (Object index : selectedIndices.toArray()) {
                ar[someI++] = ((Integer) index);
              }
              Arrays.sort(ar);
              List<T> listOfSelectedObjects = new ArrayList<T>();
              // print Data of Objects ...
              for (int index : ar) {
                T obj = table.getItems().get(index);
                listOfSelectedObjects.add(obj);
              }

              ObservableList<javafx.scene.control.TableColumn<T, ?>> tableCols = table.getColumns();
              for (int index = 0; index < ListSequence.fromList(columnWithConverter).count(); index++) {
                ListSequence.fromList(columnWithConverter).getElement(index).visible = tableCols.get(index).isVisible();
              }

              String csv = genParent.convertAsCsv(allItems, listOfSelectedObjects, columnWithConverter);
              ClipboardContent allContent = new ClipboardContent();
              allContent.putString(csv);
              Clipboard.getSystemClipboard().setContent(allContent);
            }
          });
        }
      }
    };
    table.addEventHandler(KeyEvent.ANY, keyEventHandler);

    workaroundKeyHandler = new EventHandler<KeyEvent>() {
      @Override
      public void handle(KeyEvent event) {
        // hotkey not found. if it s a enter, consume it.
        // WORKAROUND java11 fx will result in a NPE in 
        // at com.sun.javafx.scene.control.behavior.TableViewBehaviorBase.activate(TableViewBehaviorBase.java:890)
        if (event.getCode().equals(KeyCode.ENTER)) {
          event.consume();
        }
      }
    };
    table.addEventHandler(KeyEvent.KEY_PRESSED, workaroundKeyHandler);

    topPane = new BorderPane();
    onTheRight = new HBox();
    onTheRight.setAlignment(Pos.BASELINE_RIGHT);
    selectionPosition = new Label();
    selectionPosition.getStyleClass().add("titleLabel");
    selectionPosition.setPrefWidth(90);
    selectionPosition.minWidth(90);
    selectionPosition.setTextAlignment(TextAlignment.RIGHT);
    selectionPosition.setAlignment(Pos.BASELINE_RIGHT);

    searchField = new TextField();
    searchField.getStyleClass().add("FX8TableSearchField");
    searchField.setPrefSize(100.0, 20.0);
    searchField.addEventHandler(KeyEvent.KEY_PRESSED, new EventHandler<KeyEvent>() {
      public void handle(KeyEvent p0) {
        Platform.runLater(new Runnable() {
          public void run() {
            applyFilter(null);
          }
        });
      }
    });
    searchEnabled = true;


    onTheRight.getChildren().addAll(searchField, selectionPosition);
    topPane.setRight(onTheRight);
    titleLabel = new FX8FlagBox();
    topPane.setLeft(titleLabel);



    selectionSummaryLine = new Label("");
    tableSummaryLine = new Label("");

    topPane.getStyleClass().add("formstopPane");
    setTop(topPane);
    setCenter(table);

    selectionHandlerEnabled = false;
    selectionChangedEnabled = true;

    table.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    selectionListener = new ListChangeListener<Integer>() {
      public void onChanged(ListChangeListener.Change<? extends Integer> change) {
        if (selectionHandlerEnabled) {
          selectionHandlerEnabled = false;
          setCounterText("");

          int last = -4711;
          List<T> selectedItems = new ArrayList<T>();

          Object[] selectedElements = change.getList().toArray();
          Arrays.sort(selectedElements);
          for (Object theIntObject : selectedElements) {
            // known fx bug - selection problem on first init?
            int i = ((int) theIntObject);
            if (i == last) {
              continue;
            }

            if (i < 0) {
              // This Is the IOB BUG

              Platform.runLater(new Runnable() {
                public void run() {
                  table.getSelectionModel().clearSelection();
                  pushSelection(new Selection(elementClass));
                  selectionHandlerEnabled = true;
                }
              });
              return;

            } else {
              last = i;
              selectedItems.add(table.getItems().get(i));

            }

          }

          if (selectedItems.size() == 0) {
            pushSelection(new Selection(elementClass));
          } else {
            // Changed from anonymous to Object - Dan Migration to MPS3.1
            pushSelection(new Selection<T>(elementClass, selectedItems));
          }
          selectionHandlerEnabled = true;
        }

      }
    };
    table.getSelectionModel().getSelectedIndices().addListener(selectionListener);



    table.setOnMouseClicked(new EventHandler<MouseEvent>() {
      @Override
      public void handle(MouseEvent event) {
        if (event.getClickCount() == 2 && event.getButton().equals(MouseButton.PRIMARY)) {
          if (actionHBox != null) {
            actionHBox.doubleClickReceived();
          }


        } else if (event.getClickCount() == 2) {
          if (visible) {
            ListSequence.fromList(notVisibleColummns).visitAll(new _FunctionTypes._void_P1_E0<javafx.scene.control.TableColumn>() {
              public void invoke(javafx.scene.control.TableColumn it) {
                it.setVisible(false);
              }
            });
            visible = false;
          } else {
            ListSequence.fromList(notVisibleColummns).visitAll(new _FunctionTypes._void_P1_E0<javafx.scene.control.TableColumn>() {
              public void invoke(javafx.scene.control.TableColumn it) {
                it.setVisible(true);
              }
            });
            visible = true;
          }

          double totalWidth = 1.0;

          for (javafx.scene.control.TableColumn col : table.getColumns()) {
            if (col.isVisible()) {
              totalWidth += ((int) col.getUserData());
            }
          }

          for (javafx.scene.control.TableColumn col : table.getColumns()) {
            if (col.isVisible()) {
              double thisWitdh = ((int) col.getUserData()) / totalWidth;
              col.prefWidthProperty().bind(table.widthProperty().multiply(thisWitdh));
            }
          }

        }
      }
    });
  }

  public void applyFilter(IOFXSelection selection) {
    // if IOFXSelection is given, then applyFilter is called from loadlist()
    // that is, applyFilter and check selection ...

    // is on platform.runlater() exec only, if table is not null
    if (searchEnabled && allItems != null && table != null) {
      List<?> remainingSelections = table.getSelectionModel().getSelectedItems();
      currentItems = FXCollections.observableArrayList();
      ObservableList<javafx.scene.control.TableColumn<T, ?>> tableCols = table.getColumns();

      String searchFor = searchField.getText().replace(".", "").toLowerCase();
      for (int i = 0; i < allItems.size(); i++) {
        boolean found = false;


        for (int j = 0; j < ListSequence.fromList(columnWithConverter).count(); j++) {
          if (!(tableCols.get(j).isVisible())) {
            continue;
          }
          if (ListSequence.fromList(columnWithConverter).getElement(j).contains(allItems.get(i), searchFor)) {
            found = true;
            break;
          }
        }
        if (found) {
          currentItems.add(allItems.get(i));
        }
      }

      // use updated selection and not current table items.
      // in a search command, entities might even be exchanged.
      if (selection != null) {
        remainingSelections = selection.getObjects();
      }


      boolean foundSelection;
      foundSelection = currentItems.containsAll(remainingSelections);
      if (!(foundSelection)) {
        selectionHandlerEnabled = false;
        table.getSelectionModel().clearSelection();
        selectionHandlerEnabled = true;
      }
      updateTableToCurrentItems();


      // if selected item is not in availbe items clear selection ...
      if (!(foundSelection)) {
        selectionHandlerEnabled = false;
        pushSelection(new Selection(elementClass));
        selectionHandlerEnabled = true;
      }


      // finally update count
      setCounterText("");
    }
  }



  @Override
  public void rootForm() {
    titleLabel.inRootForm();
  }
  public void setTitleText(String text) {
    // check if a title is installed at all ..
    titleLabel.setTitle(text);
  }
  public void setProblems(List<IOFXProblem> listOfProblems) {
    if (ListSequence.fromList(listOfProblems).count() == 0) {
      // clear flag action
      titleLabel.flag(listOfProblems);
      getCenter().getStyleClass().remove(FX8FormContainer.formFlagBorder);
    } else {
      getCenter().getStyleClass().add(FX8FormContainer.formFlagBorder);
      titleLabel.flag(listOfProblems);
    }

  }




  public void setCounterText(String pre) {
    ObservableList<Integer> indices = table.getSelectionModel().getSelectedIndices();

    if (indices.size() == 1) {
      selectionPosition.setText(pre + " " + (indices.get(0) + 1) + "/" + currentItems.size() + "  ");

    } else if (indices.size() > 1) {
      selectionPosition.setText(pre + " M/" + currentItems.size() + "  ");

    } else {
      selectionPosition.setText(pre + "  /" + currentItems.size() + "  ");

    }
  }
  public void setFormController(IGenSelControlled crtl) {
    // needed for pushSelection
    genParent = crtl;
  }
  private void debug(String func, String msg) {
    System.err.println("" + System.currentTimeMillis() + " " + genParent.getClass().getName() + "  " + func + "()  " + msg);
  }
  private void pushSelection(IOFXSelection sel) {
    selectionChangedEnabled = false;
    if (genParent != null) {
      genParent.pushSelection(sel);
    }
    selectionChangedEnabled = true;
  }
  public void addMenuAndSetButtons(Menu folder) {
    // only called, when a menu is defined at all
    actionHBox = new FX8ActionHBox(folder, contextMenu);
    onTheRight.getChildren().add(actionHBox);


    menuButtonEventHandler = new EventHandler<KeyEvent>() {
      public void handle(KeyEvent p0) {
        // we are using the KEY Pressed event ..
        // not any other event. If we consum the event locally (here), mainwindow handler will not
        // receive it ..
        if (actionHBox != null) {
          if (!(p0.isControlDown()) && p0.getCode().getName().length() == 1) {
            // no nothing ... single char hotkeys are only available with crtl down ..
            return;
          }
          actionHBox.hotKeyReceived(p0);
        }
      }
    };

    table.removeEventHandler(KeyEvent.KEY_PRESSED, workaroundKeyHandler);

    table.addEventHandler(KeyEvent.KEY_PRESSED, menuButtonEventHandler);
    table.addEventHandler(KeyEvent.KEY_PRESSED, workaroundKeyHandler);

  }

  @Deprecated
  public List<?> getHotKeysToRegister() {
    // internally handled with table key listeners ...
    return null;
  }
  public boolean selectionChanged(final IOFXSelection<T> sel) {

    if (!(selectionChangedEnabled)) {
      return true;
    }

    selectionHandlerEnabled = false;

    if (currentItems != null) {
      // selection changed needed?
      boolean selectionChangeNeeded = false;
      // -----------------------------------------------------------
      // SelectionChangeNeeded set to true, since we have some problems on
      // searchView with Arrow-Keys handling. when forcing selectionChange.. everthings fine.
      selectionChangeNeeded = true;

      if (selectionChangeNeeded) {
        table.getSelectionModel().clearSelection();
        List<T> selection = sel.getObjects();
        int[] indizes = new int[ListSequence.fromList(selection).count()];
        int numFound = 0;
        if (currentItems.size() == 0 && ListSequence.fromList(selection).count() > 0) {
          // Dan Koblach 18, also if list is empty, but some obj selected?
          selectionHandlerEnabled = true;
          return false;
        }

        if (currentItems.size() > 0 && ListSequence.fromList(selection).count() > 0) {
          for (int i = 0; i < currentItems.size(); i++) {
            if (ListSequence.fromList(selection).contains(currentItems.get(i))) {
              indizes[numFound] = i;
              numFound++;
            }
          }
          if (numFound != ListSequence.fromList(selection).count()) {
            setCounterText("* ");
            selectionHandlerEnabled = true;
            return false;
            // !! return here ...
          }
        }

        if (indizes.length > 0) {
          table.getSelectionModel().selectIndices(indizes[0], indizes);
        }

        if ((editEnabled || editPreview || scroll) && ListSequence.fromList(selection).count() > 0) {
          int toScrollTo = table.getItems().indexOf(ListSequence.fromList(selection).last());
          int total = currentItems.size();

          if (toScrollTo >= 0) {
            if (toScrollTo < (total - 7)) {
              toScrollTo -= 7;
            }
            table.scrollTo(toScrollTo);
          }
        }
      }

    }
    setCounterText("");


    selectionHandlerEnabled = true;
    return true;
  }
  public void loadList(List<T> objects, IOFXSelection<T> selection) {
    selectionHandlerEnabled = false;
    searchEnabled = false;


    // clear filter
    allItems = (ObservableList<T>) FXCollections.observableArrayList(objects);


    if (searchField.getText().equals("")) {
      // clear sorting ..
      currentItems = allItems;
      updateTableToCurrentItems();

    } else {
      // applyFilter will call updateTableToCurrentItems()
      searchEnabled = true;
      applyFilter(selection);

    }


    selectionChanged(selection);
    setCounterText("");
    selectionHandlerEnabled = true;
    searchEnabled = true;
  }
  public void updateTableToCurrentItems() {

    // temporary get sort orders ..
    Object[] sortOrders = table.getSortOrder().toArray();

    // workaground to refresh table... (removed 5.Oct 15 dan)

    table.setItems(currentItems);

    // If we do not the sortOrder clear etc. sorting from table will be removed.
    // what might be okay also! (in case we have further exceptions)
    table.getSortOrder().clear();
    for (Object o : sortOrders) {
      table.getSortOrder().add(((javafx.scene.control.TableColumn) o));
    }

    // replacing the visible workaround above!
    table.refresh();

  }


  public void addColumn(final String property, String label, final ITableCellStringConverter converter, int width, boolean editable, boolean folded, boolean important) {

    if (editable) {
      editEnabled = true;
      searchField.setText("");
      searchField.setDisable(true);
    }

    javafx.scene.control.TableColumn col = new javafx.scene.control.TableColumn(label);
    col.setText(label);
    col.setUserData(width);

    if (folded) {
      ListSequence.fromList(notVisibleColummns).addElement(col);
      ListSequence.fromList(columnWithConverter).addElement(new PropertyAndConverter(ListSequence.fromList(columnWithConverter).count(), property, label, converter, width, !(folded)));
      col.setVisible(false);

    } else {
      // first visible one?
      double percent = 0.01 * width;
      if (ListSequence.fromList(columnWithConverter).count() - ListSequence.fromList(notVisibleColummns).count() == 0) {
        // do not display horizontal scrollbar
        percent = percent - 0.01;
      }
      col.prefWidthProperty().bind(table.widthProperty().multiply(percent));
      ListSequence.fromList(columnWithConverter).addElement(new PropertyAndConverter(ListSequence.fromList(columnWithConverter).count(), property, label, converter, width, !(folded)));

    }

    // Numberformat, DateFormatter
    col.setEditable(editable);
    col.setCellValueFactory((Callback<javafx.scene.control.TableColumn.CellDataFeatures<Object, Object>, ObservableValue<Object>>) new FX8BeanPropertyValue(property));

    // TODO original javafx not working, dan 20.8.2013
    if (!(editable)) {
      col.setCellFactory((Callback) new MyTableCellFactory(converter));

    } else {
      if (converter instanceof TableCellBigDecimalConverter) {
        // editable bigdecimal
        col.setCellFactory(new Callback<javafx.scene.control.TableColumn, TableCell>() {
          public TableCell call(javafx.scene.control.TableColumn p0) {
            return new FX8EditCellBigdeci(property, converter);
          }
        });
      } else if (converter instanceof TableCellStatusConverter) {
        // status converter used ..
        col.setCellFactory(new Callback<javafx.scene.control.TableColumn, TableCell>() {
          public TableCell call(javafx.scene.control.TableColumn p0) {
            return new FX8EditCellStatus(property, converter);
          }
        });
      } else {
        throw new IllegalArgumentException("Only bigdecimal and status are supported as editable by this runtime.");
      }

    }

    table.getColumns().add(col);
  }

  public void forceNotEditable() {
    for (int i = 0; i < table.getColumns().size(); i++) {
      if (table.getColumns().get(i).isEditable()) {
        table.getColumns().get(i).setEditable(false);
      }
    }

    // nolonger, since moware11 this is leading to double HKs
  }

  @Override
  public void setEditPreview() {
    editPreview = true;
    searchField.setEditable(false);
    searchField.setDisable(true);
    searchField.setVisible(false);

    for (int i = 0; i < table.getColumns().size(); i++) {
      table.getColumns().get(i).setSortable(false);
    }
    table.setDisable(true);
  }
  public void endOfInitializationForElementClass(Class cls) {

    // Nothing to do here ..
    elementClass = cls;
  }
  public Object myRequestFocus() {

    Node focussedNode = null;

    if (editPreview) {
      return null;
    }

    // gcClean() already called ... should by checked by VCmdUiPrompt, but undeterministically not working.
    if (table == null) {
      return null;
    }

    table.requestFocus();
    focussedNode = table;

    int i = table.getSelectionModel().getSelectedIndices().size();

    // even if no element is selected... select the table ?
    // Dan: 8 Oct 2015 - changed. in past, table was only focussed
    // if i ==1, otherwise Fx8TableForm.this.requestFocus() was used.
    if (i == 1) {
      if (editEnabled) {
        for (javafx.scene.control.TableColumn col : table.getColumns()) {
          if (!(col.getCellFactory() instanceof MyTableCellFactory)) {
            table.edit(table.getSelectionModel().getSelectedIndex(), col);
            break;
          }
        }
      }
    }

    return focussedNode;
  }

  public void afterFullUiInitialized() {
  }

  public void addTableItemColor(String property, ITableCellStringConverter converter) {
  }
  public void installBottomLine() {
    selectionSummaryLine.setAlignment(Pos.BASELINE_RIGHT);
    tableSummaryLine.setAlignment(Pos.BASELINE_LEFT);


    HBox box = new HBox();
    box.setAlignment(Pos.BASELINE_CENTER);
    box.getChildren().addAll(tableSummaryLine, selectionSummaryLine);
    this.setBottom(box);

    selectionSummaryLine.prefWidthProperty().bind(table.widthProperty().multiply(0.49));
    tableSummaryLine.prefWidthProperty().bind(table.widthProperty().multiply(0.49));
  }
  public void setSelectionSummaryLineText(String text) {
    selectionSummaryLine.setText(text);
    // if not added to table layout, add it ..
    if (this.getBottom() == null) {
      installBottomLine();
    }
  }
  public void setTableSummaryLineText(String text) {
    tableSummaryLine.setText(text);
    // if not added to table layout, add it ..
    if (this.getBottom() == null) {
      installBottomLine();
    }
  }

  public void gcClear() {
    selectionChangedEnabled = false;
    selectionHandlerEnabled = false;

    table.removeEventHandler(KeyEvent.ANY, keyEventHandler);
    contextMenu.removeEventFilter(KeyEvent.ANY, contextMenuHandler);
    table.setContextMenu(null);
    table.getSortOrder().clear();

    if (actionHBox != null) {
      table.removeEventHandler(KeyEvent.KEY_PRESSED, menuButtonEventHandler);
      actionHBox.gcClear();
      actionHBox = null;
    }

    table.removeEventHandler(KeyEvent.KEY_PRESSED, workaroundKeyHandler);

    table.getFocusModel().focus(null);
    table.setOnMouseClicked(null);
    table.getSelectionModel().getSelectedIndices().removeListener(selectionListener);
    table.setSelectionModel(null);

    table.setItems(FXCollections.<T>observableArrayList());
    table.getColumns().clear();
    // clear converters from tableCellFactory
    this.setCenter(new Label("GC"));
    allItems.clear();
    currentItems.clear();
    allItems = null;
    currentItems = null;

    table = null;
  }
  public static class PropertyAndConverter extends IToolkit_TableForm.TableColumn {

    public PropertyAndConverter(int pos, String propName, String header, ITableCellStringConverter conv, int width, boolean visible) {
      super(pos, propName, header, conv, width, visible);
    }

    public boolean contains(Object o, String lowercasedString) {
      Object obj = MoJSON.get(o, this.propertyName);
      if (obj == null) {
        return false;
      }
      String st = mowareConverter.convert(obj);
      if (st == null) {
        return false;
      }
      return st.replace(".", "").toLowerCase().contains(lowercasedString);
    }
  }


  public static class MyTableCellFactory implements Callback<javafx.scene.control.TableColumn, TableCell> {
    private ITableCellStringConverter converter;
    public MyTableCellFactory(ITableCellStringConverter conv) {
      converter = conv;
    }
    public TableCell call(javafx.scene.control.TableColumn column) {
      return new MyTableCell(converter);
    }
  }



  public static class MyTableCell extends TableCell<Object, Object> {
    private ITableCellStringConverter converter;

    public MyTableCell(ITableCellStringConverter conv) {
      converter = conv;
    }
    @Override
    protected void updateItem(Object myObject, boolean arg1) {
      super.updateItem(myObject, arg1);

      if (myObject != null && !(arg1)) {
        setText(converter.convert(myObject));

        if (converter.isRightAligned()) {
          setAlignment(Pos.BASELINE_RIGHT);
        } else {
          setAlignment(Pos.BASELINE_LEFT);
        }

      } else {
        setText(null);
      }
      String col = converter.getBgColor(myObject);
      if (col != null && !("".equals(col.trim()))) {
        this.setStyle("-fx-text-fill: " + col);
      } else {
        this.setStyle("");
      }

    }
    public void gcClear() {
      converter = null;
    }
  }
}
