package org.modellwerkstatt.fx8forms.windows;

/*Generated by MPS */

import javafx.scene.control.Button;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_EnableItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.control.Tooltip;

public class FX8TileButton extends Button implements IToolkit_EnableItem {
  private String hotkeyLabel;

  public FX8TileButton(Image image, String text, String tooltip, String hl, String col) {
    super(text, new ImageView(image));
    setup(tooltip, hl, col);
  }
  public FX8TileButton(String text, String tooltip, String hl, String col) {
    super(text);
    setup(tooltip, hl, col);
  }

  private void setup(String tooltip, String hl, String col) {
    hotkeyLabel = hl;
    if (tooltip != null && !("".equals(tooltip))) {
      super.setTooltip(new Tooltip(tooltip));
    }
    this.getStyleClass().add("FX8TilePaneButton");
    if (col != null) {
      this.setStyle("-fx-border-color:" + col + "; -fx-text-fill: " + col + ";");
    }
    this.setPrefWidth(400.0);

    // hotkey ..
    if (hotkeyLabel != null) {
      setText(this.getText() + "    (" + hotkeyLabel + ")");
    }
  }

  public void updateTitle(String t) {
    if (hotkeyLabel != null) {
      setText(t + "    (" + hotkeyLabel + ")");
    } else {
      setText(t);
    }
  }
  public void setItemEnabled(boolean enabled) {
    this.setDisabled(!(enabled));
  }

}
