package org.modellwerkstatt.fx8forms.windows;

/*Generated by MPS */

import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.stage.StageStyle;
import javafx.scene.text.TextAlignment;
import javafx.animation.Timeline;
import javafx.animation.KeyFrame;
import javafx.util.Duration;
import javafx.animation.KeyValue;
import javafx.event.EventHandler;
import javafx.event.ActionEvent;
import javafx.animation.SequentialTransition;

public class FX8ToastPrompt {

  protected Stage toastStage;
  protected Scene toastScene;
  protected Label toastLabel;

  protected double width;
  protected double height;



  public FX8ToastPrompt(Stage parentStage) {
    toastStage = new Stage(StageStyle.TRANSPARENT);

    toastStage.initOwner(parentStage);


    double parentWidth = parentStage.getWidth();
    double parentHeight = parentStage.getHeight();

    width = 600;
    if (parentWidth < 600) {
      width = parentWidth;
    }
    height = 50;

    toastStage.setWidth(width);
    toastStage.setHeight(height);

    toastStage.setX(parentStage.getX() + ((parentStage.getWidth() - width) / 2));
    toastStage.setY(parentStage.getScene().getY() + parentStage.getY() + parentStage.getScene().getRoot().getLayoutY());

    toastLabel = new Label();
    toastLabel.getStyleClass().add("FX8ToastLabel");
    toastLabel.setPrefWidth(width);
    toastLabel.setWrapText(true);
    toastLabel.setTextAlignment(TextAlignment.JUSTIFY);

    toastScene = new Scene(toastLabel);
    toastStage.setScene(toastScene);
  }

  public void showMessage(String msg) {

    toastLabel.setText(msg.replaceAll("\n", ""));
    toastStage.show();
    toastStage.getScene().getRoot().opacityProperty().set(0.0);


    Timeline fadeIn = new Timeline();
    KeyFrame key0 = new KeyFrame(Duration.millis(500), new KeyValue(toastStage.getScene().getRoot().opacityProperty(), 1.0));
    fadeIn.getKeyFrames().add(key0);

    Timeline constant = new Timeline();
    KeyFrame key = new KeyFrame(Duration.millis(1500), new KeyValue(toastStage.getScene().getRoot().opacityProperty(), 1.0));
    constant.getKeyFrames().add(key);

    Timeline fadeOut = new Timeline();
    KeyFrame key2 = new KeyFrame(Duration.millis(500), new KeyValue(toastStage.getScene().getRoot().opacityProperty(), 0.0));
    fadeOut.getKeyFrames().add(key2);

    constant.setOnFinished(new EventHandler<ActionEvent>() {
      public void handle(ActionEvent p0) {
        toastStage.close();
      }
    });

    SequentialTransition st = new SequentialTransition(fadeIn, constant, fadeOut);
    st.play();
  }

  public Stage getStage() {
    return toastStage;
  }
}
