package org.modellwerkstatt.manmap.runtime;

/*Generated by MPS */

import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import java.util.List;

public interface IM3Session {

  DateTime getCurrentTransactionTimestamp();
  LocalDate getCurrentTransactionLocalDate();
  IM3UserEnvironment getIM3UserEnvironment();

  /**
   * Get or create keystore for a particular class hierachie 
   * denoted by unique name 
   * 
   * @param uniqueHierarchyHashCode root class hashcode
   * @return the object store .. 
   */
  MMObjectKeyStore getOrCreateKeyStore(int uniqueHierarchyHashCode);

  /**
   * isDirty() needs some time to calculate if any KeyStore is dirty, 
   * findDirtyEntities calculates a string or entity type names, which are dirty marked. 
   * 
   * 
   * @return 
   */
  boolean isDirty();
  void setDirty();
  String findDirtyEntities();

  /**
   * setReadOnly() and isReadOnly(() are available to work with readOnly sessions
   * 
   * @return 
   */
  boolean isReadOnly();
  void setReadOnly();

  /**
   * Transaction 
   * 
   * @param e 
   */
  void addEntityInvolvedInTransaction(IM3Entity e);

  /**
   * For cleanup purpose
   */
  void clearAllKeystores();
  void detachAllEntitiesByUniqueHashCode(int code);



  /**
   * This is the infrastruct for the entities checked out features
   */
  <T> List<T> getEntitiesCheckedOut(int uniqueSessionEntityID);
  <T> List<T> getEntitiesCheckedOutKey(int uniqueSessionEntityID);
  <T> List<T> getEntitiesAll(int uniqueSessionEntityID);
  <T> List<T> getEntitiesAllKey(int uniqueSessionEntityID);

  void ensureInSession(Object e);
}
