package org.modellwerkstatt.manmap.runtime;

/*Generated by MPS */

import java.util.List;
import java.util.ArrayList;
import java.util.Arrays;

public class MMNamedParameterSupport {

  private static final String PARAMETER_SEPARATORS = "\"':&,;()|=+-*%/\\<>^]";
  private static final boolean[] separatorIndex = new boolean[128];
  static {
    for (char c : PARAMETER_SEPARATORS.toCharArray()) {
      separatorIndex[c] = true;
    }
  }


  private static final String[] START_SKIP = new String[]{"'", "\"", "--", "/*"};
  private static final String[] STOP_SKIP = new String[]{"'", "\"", "\n", "*/"};



  public static int posOf(String name, String... listOfNames) {
    int i = 0;
    for (String a : listOfNames) {
      if (name.equals(a)) {
        return i;
      }
      i++;
    }
    return -1;
  }
  public static boolean isParameterSeperator(char c) {
    return (c < 128 && separatorIndex[c]) || Character.isWhitespace(c);
  }

  public static List<String> retrievFieldsFromSqlStatement(String sql) {
    List<String> fields = new ArrayList<String>();

    char[] statement = sql.toCharArray();
    int i = 0;

    while (i < statement.length) {
      int skipToPosition = i;
      while (i < statement.length) {
        skipToPosition = skipCommentsAndQuotes(statement, i);
        if (i == skipToPosition) {
          break;
        } else {
          i = skipToPosition;
        }
      }
      if (i >= statement.length) {
        break;
      }

      char c = statement[i];
      if (c == ':') {
        int paramEnd = i + 1;

        String parameter = null;
        while (paramEnd < statement.length && !(isParameterSeperator(statement[paramEnd]))) {
          paramEnd++;
        }

        if (paramEnd - i > 1) {
          parameter = sql.substring(i + 1, paramEnd);
          fields.add(parameter);

        } else {
          throw new RuntimeException("Can not handle misspecified Parameter after ':' at position " + i);
        }

        i = paramEnd - 1;
      }

      i++;
    }
    return fields;
  }

  public static int[] parseSqlStatementWithNpOrSimpleIntArray(String sql, IM3NamedParameter... allParams) {
    if (allParams.length == 0) {
      return new int[0];

    } else {
      boolean isNamed = allParams[0].isNamedParam();

      if (isNamed) {
        // named parameter ...
        String[] paramNames = new String[allParams.length];
        for (int i = 0; i < allParams.length; i++) {
          paramNames[i] = allParams[i].getName();
          if (!(allParams[i].isNamedParam())) {
            throw new RuntimeException("You can not mix named and regular params, first param was a named one, but this param num. " + i + " is not named.");
          }
        }
        return parseSqlStatement(sql, paramNames);

      } else {
        // none named (regular) params 
        int[] ascendingArray = new int[allParams.length];
        for (int i = 0; i < allParams.length; i++) {
          ascendingArray[i] = i;
          if (allParams[i].isNamedParam()) {
            throw new RuntimeException("You can not mix named and regular params, first param was a regular one, but this param num. " + i + " is named '" + allParams[i].getName());
          }
        }
        return ascendingArray;
      }
    }
  }

  public static int[] parseSqlStatement(String sql, String... allParameterNames) {
    List<Integer> paramPositions = new ArrayList<Integer>();
    List<String> namedParamsInSql = retrievFieldsFromSqlStatement(sql);

    for (String param : namedParamsInSql) {
      int paramIndex = posOf(param, allParameterNames);
      if (paramIndex < 0) {
        throw new RuntimeException("Parameter with name '" + param + "' not found in given named parameters " + Arrays.toString(allParameterNames));
      }
      paramPositions.add(paramIndex);

    }

    int[] retArry = new int[paramPositions.size()];
    for (int j = 0; j < paramPositions.size(); j++) {
      retArry[j] = paramPositions.get(j);
    }
    return retArry;
  }

  private static int skipCommentsAndQuotes(char[] statement, int position) {
    for (int i = 0; i < START_SKIP.length; i++) {
      if (statement[position] == START_SKIP[i].charAt(0)) {
        boolean match = true;
        for (int j = 1; j < START_SKIP[i].length(); j++) {
          if (statement[position + j] != START_SKIP[i].charAt(j)) {
            match = false;
            break;
          }
        }
        if (match) {
          int offset = START_SKIP[i].length();
          for (int m = position + offset; m < statement.length; m++) {
            if (statement[m] == STOP_SKIP[i].charAt(0)) {
              boolean endMatch = true;
              int endPos = m;
              for (int n = 1; n < STOP_SKIP[i].length(); n++) {
                if (m + n >= statement.length) {
                  // last comment not closed properly
                  return statement.length;
                }
                if (statement[m + n] != STOP_SKIP[i].charAt(n)) {
                  endMatch = false;
                  break;
                }
                endPos = m + n;
              }
              if (endMatch) {
                // found character sequence ending comment or quote
                return endPos + 1;
              }
            }
          }
          // character sequence ending comment or quote not found
          return statement.length;
        }
      }
    }
    return position;
  }
}
