package org.modellwerkstatt.manmap.runtime;

/*Generated by MPS */

import java.util.Map;
import java.util.List;
import java.util.HashMap;
import java.util.ArrayList;
import java.util.Collection;

public class MMObjectKeyStore<Key, Entity extends IM3Entity<Key>> {


  protected Map<Key, Entity> entityStore;
  protected List<Entity> toInsertedOnTransaction;

  public MMObjectKeyStore() {
    // numofKeys is ignored
    this.entityStore = new HashMap<Key, Entity>();
    this.toInsertedOnTransaction = new ArrayList<Entity>();
  }

  public void set(Key key, Entity e) {
    // after insert is done - we have a key.
    if (toInsertedOnTransaction.contains(e)) {
      toInsertedOnTransaction.remove(e);
    }
    entityStore.put(key, e);
  }
  public void addAsToInsertedOnTransaction(Entity e) {
    // no key present ..
    if (!(MMStaticAccessHelper.isNullKeyStaticHelper(e.getIM3Key()))) {
      throw new RuntimeException("The entity " + e + " has already a key set (" + e.getIM3Key() + ") and has therefore to be handled with the entityStore.");
    }
    toInsertedOnTransaction.add(e);
  }
  public Entity get(Key key) {
    return entityStore.get(key);
  }
  public boolean has(Key key) {
    return entityStore.containsKey(key);
  }
  public boolean inToInsertOnTransactionList(Entity e) {
    return toInsertedOnTransaction.contains(e);
  }


  /**
   * Both methods are not optimized for speed since they will not be used 
   * heavily. 
   * 
   * @return 
   */
  public List<Entity> getCheckedoutEntities() {
    List<Entity> result = new ArrayList<Entity>();
    Collection<Entity> all = this.entityStore.values();
    for (Entity e : all) {
      if (!(e.getReadOnly())) {
        result.add(e);
      }
    }
    for (Entity e : toInsertedOnTransaction) {
      if (!(MMStaticAccessHelper.isNullKeyStaticHelper(e.getIM3Key()))) {
        throw new RuntimeException("We have the entity " + e + " (key " + e.getIM3Key() + ") in the 'to insert on transaction' list. Session handling corrupted - this should not happen.");
      }
      if (!(e.getReadOnly())) {
        result.add(e);
      }
    }

    return result;
  }

  public List<Key> getCheckedoutEntitiesKeys() {
    List<Key> result = new ArrayList<Key>();
    Collection<Entity> all = this.entityStore.values();
    for (Entity e : all) {
      if (!(e.getReadOnly())) {
        result.add(e.getIM3Key());
      }
    }
    for (Entity e : toInsertedOnTransaction) {
      if (!(MMStaticAccessHelper.isNullKeyStaticHelper(e.getIM3Key()))) {
        throw new RuntimeException("We have the entity " + e + " (key " + e.getIM3Key() + ") in the 'to insert on transaction' list. Session handling corrupted - this should not happen.");
      }
      if (!(e.getReadOnly())) {
        result.add(e.getIM3Key());
      }
    }

    return result;
  }

  public List<Entity> getAllEntities() {
    List<Entity> result = new ArrayList<Entity>();
    Collection<Entity> all = this.entityStore.values();
    for (Entity e : all) {
      result.add(e);
    }
    for (Entity e : toInsertedOnTransaction) {
      if (!(MMStaticAccessHelper.isNullKeyStaticHelper(e.getIM3Key()))) {
        throw new RuntimeException("We have the entity " + e + " (key " + e.getIM3Key() + ") in the 'to insert on transaction' list. Session handling corrupted - this should not happen.");
      }
      result.add(e);
    }
    return result;
  }

  public List<Key> getAllEntitiesKeys() {
    List<Key> result = new ArrayList<Key>();
    Collection<Entity> all = this.entityStore.values();
    for (Entity e : all) {
      result.add(e.getIM3Key());
    }
    for (Entity e : toInsertedOnTransaction) {
      if (!(MMStaticAccessHelper.isNullKeyStaticHelper(e.getIM3Key()))) {
        throw new RuntimeException("We have the entity " + e + " (key " + e.getIM3Key() + ") in the 'to insert on transaction' list. Session handling corrupted - this should not happen.");
      }
      result.add(e.getIM3Key());
    }
    return result;
  }


  public boolean isDirty() {
    if (toInsertedOnTransaction.size() != 0) {
      return true;
    }
    Collection<Entity> all = this.entityStore.values();

    for (Entity e : all) {
      if (e.getDirty()) {
        return true;
      }
    }

    return false;
  }

  public void removeEntity(Entity entity) {
    if (!(this.entityStore.containsKey(entity.getIM3Key()))) {
      throw new IllegalArgumentException("Entity " + entity + " was not found in KeyStore for " + entity.getClass().getName());
    }
    this.entityStore.remove(entity.getIM3Key());
  }

  @Override
  public String toString() {
    String className = "(unknown)";
    if (entityStore.size() != 0) {
      className = entityStore.values().iterator().next().getClass().getName();
    }
    return "KeyStore for " + className + " with " + entityStore.size() + " objects.";
  }

  public String findDirty() {
    StringBuilder builder = new StringBuilder();
    Collection<Entity> all = this.entityStore.values();
    for (Entity e : all) {
      if (e.getDirty()) {
        builder.append("dirty entity (checkedout): " + e.getClass().getName() + "\n");
      }

    }
    for (Entity e : toInsertedOnTransaction) {
      if (e.getDirty()) {
        builder.append("dirty entity (wainting for insert): " + e.getClass().getName() + "\n");
      }

    }
    return builder.toString();
  }

  public int getRoObjectSize() {
    Collection<Entity> all = this.entityStore.values();
    int size = 0;

    for (Entity e : all) {
      if (e.getReadOnly()) {
        size++;
      }

    }
    return size;
  }

  public int getRwObjectSize() {
    return this.entityStore.size() - this.getRoObjectSize();
  }
  public int getDirtyObjectSize() {
    Collection<Entity> all = this.entityStore.values();
    int size = 0;

    for (Entity e : all) {
      if (e.getDirty()) {
        size++;
      }
    }
    for (Entity e : toInsertedOnTransaction) {
      if (e.getDirty()) {
        size++;
      }
    }

    return size;
  }
  public String getDirtyObjectInfo() {
    Collection<Entity> all = this.entityStore.values();
    String infos = "";

    for (Entity e : all) {
      if (e.getDirty()) {
        infos += " " + e + ",";
      }

    }
    for (Entity e : toInsertedOnTransaction) {
      if (e.getDirty()) {
        infos += " " + e + ",";
      }

    }
    return infos;
  }
  public static void main(String[] args) {
    // simple test ...
    MMObjectKeyStore<Integer, MMDummyEntity> myKeyStore = new MMObjectKeyStore<Integer, MMDummyEntity>();
    MMDummyEntity e = new MMDummyEntity();
    myKeyStore.set(new Integer(1), e);
    System.out.println(">> " + myKeyStore);
    myKeyStore.removeEntity(e);
    System.out.println(">> " + myKeyStore);

  }
}
