package org.modellwerkstatt.manmap.runtime;

/*Generated by MPS */

import java.sql.ResultSet;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.PreparedStatement;

public class MMQueryFromSqlRowHelper implements IM3QueryFromSqlRowRef {
  private ResultSet rs;
  public IM3TypeHandler<DateTime> _dateTimeTypeHandler = MMStaticAccessHelper._dateTimeTypeHandler;
  public IM3TypeHandler<LocalDate> _localDateTypeHandler = MMStaticAccessHelper._localDateTypeHandler;
  public IM3TypeHandler<BigDecimal> _bigDecimalTypeHandler = MMStaticAccessHelper._bigDecimalTypeHandler;
  public IM3TypeHandler<String> _stringTypeHandler = MMStaticAccessHelper._stringTypeHandler;
  public IM3TypeHandler<Integer> _intTypeHandler = MMStaticAccessHelper._intTypeHandler;


  public MMQueryFromSqlRowHelper() {
  }

  public void setResultSet(ResultSet rs) {
    this.rs = rs;
  }
  public int getAsInteger(int colId) {
    try {
      return _intTypeHandler.getResult(rs, colId + 1);
    } catch (SQLException es) {
      throw new RuntimeException("While getting colId " + colId, es);
    }
  }
  public String getAsString(int colId) {
    try {
      return _stringTypeHandler.getResult(rs, colId + 1);
    } catch (SQLException es) {
      throw new RuntimeException("While getting colId " + colId, es);
    }

  }
  public BigDecimal getAsDecimal(int colId) {
    try {
      return _bigDecimalTypeHandler.getResult(rs, colId + 1);
    } catch (SQLException es) {
      throw new RuntimeException("While getting colId " + colId, es);
    }

  }
  public DateTime getAsDateTime(int colId) {
    try {
      return _dateTimeTypeHandler.getResult(rs, colId + 1);
    } catch (SQLException es) {
      throw new RuntimeException("While getting colId " + colId, es);
    }

  }
  public LocalDate getAsLocalDate(int colId) {
    try {
      return _localDateTypeHandler.getResult(rs, colId + 1);
    } catch (SQLException es) {
      throw new RuntimeException("While getting colId " + colId, es);
    }

  }

  public int getAsInteger(String colName) {
    try {
      return _intTypeHandler.getResult(rs, colName);
    } catch (SQLException es) {
      throw new RuntimeException("While getting col '" + colName + "'", es);
    }
  }
  public String getAsString(String colName) {
    try {
      return _stringTypeHandler.getResult(rs, colName);
    } catch (SQLException es) {
      throw new RuntimeException("While getting col '" + colName + "'", es);
    }
  }
  public BigDecimal getAsDecimal(String colName) {
    try {
      return _bigDecimalTypeHandler.getResult(rs, colName);
    } catch (SQLException es) {
      throw new RuntimeException("While getting col '" + colName + "'", es);
    }
  }
  public DateTime getAsDateTime(String colName) {
    try {
      return _dateTimeTypeHandler.getResult(rs, colName);
    } catch (SQLException es) {
      throw new RuntimeException("While getting col '" + colName + "'", es);
    }
  }
  public LocalDate getAsLocalDate(String colName) {
    try {
      return _localDateTypeHandler.getResult(rs, colName);
    } catch (SQLException es) {
      throw new RuntimeException("While getting col '" + colName + "'", es);
    }
  }








  public void setIntegerParameter(PreparedStatement statement, int index, int val, StringBuilder debugSb) {
    try {
      _intTypeHandler.setParameter(statement, index + 1, val, debugSb);
    } catch (SQLException ex) {
      throw new RuntimeException("While setting param " + index, ex);
    }
  }
  public void setStringParameter(PreparedStatement statement, int index, String val, StringBuilder debugSb) {
    try {
      _stringTypeHandler.setParameter(statement, index + 1, val, debugSb);
    } catch (SQLException ex) {
      throw new RuntimeException("While setting param " + index, ex);
    }
  }
  public void setBigDecimalParameter(PreparedStatement statement, int index, BigDecimal val, StringBuilder debugSb) {
    try {
      _bigDecimalTypeHandler.setParameter(statement, index + 1, val, debugSb);
    } catch (SQLException ex) {
      throw new RuntimeException("While setting param " + index, ex);
    }
  }
  public void setDateTimeParameter(PreparedStatement statement, int index, DateTime val, StringBuilder debugSb) {
    try {
      _dateTimeTypeHandler.setParameter(statement, index + 1, val, debugSb);
    } catch (SQLException ex) {
      throw new RuntimeException("While setting param " + index, ex);
    }
  }
  public void setLocalDateParameter(PreparedStatement statement, int index, LocalDate val, StringBuilder debugSb) {
    try {
      _localDateTypeHandler.setParameter(statement, index + 1, val, debugSb);
    } catch (SQLException ex) {
      throw new RuntimeException("While setting param " + index, ex);
    }
  }
}
