package org.modellwerkstatt.manmap.runtime;

/*Generated by MPS */

import java.util.Map;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import java.util.HashMap;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IMapping;
import jetbrains.mps.internal.collections.runtime.Sequence;

public abstract class MMSession implements IM3Session {
  protected Map<Integer, MMObjectKeyStore> keyStores = MapSequence.fromMap(new HashMap<Integer, MMObjectKeyStore>());
  protected List<IM3Entity> transactionEntities = ListSequence.fromList(new ArrayList<IM3Entity>());
  protected volatile boolean readOnly;
  protected boolean dirty;

  public MMSession() {
    readOnly = false;
  }

  public MMObjectKeyStore getOrCreateKeyStore(int uniqueHierarchyHashCode) {
    if (Thread.interrupted()) {
      throw new MMShutdownRequestException("getOrCreateKeyStore() - Thread.interrupted()=true, raising ShutDownRequest Exception.");
    }
    if (MapSequence.fromMap(keyStores).get(uniqueHierarchyHashCode) == null) {
      MapSequence.fromMap(keyStores).put(uniqueHierarchyHashCode, new MMObjectKeyStore());
    }
    return MapSequence.fromMap(keyStores).get(uniqueHierarchyHashCode);
  }

  public void ensureInSession(Object obj) {

    if (obj instanceof IM3Entity) {
      IM3Entity ent = ((IM3Entity) obj);
      int uniqueHierarchyHashCode = ent.getSessionObjectKeyStoreID();
      if (MapSequence.fromMap(keyStores).get(uniqueHierarchyHashCode) == null) {
        MapSequence.fromMap(keyStores).put(uniqueHierarchyHashCode, new MMObjectKeyStore());
      }

      if (MapSequence.fromMap(keyStores).get(uniqueHierarchyHashCode).has(ent.getIM3Key())) {
        // already present in session, having a key

      } else if (!(MMStaticAccessHelper.isNullKeyStaticHelper(ent.getIM3Key()))) {
        // it has a key, add it to key store
        MapSequence.fromMap(keyStores).get(uniqueHierarchyHashCode).set(ent.getIM3Key(), ent);

      } else {
        //  no key present
        MapSequence.fromMap(keyStores).get(uniqueHierarchyHashCode).addAsToInsertedOnTransaction(ent);

      }


    } else if (obj instanceof List) {
      for (Object singleEntity : ((List<Object>) obj)) {
        ensureInSession(singleEntity);
      }

    } else {
      throw new RuntimeException("ensureInSession() can be called with param list<Entity> or Entity only. (called with " + obj + ")");
    }

  }


  public String getKeyStoreInfo() {
    final StringBuilder sb = new StringBuilder();
    sb.append("---------- M3ManMapSession STATISTICS ----------\n");
    final Wrappers._int ro = new Wrappers._int(0);
    final Wrappers._int rw = new Wrappers._int(0);
    final Wrappers._int dirty = new Wrappers._int(0);
    final Wrappers._T<String> dirtyInfo = new Wrappers._T<String>("");
    MapSequence.fromMap(keyStores).visitAll(new _FunctionTypes._void_P1_E0<IMapping<Integer, MMObjectKeyStore>>() {
      public void invoke(IMapping<Integer, MMObjectKeyStore> it) {
        ro.value = ro.value + it.value().getRoObjectSize();
        rw.value = rw.value + it.value().getRwObjectSize();
        dirty.value = dirty.value + it.value().getDirtyObjectSize();
        dirtyInfo.value = dirtyInfo.value + it.value().getDirtyObjectInfo();
      }
    });
    sb.append("Read Only Objects: " + ro.value + "\n");
    sb.append("Read Write Objects: " + rw.value + "\n");
    sb.append("Dirty Objects: " + dirty.value + "\n");
    sb.append("               " + dirtyInfo.value);

    sb.append("\n\n");
    sb.append("Keystores in this session currently " + MapSequence.fromMap(keyStores).count() + " ------ \n");
    MapSequence.fromMap(keyStores).visitAll(new _FunctionTypes._void_P1_E0<IMapping<Integer, MMObjectKeyStore>>() {
      public void invoke(IMapping<Integer, MMObjectKeyStore> it) {
        sb.append(it.value().toString() + "\n");
      }
    });

    return sb.toString();
  }
  public boolean isDirty() {
    List<MMObjectKeyStore> stores = Sequence.fromIterable(MapSequence.fromMap(keyStores).values()).toList();
    if (dirty) {
      return true;
    }
    for (int i = 0; i < ListSequence.fromList(stores).count(); i++) {
      if (ListSequence.fromList(stores).getElement(i).isDirty()) {
        return true;
      }
    }
    return false;
  }

  public void setDirty() {
    dirty = true;
  }
  public String findDirtyEntities() {
    StringBuilder builder = new StringBuilder();
    List<MMObjectKeyStore> stores = Sequence.fromIterable(MapSequence.fromMap(keyStores).values()).toList();
    for (int i = 0; i < ListSequence.fromList(stores).count(); i++) {
      builder.append(ListSequence.fromList(stores).getElement(i).findDirty());
    }
    return builder.toString();
  }
  public boolean isReadOnly() {
    return this.readOnly;
  }
  public void setReadOnly() {
    // only session is set to readonly, not entities
    this.readOnly = true;
  }
  public void addEntityInvolvedInTransaction(IM3Entity e) {
    ListSequence.fromList(transactionEntities).addElement(e);
  }

  public void clearAllKeystores() {
    MapSequence.fromMap(keyStores).clear();
    ListSequence.fromList(transactionEntities).clear();
  }

  public <T> List<T> getEntitiesCheckedOut(int uniqueSessionEntityID) {
    if (MapSequence.fromMap(keyStores).get(uniqueSessionEntityID) == null) {
      return ListSequence.fromList(new ArrayList<T>());
    }
    return ((List<T>) MapSequence.fromMap(keyStores).get(uniqueSessionEntityID).getCheckedoutEntities());
  }

  public <T> List<T> getEntitiesCheckedOutKey(int uniqueSessionEntityID) {
    if (MapSequence.fromMap(keyStores).get(uniqueSessionEntityID) == null) {
      return ListSequence.fromList(new ArrayList<T>());
    }
    return ((List<T>) MapSequence.fromMap(keyStores).get(uniqueSessionEntityID).getCheckedoutEntitiesKeys());
  }

  public <T> List<T> getEntitiesAll(int uniqueSessionEntityID) {
    if (MapSequence.fromMap(keyStores).get(uniqueSessionEntityID) == null) {
      return ListSequence.fromList(new ArrayList<T>());
    }
    return ((List<T>) MapSequence.fromMap(keyStores).get(uniqueSessionEntityID).getAllEntities());
  }

  public <T> List<T> getEntitiesAllKey(int uniqueSessionEntityID) {
    if (MapSequence.fromMap(keyStores).get(uniqueSessionEntityID) == null) {
      return ListSequence.fromList(new ArrayList<T>());
    }
    return ((List<T>) MapSequence.fromMap(keyStores).get(uniqueSessionEntityID).getAllEntitiesKeys());
  }


  public void detachAllEntitiesByUniqueHashCode(int uniqueId) {
    // set keyStore to null
    if (MapSequence.fromMap(keyStores).get(uniqueId) != null) {
      MapSequence.fromMap(keyStores).removeKey(uniqueId);

    } else {
      throw new IllegalArgumentException("Class with id " + uniqueId + " currently not used in this Session, can not detach it.");
    }


    // However, all references do still exist in app code !!
  }
}
