package org.modellwerkstatt.dataux.runtime.core;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.genspecifications.IGenAppUiModule;
import org.springframework.beans.factory.annotation.Autowired;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXApplicationFactory;
import org.modellwerkstatt.dataux.runtime.genspecifications.Menu;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import java.util.List;
import org.modellwerkstatt.dataux.runtime.genspecifications.TileAction;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.IOFXUserServices;
import java.lang.reflect.Method;
import org.modellwerkstatt.objectflow.runtime.Log4JProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.modellwerkstatt.objectflow.runtime.UserEnvironmentInformation;
import org.springframework.context.NoSuchMessageException;
import java.lang.reflect.InvocationTargetException;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;

public abstract class AbstractBatchJobUi implements IGenAppUiModule {
  public String appName;

  @Autowired
  protected IOFXPlatform __iOFXPlatform;
  @Autowired
  protected IOFXTranslationProvider __org_modellwerkstatt_objectflow_runtime_IOFXTranslationProvider;
  @Autowired
  protected IOFXApplicationFactory __localApplicationFactory;


  public AbstractBatchJobUi(String aAppName) {
    appName = aAppName;
  }

  @Override
  public Menu createStartMenu(IOFXUserEnvironment userEnv) {
    return new Menu();
  }
  @Override
  public Menu createExtrasMenu(IOFXUserEnvironment userEnv) {
    return new Menu();
  }
  @Override
  public Menu createHelpMenu(IOFXUserEnvironment userEnv) {
    return new Menu();
  }
  @Override
  public BasisCmdStart createStartupCmd(IOFXSession session) {
    return null;
  }
  @Override
  public void recalcTilesLabel(IOFXUserEnvironment userEnvironment, final IOFXSession session, List<TileAction> tileActions) {
    if (tileActions == null) {
      throw new IllegalStateException("You can not recalc tiles labels when tiles are not initialized. ");
    }
    ListSequence.fromList(tileActions).visitAll((it) -> it.calcAndSetCurrentTileLabel(session));
  }
  @Override
  public String getShortAppName() {
    return appName;
  }
  @Override
  public void userLoggedIn(IOFXUserEnvironment env, IOFXUserServices srv) {
  }

  public static void startupUiFromMain(String[] args, String xmlConfig, AbstractBatchJobUi uiGenInstance) {
    try {
      System.setProperty("glass.accessible.force", "false");

      Class classWithMain;
      Method m;

      if (args.length > 0) {
        xmlConfig = args[0];
      }

      // init spring ioc first : )
      Log4JProperties.initRichClientSetup();
      ApplicationContext context = new ClassPathXmlApplicationContext(xmlConfig);
      Log4JProperties.endRichClientSetup(false);

      IOFXApplicationFactory factory = context.getBean(IOFXApplicationFactory.class);
      if (factory == null) {
        throw new ClassNotFoundException("Config error - factory or userenvironment is null!");
      }


      UserEnvironmentInformation evn = new UserEnvironmentInformation();
      classWithMain = uiGenInstance.getClass().getClassLoader().loadClass("org.modellwerkstatt.fx8forms.windows.FX8Application");
      m = classWithMain.getMethod("run", IGenAppUiModule.class, IOFXApplicationFactory.class, UserEnvironmentInformation.class);

      context.getAutowireCapableBeanFactory().autowireBean(uiGenInstance);
      m.invoke(null, uiGenInstance, factory, evn);

    } catch (NoSuchMessageException nsme) {
      nsme.printStackTrace();
      throw new RuntimeException(nsme);

    } catch (ClassNotFoundException cnfe) {
      cnfe.printStackTrace();
      throw new RuntimeException(cnfe);

    } catch (InvocationTargetException ite) {
      ite.printStackTrace();
      throw new RuntimeException(ite);

    } catch (IllegalAccessException eae) {
      eae.printStackTrace();
      throw new RuntimeException(eae);

    } catch (Throwable t) {
      t.printStackTrace();
      throw new RuntimeException(t);

    } finally {
      OFXConsoleHelper.unbindJmxRmiNaming(true);
    }
  }

}
