package org.modellwerkstatt.dataux.runtime.core;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.runtime.IOFXUserServices;
import java.util.List;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenSelControlled;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_MainWindow;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenAppUiModule;
import org.modellwerkstatt.dataux.runtime.telemetrics.AppJmxRegistration;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import java.util.ArrayList;
import org.modellwerkstatt.objectflow.runtime.OFXUrlParams;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.dataux.runtime.genspecifications.CmdAction;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_CommandContainerUi;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Form;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.Collections;

public class ApplicationMDI extends AppMainWindowController implements IOFXUserServices, IApplication {

  protected List<ICommandContainer> runningTabCommandContainers;
  protected ICommandContainer promptWindowCommandContainer;

  private int currentRunningTabIndex;
  private boolean deliverTabChangeFocusEvent;


  private ISelectionController selCrtlAcrossTabs = new ISelectionController() {
    public ISelectionController registerSelControlled(Class interestedInSelectionType, ISelectionController.Binding binding, IGenSelControlled xuElemToRegister) {
      return null;
    }
    public IOFXSelection getSelectionAbsolute(Class cls, boolean includingDerived) {
      if (currentRunningTabIndex >= 0) {
        return runningTabCommandContainers.get(currentRunningTabIndex).getSelectionAbsoluteFromCurrentPagePane(cls, includingDerived);
      }
      return null;
    }
    public void pushSelectionAbsolute(IOFXSelection sel) {
      throw new RuntimeException("Not implemented.");
    }
    public void forceNotEditable() {
      throw new RuntimeException("Not implemented.");
    }
    public IOFXSelection getLocalSelection() {
      return null;
    }
    public void issueUpdateConclusion(IUpdateConclusionReceiver.IFocusAbleDelegate newFocusHolder) {
      if (currentRunningTabIndex >= 0) {
        runningTabCommandContainers.get(currentRunningTabIndex).receiveAndProcess(new ConclusionEvent(1, "UPDATE"));
      }
    }
  };


  public ApplicationMDI(IToolkit_UiFactory factory, IToolkit_MainWindow appWin, IGenAppUiModule appBehavior, AppJmxRegistration registration, IOFXCoreReporter.MoWarePlatform pltfrm) {
    super(factory, appBehavior, registration, pltfrm);

    runningTabCommandContainers = new ArrayList<ICommandContainer>();
    promptWindowCommandContainer = null;

    //  MDI specfic stuff
    appMainWindow = appWin;
    mainWindowController = new WindowControllerMDI(factory, this, appWin);

    currentRunningTabIndex = -1;
    deliverTabChangeFocusEvent = true;
  }

  public boolean initializeApplication(OFXUrlParams url, String systemName, IOFXUserEnvironment userEnv, String userConnectionInfo, String connectInfoAddOn) {
    return super.initializeApplication(url, selCrtlAcrossTabs, systemName, userEnv, userConnectionInfo, connectInfoAddOn);
  }

  public void onKeyPressEvent(KeyEvent ev) {
    if (shutdownMode) {
      return;
    }

    if ("DBG_LOCKING".equals(ev.getKey())) {
      mainWindowController.showBigInformationDialog("LOCKING SERVICE DEBUGGER:\n\n Please check locking information via dashboard.", null);
      return;
    }

    // (1) alternatively, one could check prompt window here.
    // dispatch it to promptwindow if opened

    // (2) evaluate command triggers in menu ?
    if (!(applicationModalTabMode)) {
      for (CmdAction action : mainMenuAndTileActions) {
        // trg.hotKey can be null !
        if (ev.getKey().equals(action.hotKey) && action.reevalEnabled()) {
          // especially in the menu, we are using the fake controller#
          // which delegates to the current tab, if available.
          action.startCommand();
          return;
        }
      }
    }

    // (3) if not, dispatch it to the current tab, might also be the modal tab
    if (currentRunningTabIndex >= 0) {
      runningTabCommandContainers.get(currentRunningTabIndex).receiveAndProcess(ev);

    }
  }


  public void onTabChangeEvent(int currentIndex) {
    if (shutdownMode) {
      return;
    }
    currentRunningTabIndex = currentIndex;

    if (currentRunningTabIndex >= 0) {
      reevalEnabledInMenusAndTiles();
      if (deliverTabChangeFocusEvent) {
        runningTabCommandContainers.get(currentRunningTabIndex).receiveAndProcess(new FocusEvent(false));
      }
    }
  }

  public void showCommandContainerUI(ICommandContainer cmdCont, IToolkit_CommandContainerUi ui, String windowTitle, IToolkit_Form content) {

    if (!(ui.isTabWindow())) {
      // H2forms never uses prompt windows ...
      if (promptWindowCommandContainer != null) {

        throw new RuntimeException("Application error: opening a prompt window " + cmdCont + " while a prompt window is already executed " + promptWindowCommandContainer);
      }
      promptWindowCommandContainer = cmdCont;
      content.rootForm();
      ui.show(windowTitle, content);

    } else {
      deliverTabChangeFocusEvent = false;
      // register/dereg commandContainer ?
      runningTabCommandContainers.add(cmdCont);
      content.rootForm();
      ui.show(windowTitle, content);

      currentRunningTabIndex++;
      // maybe UI Toolkit will change currentRunningTabIndex with onTabChangeEvent()
      appMainWindow.addTab(ui);

      if (ui.isModalTabWindow()) {
        lockCurrentTabAsModal(true);
      }

      deliverTabChangeFocusEvent = true;
    }

    checkToInstallConfirmCloseAlert();
  }

  public void lockCurrentTabAsModal(boolean lock) {

    if (lock) {
      if (promptWindowCommandContainer != null || applicationModalTabMode) {
        throw new RuntimeException("Progamming error - this should not happen. promptWindow open or modalTab already running?" + promptWindowCommandContainer + " / " + applicationModalTabMode);
      }

      applicationModalTabMode = true;
      appMainWindow.setCurrentTabModal(true);

    } else {
      // might also be called to clear tab modal on shutdown etc..
      // gracfully do not report any problems.
      if (!(applicationModalTabMode)) {
        logFrmwrkProblem("", "", IOFXCoreReporter.APP, "AppCrtl.lockCurrenTabAsModal(false) called while not in modal mode.", OFXConsoleHelper._____organizeCurrentStacktrace_____() + " \n \n " + fullApplicationCrtlState());
      }
      applicationModalTabMode = false;
      appMainWindow.setCurrentTabModal(false);

    }
  }

  public void closeCommandContainerUI(ICommandContainer cmd, IToolkit_CommandContainerUi ui, ICommandContainer parent) {
    reevalEnabledInMenusAndTiles();

    if (ui == null) {
      // command (without page and ui) closed. this is just a refocus event
      if (!(shutdownMode)) {

        if (promptWindowCommandContainer != null) {
          promptWindowCommandContainer.receiveAndProcess(new FocusEvent(false));

        } else if (currentRunningTabIndex >= 0) {
          runningTabCommandContainers.get(currentRunningTabIndex).receiveAndProcess(new FocusEvent(false));

        } else {
          recalcAndShowTiles();
        }

      }

    } else if (ui.isTabWindow()) {
      if (ui.isModalTabWindow()) {
        // remove lock first..... double check with internal modalWindowTabWindow
        lockCurrentTabAsModal(false);
      }

      int i = currentRunningTabIndex;
      // currentRunningTabIndex will be changed by event From MainWindow
      deliverTabChangeFocusEvent = false;
      runningTabCommandContainers.remove(cmd);

      currentRunningTabIndex--;
      // maybe UI Toolkit will change currentRunningTabIndex with onTabChangeEvent()
      appMainWindow.ensureTabClosed(ui);
      ui.close();

      if (!(shutdownMode) && parent != null && runningTabCommandContainers.indexOf(parent) >= 0) {
        parent.receiveAndProcess(new FocusEvent(true));

      } else if (!(shutdownMode) && runningTabCommandContainers.size() > 0) {
        i--;
        if (i < 0) {
          i = 0;
        }
        runningTabCommandContainers.get(i).receiveAndProcess(new FocusEvent(true));

      } else if (!(shutdownMode)) {
        recalcAndShowTiles();

      }
      deliverTabChangeFocusEvent = true;

    } else {
      // H2forms never uses prompt windows ...
      promptWindowCommandContainer = null;
      ui.close();

      if (!(shutdownMode) & currentRunningTabIndex >= 0) {
        runningTabCommandContainers.get(currentRunningTabIndex).receiveAndProcess(new FocusEvent(false));
      }

    }
    checkToInstallConfirmCloseAlert();
  }

  public void focusTab(ICommandContainer cc, IToolkit_CommandContainerUi ui) {

    deliverTabChangeFocusEvent = false;
    appMainWindow.focusTab(ui);
    deliverTabChangeFocusEvent = true;
  }

  public boolean noGraphsToCommit() {
    for (int i = 0; i < runningTabCommandContainers.size(); i++) {
      if (runningTabCommandContainers.get(i).hasRwSessionToCommit()) {
        return false;
      }
    }
    return true;
  }

  public void onExitRequested(boolean doNotCheckBackOnOpenGO) {
    // exit was requested by START->quit or by
    // closing window with (X)
    boolean noGraphsOpen = noGraphsToCommit();

    if (doNotCheckBackOnOpenGO || noGraphsOpen) {
      shutdownMode = true;
      this.internal_immediatelyShutdown();
      appMainWindow.closeApplicationAndExit();

    } else {
      appMainWindow.showDialog(IToolkit_MainWindow.DlgType.QUESTIONCLOSE_SMALL, uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.CLOSE_APP), new IApplication.DlgRunnable() {
        public void run(boolean confirmed) {
          if (confirmed) {
            ApplicationMDI.this.internal_immediatelyShutdown();
            appMainWindow.closeApplicationAndExit();

          }
        }
      });

    }

  }

  /**
   * 
   * @deprecated 
   */
  @Deprecated
  public void legacyStartCommandByUriAndParam(final String uri, String firstParam) {
    CmdAction actionToStart;
    final Wrappers._int i = new Wrappers._int(0);
    final StringBuilder available = new StringBuilder();
    actionToStart = ListSequence.fromList(mainMenuAndTileActions).findFirst((it) -> {
      String uriIdent = it.labelText.toLowerCase().replaceAll("\\W", "");

      available.append(uriIdent + "," + ((i.value++ % 5 == 0 ? "\n" : "")));
      return uri.equals(uriIdent);
    });

    if (actionToStart == null) {
      String availableString = available.toString();
      availableString = availableString.substring(0, availableString.lastIndexOf(","));
      mainWindowController.showSimpleInfoDialog(String.format(uiFactory.getSystemLabel(userLangIndex, MoWareTranslations.Key.CMD_NOT_AVAILABLE), availableString), null);
    } else {
      // calculateParams()methodsignaturecouldbechanged,sinceworkingwithlocalSelectionCrtlsnow
      Object[] params = actionToStart.calculateParams(null);
      if (params == null) {
        throw new RuntimeException("This can not be true. Tried to start a command with params null.");
      }

      if (firstParam != null) {
        params[0] = firstParam;
      }

      final BasisCmdStart ev = new BasisCmdStart(actionToStart.commandFqName, params);
      ev.setLabelText(actionToStart.labelText);

      execAfterStartupOrNow(new Runnable() {
        @Override
        public void run() {
          mainWindowController.receiveAndProcess(ev);
        }
      });
    }
  }


  public void startCommandWithoutParams(CmdAction actionToStart) {
    Object[] params = actionToStart.calculateParams(null);
    if (params == null) {
      throw new RuntimeException("This can not be true. Tried to start a command with params null.");
    }
    BasisCmdStart ev = new BasisCmdStart(actionToStart.commandFqName, params);
    ev.setLabelText(actionToStart.labelText);
    mainWindowController.receiveAndProcess(ev);
  }

  public void internal_closeAllRunningCmds() {
    deliverTabChangeFocusEvent = false;

    afterStartupCmd = null;
    if (promptWindowCommandContainer != null) {
      promptWindowCommandContainer.internal_immediatelyShutdown();
    }

    if (runningTabCommandContainers.size() > 0) {
      // prevent co-modification of array
      List<ICommandContainer> runningTabsReverse = new ArrayList<ICommandContainer>(runningTabCommandContainers);
      Collections.reverse(runningTabsReverse);

      for (ICommandContainer c : runningTabsReverse) {
        c.internal_immediatelyShutdown();
      }
    }

    // nicely shut down every command, all containers also? e.g. cntr in CloseExInfoOnScreen 
    for (ICommandContainer container : List.copyOf(allRunningContainersToTerminate)) {
      logFrmwrkProblem("", "", IOFXCoreReporter.APP, "The container " + container + " was not terminated as running prompt or tab in internal_closeAllRunningCmds(). [Dialog not acknowledged, but killed?]", "");
      container.internal_immediatelyShutdown();
    }

    deliverTabChangeFocusEvent = true;
  }

  @Override
  public boolean isSameInstanceRunningThenFocus(String fqName, Object[] params) {
    boolean running = false;
    for (ICommandContainer cntr : runningTabCommandContainers) {
      if (cntr.isSameCommandInstance(fqName, params)) {
        cntr.receiveAndProcess(new FocusEvent(true));
        // not started, already existing
        running = true;
        break;
      }
    }
    return running;
  }



  public String fullApplicationCrtlState() {
    String s = appUserSystemVersionInfo() + " " + deviceId + ": ";

    Object[] allCommanndsRightNow = runningTabCommandContainers.toArray();
    for (int i = 0; i < allCommanndsRightNow.length; i++) {
      s += "TAB " + (i + 1) + " " + allCommanndsRightNow[i] + ", ";
    }

    if (promptWindowCommandContainer != null) {
      s += "PROMPT " + promptWindowCommandContainer;
    }

    return s;
  }

  @Override
  public String toString() {
    return fullApplicationCrtlState() + ((shutdownMode ? " SHUTDOWNMODE" : ""));
  }

  private String lastRequestedRedirect = null;
  @Override
  public void openUrl(String url) {
    lastRequestedRedirect = url;
    appPrintService.openUrl(url);
  }

  public String getLastRequestedRedirectAndReset() {
    String red = lastRequestedRedirect;
    lastRequestedRedirect = null;
    return red;
  }

}
