package org.modellwerkstatt.dataux.runtime.core;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Form;
import java.util.List;
import java.util.ArrayList;

/**
 * Focus Controlling does strongly depend on View Hierarchy 
 * and visibility / read only state
 * 
 * There there is no relationship between SelectionController or 
 * generated controllers. Focus Controlling has to be tracked on its own. 
 * 
 */
public class FocusController<T extends IToolkit_Form> {
  private List<T> children;
  private int skipFocusCmptIndex;


  public FocusController() {
    children = new ArrayList<T>();
    skipFocusCmptIndex = 0;
  }

  public void addChild(T f) {
    children.add(f);
  }
  public List<T> getChildren() {
    return children;
  }
  public void skipFocus(int cmptIndex) {
    skipFocusCmptIndex = cmptIndex;
  }
  public Object myRequestFocus() {
    Object toFocus = null;

    for (int i = skipFocusCmptIndex; i < children.size(); i++) {
      T implCmpt = children.get(i);
      toFocus = implCmpt.myRequestFocus();
      if (toFocus != null) {
        return toFocus;
      }
    }
    return toFocus;
  }
  public Object myRequestFocusOnChild(int i) {
    return children.get(i).myRequestFocus();
  }
  public void afterFullUiInitialized() {
    for (T f : children) {
      f.afterFullUiInitialized();
    }
  }

  public void gcClear() {
    children.clear();
  }

}
