package org.modellwerkstatt.dataux.runtime.core;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.runtime.IOFXUserServices;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenAppUiModule;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.OFXAbortedException;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.runtime.CoreReporterInfo;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import java.util.HashMap;
import java.io.File;

public class LoginController implements IOFXUserServices {
  private IOFXCoreReporter.MoWarePlatform pltfrm;
  private String systemName;
  private String deviceNameAndSw;
  private String deviceId;
  private String deviceConnectInfo;
  private boolean noExAndNoPreconditionButFalseReturnInStartup;

  private String appVersion;
  private String appFqName;

  private IToolkit_UiFactory fact;


  public LoginController(IToolkit_UiFactory factory, IOFXCoreReporter.MoWarePlatform aPlatform, String aSystemName, String connectInfo) {
    pltfrm = aPlatform;
    systemName = aSystemName;
    deviceConnectInfo = connectInfo;
    fact = factory;
  }
  public boolean notAuthenticatedButNoProblems() {
    return noExAndNoPreconditionButFalseReturnInStartup;
  }
  public String checkLoginPrepareUserEnv(String username, String password, IOFXUserEnvironment env, IGenAppUiModule uiModule) {

    noExAndNoPreconditionButFalseReturnInStartup = false;

    // check app startup method first ..
    boolean startupOk = false;
    String defaultNoLoginStr = String.format(fact.getSystemLabel(-1, MoWareTranslations.Key.LOGIN_USER_FAILED), username);


    // let devs. access roles after userName/Id is set in app UI-Module
    IOFXSession session = fact.createNewSession(env, this);

    try {
      appFqName = uiModule.getClass().getName();
      appVersion = uiModule.getApplicationVersion();
      deviceNameAndSw = env.getDeviceName() + " " + env.getDeviceSwName();
      deviceId = env.getDeviceId();

      // uiFactory might put in the wrong userEnvironment here.
      startupOk = uiModule.startup(username, password, env, session);
      if (startupOk == false) {
        noExAndNoPreconditionButFalseReturnInStartup = true;
      }

    } catch (OFXAbortedException ex) {
      List<IOFXProblem> problems = session.getAndclearProblemState();
      defaultNoLoginStr = OFXConsoleHelper.asSimpleString(problems);

    } catch (Throwable t) {
      startupOk = false;

      CoreReporterInfo info = new CoreReporterInfo(IOFXCoreReporter.Type.APP_PROBLEM, appFqName, appVersion, IOFXCoreReporter.LOGIN, "", "", IOFXCoreReporter.LogPriority.ERROR, 0, "", deviceNameAndSw, deviceId, deviceConnectInfo, MoVersion.MOWARE_PLUGIN_VERSION, pltfrm, systemName, "Ex in startup while logging in");

      info.setException(t);
      info.addParameter("USERNAME", username);
      fact.report(info);

    } finally {
      session.closeSessionAndfreeGC();

    }

    if (!(startupOk)) {

      CoreReporterInfo info = new CoreReporterInfo(IOFXCoreReporter.Type.APP_MESSAGE, appFqName, appVersion, IOFXCoreReporter.LOGIN, "", "", IOFXCoreReporter.LogPriority.INFO, 0, "", deviceNameAndSw, deviceId, deviceConnectInfo, MoVersion.MOWARE_PLUGIN_VERSION, pltfrm, systemName, "User '" + username + "' not logged in");

      info.addParameter("USERNAME", username);
      fact.report(info);

      return defaultNoLoginStr;
    }

    return null;
  }



  @Override
  public void logOnCoreReporter(String cmdFqName, String sessId, String source, IOFXCoreReporter.LogPriority prio, String desc, HashMap<String, Object> paramMap) {

    CoreReporterInfo info = new CoreReporterInfo(IOFXCoreReporter.Type.APP_MESSAGE, appFqName, appVersion, source, cmdFqName, sessId, prio, 0, "", deviceNameAndSw, deviceId, deviceConnectInfo, MoVersion.MOWARE_PLUGIN_VERSION, pltfrm, systemName, desc);

    if (paramMap != null) {
      for (String key : paramMap.keySet()) {
        info.addParameter(key, paramMap.get(key));
      }
    }

    fact.report(info);
  }
  public void logExOnCoreReporter(String cmdFqName, String sessId, String source, IOFXCoreReporter.LogPriority prio, String desc, Throwable ex) {

    CoreReporterInfo info = new CoreReporterInfo(IOFXCoreReporter.Type.APP_MESSAGE, appFqName, appVersion, source, cmdFqName, sessId, prio, 0, "", deviceNameAndSw, deviceId, deviceConnectInfo, MoVersion.MOWARE_PLUGIN_VERSION, pltfrm, systemName, desc);

    info.setException(ex);
    fact.report(info);
  }
  public File renderPrint(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode) {
    throw new RuntimeException("User not logged in, UserService not accessible.");
  }
  public File renderView(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode) {
    throw new RuntimeException("User not logged in, UserService not accessible.");
  }
  public File render(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode) {
    throw new RuntimeException("User not logged in, UserService not accessible.");
  }
  public void view(File pdfFile) {
    throw new RuntimeException("User not logged in, UserService not accessible.");
  }
  public void print(File pdfFile) {
    throw new RuntimeException("User not logged in, UserService not accessible.");
  }
  public void openUrl(String url) {
    throw new RuntimeException("User not logged in, UserService not accessible.");
  }
}
