package org.modellwerkstatt.dataux.runtime.core;

/*Generated by MPS */

import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXDynCmdParams;

public class MultiCmdStart extends UxEvent {
  private int currentExecutions;
  private int totalExecutions;
  private boolean goOnWhenCanceled = false;
  private boolean fastExecWithNoUi = false;
  private BasisCmdStart protoType;
  private ICommandContainer parent;


  private List<Object> initialLocalSelection;
  private ISelectionController localSelectionCrtl;
  private IOFXDynCmdParams defaultDynParameterProvider;


  public MultiCmdStart(BasisCmdStart proto, List<Object> localSel, ISelectionController localSelCrtl, IOFXDynCmdParams parameterProvider) {
    protoType = proto;
    initialLocalSelection = localSel;
    totalExecutions = initialLocalSelection.size();
    currentExecutions = 0;
    localSelectionCrtl = localSelCrtl;
    defaultDynParameterProvider = parameterProvider;
  }

  public void enable_goOnWhenCanceled() {
    goOnWhenCanceled = true;
  }
  public void enable_fastExecNoUi() {
    fastExecWithNoUi = true;
  }
  public boolean isFastExecNoUi() {
    return fastExecWithNoUi;
  }
  public boolean isGoOnWhenCanceled() {
    return goOnWhenCanceled;
  }
  public boolean isLast() {
    return currentExecutions >= totalExecutions;
  }
  public boolean willBeFirstExecution() {
    return currentExecutions == 1;
  }
  public void incExecutions() {
    currentExecutions++;
  }

  public Object getCurrentLocalSelection() {
    return initialLocalSelection.get(currentExecutions);
  }
  public ISelectionController getLocalSelCrtl() {
    return localSelectionCrtl;
  }
  public boolean hasNonDefaultParamProvider() {
    return defaultDynParameterProvider != null;
  }
  public IOFXDynCmdParams getNonDefaultParamProvider() {
    return defaultDynParameterProvider;
  }
  public String getCommandName() {
    return protoType.getCommandName();
  }
  public BasisCmdStart getParameterizedStartEvent(Object[] params) {
    BasisCmdStart cloned = protoType.cloneWithParams(params);
    cloned.setParent(getParentContainer());
    return cloned;
  }

  public void setParent(ICommandContainer par) {
    parent = par;
  }
  public ICommandContainer getParentContainer() {
    return parent;
  }

  public String paramInfo() {
    return protoType.paramInfo() + " / " + currentExecutions + " / " + totalExecutions;
  }

  public void gcClean() {
    localSelectionCrtl = null;
    defaultDynParameterProvider = null;
    initialLocalSelection = null;
  }
}
