package org.modellwerkstatt.dataux.runtime.core;

/*Generated by MPS */

import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenSelControlled;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import org.modellwerkstatt.objectflow.runtime.Selection;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import org.modellwerkstatt.dataux.runtime.utils.MoJSON;

public class SelectionController implements ISelectionController {

  protected static final boolean DEBUG = false;
  protected static final String CHECKING_FOR = "at.hafina.kmsw.kmsw.KonditionsmanagementDATA.Kondition";

  protected List<SelectionController> dependentSelectionController = ListSequence.fromList(new ArrayList<SelectionController>());
  protected List<IGenSelControlled> attachedGenElems = ListSequence.fromList(new ArrayList<IGenSelControlled>());
  protected SelectionController parentcontroller;

  protected Class responsibleForSelectionType;
  protected Class boundToType;
  protected String boundToProperty;
  protected IOFXSelection selection;
  protected PagePaneSelCrtl pagePaneCrtl = null;


  protected SelectionController(PagePaneSelCrtl ppCrtl, SelectionController parent, Class resSelType, String propBinding) {
    this.responsibleForSelectionType = resSelType;
    this.pagePaneCrtl = ppCrtl;
    boundToProperty = propBinding;

    selection = new Selection(this.responsibleForSelectionType);

    // set parent type and parent view container
    this.parentcontroller = parent;
    this.boundToType = null;
    if (parent != null) {
      this.boundToType = parent.responsibleForSelectionType;
    }
  }

  public ISelectionController registerSelControlled(final Class typeOfIterestedInSelection, ISelectionController.Binding binding, IGenSelControlled uxElemToRegister) {
    // interestedSelectionType is the contentType of a DelegateForm or a Table

    // binding can not be null
    // reqBound class can not be null
    // reqBoundProperty can not be null but ""
    final Class reqBoundType = binding.getClassType();
    final String reqBoundProperty = binding.getProperty();
    if (reqBoundType == null || reqBoundProperty == null) {
      throw new RuntimeException("This can ont happen " + reqBoundType + "/" + reqBoundProperty);
    }


    if (responsibleForSelectionType.equals(reqBoundType) && responsibleForSelectionType.equals(typeOfIterestedInSelection)) {
      if (!(reqBoundProperty.equals(""))) {
        throw new RuntimeException("This can not happen.");
      }

      // * might be a FormDelegate
      // * might be a Table not bound to a property
      //   - in case of root list, typed invoice, table not bound but just child on invoice
      //   - some strange case where table is not root list, but still not bound by a property? an error?
      // 
      // this view is only interested in selection updates. that s the only thing we can provide anyway.
      if (uxElemToRegister != null) {
        ListSequence.fromList(attachedGenElems).addElement(uxElemToRegister);
      }

      return this;



    } else if (responsibleForSelectionType.equals(reqBoundType)) {
      // This controller is the parentController to the interestedInSelectoinType.
      // a binding has to be available
      if (reqBoundProperty.equals("")) {
        throw new RuntimeException("This can not happen.");
      }

      // no double registration, is there a container for binding and selectionType
      SelectionController newController = ListSequence.fromList(dependentSelectionController).findFirst((it) -> {
        // obviously boundToType on dependend Selection Controllers is reqBoundType !
        // selection type somehow redundant, since property with propertyName must lead to same final type
        return it.boundToType.equals(reqBoundType) && it.boundToProperty.equals(reqBoundProperty) && it.responsibleForSelectionType.equals(typeOfIterestedInSelection);
      });


      if (newController != null) {
        if (uxElemToRegister != null) {
          ListSequence.fromList(newController.attachedGenElems).addElement(uxElemToRegister);
        }
        return newController;

      } else {
        newController = new SelectionController(pagePaneCrtl, this, typeOfIterestedInSelection, reqBoundProperty);
        ListSequence.fromList(dependentSelectionController).addElement(newController);
        if (uxElemToRegister != null) {
          ListSequence.fromList(newController.attachedGenElems).addElement(uxElemToRegister);
        }
        return newController;
      }

    }

    // New Strategy introduced NOV 22: can we attach down in the hierarchy of the last one? - - - - - - - 
    if (PagePaneSelCrtl.NEW22_STRATEGY) {
      SelectionController candidate = pagePaneCrtl.lastSelCrtlAttachedTo;
      pagePaneCrtl.lastSelCrtlAttachedTo = null;

      if (candidate != null) {
        ISelectionController selCrtl = null;

        while (selCrtl == null && candidate != candidate.pagePaneCrtl) {
          selCrtl = candidate.registerSelControlled(typeOfIterestedInSelection, binding, uxElemToRegister);
          candidate = candidate.parentcontroller;
        }
        if (selCrtl != null) {
          return selCrtl;
        }
      }
    }
    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

    // The old fall back strategy  
    for (SelectionController net : ListSequence.fromList(dependentSelectionController).reversedList()) {
      // stop when one found ...
      ISelectionController selCrtl = net.registerSelControlled(typeOfIterestedInSelection, binding, uxElemToRegister);
      if (selCrtl != null) {
        return selCrtl;
      }
    }

    return null;
  }



  protected void pushSelection(IOFXSelection newSelection, final boolean andLoad) {

    if (newSelection.getType().equals(responsibleForSelectionType)) {
      // if selection is different - clear others ...
      if (newSelection.equals(selection)) {
        //  do nothing .. selection not changed

      } else {
        selection = newSelection;
        final Wrappers._boolean selectionFound = new Wrappers._boolean(true);

        ListSequence.fromList(attachedGenElems).visitAll(new _FunctionTypes._void_P1_E0<IGenSelControlled>() {
          public void invoke(IGenSelControlled it) {
            boolean thisOneChanged = it.selectionChanged(selection, !(andLoad));
            selectionFound.value = selectionFound.value && thisOneChanged;
          }
        });

        if (!(selectionFound.value)) {
          // clear selection of this controller ..
          selection = new Selection(responsibleForSelectionType);
          ListSequence.fromList(attachedGenElems).visitAll(new _FunctionTypes._void_P1_E0<IGenSelControlled>() {
            public void invoke(IGenSelControlled it) {
              it.selectionChanged(selection, !(andLoad));
            }
          });
        }

        // update child controllers?
        if (ListSequence.fromList(dependentSelectionController).count() > 0) {


          // notify childs. reload ?
          if (selection != null && selection.isSingleObject() && andLoad && selectionFound.value) {
            ListSequence.fromList(dependentSelectionController).visitAll((dvc) -> dvc.load(selection.getObjectOrNull()));
          } else {
            ListSequence.fromList(dependentSelectionController).visitAll((dvc) -> dvc.load(null));
          }
        }
      }
    }

    // populate it anyway, dan 20.4.2012
    for (SelectionController net : dependentSelectionController) {
      net.pushSelection(newSelection, andLoad);
    }
  }
  public boolean isDrvdSuitable(boolean expected, Class baseClass) {
    if (expected) {
      return baseClass.isAssignableFrom(responsibleForSelectionType);
    }
    return false;
  }
  protected IOFXSelection getSelection(Class type, boolean includingDerived) {
    if (type.equals(responsibleForSelectionType) || isDrvdSuitable(includingDerived, type)) {
      return selection;
    }


    // ok, check if a child of ours offers a selection
    IOFXSelection sel = null;
    for (SelectionController ctr : dependentSelectionController) {
      sel = ctr.getSelection(type, includingDerived);
      if (sel != null) {
        if (pagePaneCrtl.COLLECT_SELECTIONS && sel.isEmpty()) {
          // proceed to check if we can get a selection from somewhere else
        } else {
          return sel;
        }
      }
    }

    // no child selection found?
    return sel;
  }

  public IOFXSelection getSelectionAbsolute(Class type, boolean includingDerived) {
    // changed by dan, Test March 2013
    // search only downwards the hierachy for selection
    // local selection first

    IOFXSelection sel = null;
    if (type.equals(responsibleForSelectionType) || isDrvdSuitable(includingDerived, type)) {
      sel = this.selection;
    }
    if (sel == null && parentcontroller != null) {
      sel = parentcontroller.getSelectionAbsolute(type, includingDerived);
    }

    return sel;
  }

  public void pushSelectionAbsolute(IOFXSelection selection) {
    // changed by dan, Test March 2013
    // push only downwards the hierachy for selection

    // (1) push it to root
    // (2) if not selectable in current list,
    // (3) do not load childs ...


    pagePaneCrtl.pushSelectionAbsolute(selection);


  }


  public void issueUpdateConclusion(IUpdateConclusionReceiver.IFocusAbleDelegate issuer) {
    pagePaneCrtl.issueUpdateConclusion(issuer);
  }

  public void clearSelection() {
    selection = new Selection(responsibleForSelectionType);

    ListSequence.fromList(dependentSelectionController).visitAll((it) -> it.load(null));

    // changed by dan from first, to second to this version. ..

    // third version @5.3.2013, do not push it to rooDataLoader
    // since selection on all views will be cleared then ..

  }
  protected void load(Object parentObject) {
    if (parentObject == null) {
      // e.g. master detail change ..
      clearSelection();
      ListSequence.fromList(attachedGenElems).visitAll(new _FunctionTypes._void_P1_E0<IGenSelControlled>() {
        public void invoke(IGenSelControlled it) {
          it.loadList(ListSequence.fromList(new ArrayList<Object>()), selection);
        }
      });

    } else if (parentObject.getClass().equals(boundToType)) {

      // normal change - just load new list and check if selection is contained in new list ...
      // 2. Aprl.15 - MPS 3.2 list wrapper problems, just drawing on java lists instead.
      final Wrappers._T<List<Object>> listToLoad = new Wrappers._T<List<Object>>();
      try {
        listToLoad.value = (List<Object>) MoJSON.get(parentObject, boundToProperty);
      } catch (ClassCastException ex) {
        listToLoad.value = new ArrayList<Object>();
        listToLoad.value.add(((Object) MoJSON.get(parentObject, boundToProperty)));
      }

      if (!(selection.isContainedIn(listToLoad.value))) {
        clearSelection();
      }

      ListSequence.fromList(attachedGenElems).visitAll(new _FunctionTypes._void_P1_E0<IGenSelControlled>() {
        public void invoke(IGenSelControlled it) {
          it.loadList(listToLoad.value, selection);
        }
      });
    }
  }
  protected void reload(Object parentObject) {
    load(parentObject);
    if (selection != null && selection.isSingleObject()) {
      ListSequence.fromList(dependentSelectionController).visitAll((it) -> it.reload(selection.getObjectOrNull()));
    } else {
      ListSequence.fromList(dependentSelectionController).visitAll((it) -> it.reload(null));
    }

  }

  public IOFXSelection getLocalSelection() {
    return selection;
  }
  @Override
  public String toString() {
    return "SelCrtl " + ((boundToType == null ? "(null)" : boundToType.getSimpleName())) + "." + boundToProperty + " => " + responsibleForSelectionType.getSimpleName();
  }

  public String getControllersInfo() {
    final StringBuilder builder = new StringBuilder();

    builder.append("\n--- " + this.toString() + "  SELECTION: " + selection + "\n");
    builder.append("  registered gen_elems: ");
    ListSequence.fromList(attachedGenElems).visitAll(new _FunctionTypes._void_P1_E0<IGenSelControlled>() {
      public void invoke(IGenSelControlled it) {
        builder.append(it.getClass().getSimpleName() + ", ");
      }
    });
    builder.append("\n");
    ListSequence.fromList(dependentSelectionController).visitAll((it) -> builder.append(it.getControllersInfo().replace("\n", "\n  ")));
    return builder.toString();
  }

  public String issueSaveAndValidate() {
    final Wrappers._T<String> firstMessage = new Wrappers._T<String>(null);

    ListSequence.fromList(attachedGenElems).visitAll(new _FunctionTypes._void_P1_E0<IGenSelControlled>() {
      public void invoke(IGenSelControlled it) {
        String current = it.saveAndValidate();
        if (firstMessage.value == null && current != null) {
          firstMessage.value = current;
        }
      }
    });

    ListSequence.fromList(dependentSelectionController).visitAll((it) -> {
      String current = it.issueSaveAndValidate();
      if (firstMessage.value == null && current != null) {
        firstMessage.value = current;
      }
    });
    return firstMessage.value;
  }
  public List<IDelegateChange> collectDelegateChanges() {
    final Wrappers._T<List<IDelegateChange>> allChanges = new Wrappers._T<List<IDelegateChange>>(null);

    ListSequence.fromList(attachedGenElems).visitAll(new _FunctionTypes._void_P1_E0<IGenSelControlled>() {
      public void invoke(IGenSelControlled it) {
        List<IDelegateChange> changes = it.collectDelegateChanges();
        if (changes != null) {
          if (allChanges.value == null) {
            allChanges.value = changes;
          } else {
            ListSequence.fromList(allChanges.value).addSequence(ListSequence.fromList(changes));
          }
        }
      }
    });

    ListSequence.fromList(dependentSelectionController).visitAll((it) -> {
      List<IDelegateChange> changes = it.collectDelegateChanges();
      if (changes != null) {
        if (allChanges.value == null) {
          allChanges.value = changes;
        } else {
          ListSequence.fromList(allChanges.value).addSequence(ListSequence.fromList(changes));
        }
      }
    });
    return allChanges.value;
  }



  public void forceNotEditable() {
    ListSequence.fromList(attachedGenElems).visitAll(new _FunctionTypes._void_P1_E0<IGenSelControlled>() {
      public void invoke(IGenSelControlled it) {
        it.forceNotEditable();
      }
    });
    ListSequence.fromList(dependentSelectionController).visitAll((it) -> it.forceNotEditable());
  }
  private void logStdout(String text) {
    if (DEBUG) {
      if (CHECKING_FOR.equals(responsibleForSelectionType.getName())) {
        System.err.println("SELCRTL " + responsibleForSelectionType.getName() + " (" + boundToProperty + "): " + text);

      }
    }
  }

  public void preDelayedAfterFullUiInitialized() {
    ListSequence.fromList(attachedGenElems).visitAll(new _FunctionTypes._void_P1_E0<IGenSelControlled>() {
      public void invoke(IGenSelControlled it) {
        it.preDelayedAfterFullUiInitialized();
      }
    });
    ListSequence.fromList(dependentSelectionController).visitAll((it) -> it.preDelayedAfterFullUiInitialized());
  }


  public void gcClear() {
    ListSequence.fromList(this.dependentSelectionController).visitAll((it) -> it.gcClear());
    ListSequence.fromList(this.attachedGenElems).visitAll(new _FunctionTypes._void_P1_E0<IGenSelControlled>() {
      public void invoke(IGenSelControlled it) {
        it.gcClear();
      }
    });
    ListSequence.fromList(this.attachedGenElems).clear();
    this.attachedGenElems = null;
  }
}
