package org.modellwerkstatt.dataux.runtime.core;

/*Generated by MPS */

import java.util.concurrent.BlockingQueue;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Window;
import java.util.concurrent.LinkedBlockingQueue;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.IOFXCmdModule;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXCommand;
import org.modellwerkstatt.dataux.runtime.sdicore.ApplicationSDI;
import org.modellwerkstatt.objectflow.runtime.IOFXDynCmdParams;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_CommandContainerUi;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Form;

public class WindowController extends WindowReporter implements IWindowController {

  private BlockingQueue<UxEvent> windowEvents;
  private boolean inEventLoop;

  protected MultiCmdStart multiActEvent;
  protected ICommandContainer currentMultiActContainer;


  public WindowController(IToolkit_UiFactory uf, IApplication theApp, IToolkit_Window win) {
    super(uf, win, theApp);
    windowEvents = new LinkedBlockingQueue<UxEvent>(10);
  }

  public void receiveAndProcess(UxEvent ev) {
    windowEvents.add(ev);

    // we have a message to process, rock on...
    if (!(inEventLoop)) {
      processPendingEvents();
    }
  }

  public synchronized void processPendingEvents() {
    UxEvent eventToProcess = null;
    try {
      inEventLoop = true;

      if (windowEvents.size() == 0) {
        app.logFrmwrkProblem("", "", IOFXCoreReporter.APP, "processPendingEvents() in AppEventBridge called without any events to process.", null);
      }

      while (windowEvents.size() > 0) {
        eventToProcess = windowEvents.take();
        app.logMowareTracing("", "", IOFXCoreReporter.EVENT, eventToProcess.name(), eventToProcess.paramInfo());

        if (eventToProcess instanceof BasisCmdStart) {
          startCommandByEvent(((BasisCmdStart) eventToProcess));

        } else if (eventToProcess instanceof MultiCmdStart) {
          if (isMultiAction()) {
            throw new RuntimeException("Can not start Multi while processing multi: " + eventToProcess + " but processing " + multiActEvent);
          }
          multiActEvent = ((MultiCmdStart) eventToProcess);
          currentMultiActContainer = null;
          handleMultiStartEvent();

        } else {
          throw new RuntimeException("Unknown event " + eventToProcess);

        }
      }

    } catch (final Exception t) {
      this.showException(WindowController.class.getName(), "", "Exception in processPendingEvents()", "" + eventToProcess, t, null);

    } finally {
      inEventLoop = false;

    }
  }


  public void sameInstanceRunningUserNotification() {
    // noop
  }

  public void startCommandByEvent(BasisCmdStart ev) {
    boolean startIt = true;
    IOFXCmdModule module = uiFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName(ev.getCommandName()));
    Object[] params = ev.getParams();
    ICommandContainer parent = ev.getParentContainer();
    IOFXSession parentSession = null;

    if (parent != null) {
      parentSession = parent.getSession();
    }

    if (app.isApplicationModalTabMode() && module.isCommandType(ev.getCommandName(), IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD, IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD_MODAL, IOFXCommand.OFXCmdTyp.SEARCH_CMD)) {
      throw new RuntimeException("When a modal tab is opened, only GRAPH_EDIT commands can be started. This is a programming error.");
    }


    // Do not open same command twice. i.e. check cmd FQ Name and params ..
    if (!(isMultiAction())) {
      // not in multi action mode..
      // already opened ?? check only commands in tabs -> graph owners
      startIt = !(app.isSameInstanceRunningThenFocus(ev.getCommandName(), params));
      if (!(startIt)) {
        sameInstanceRunningUserNotification();
      }

    }

    // new version to switch onto?
    if (!(isMultiAction()) || (isMultiAction() && multiActEvent.willBeFirstExecution())) {
      if (app.checkForAppParDeploymentForward()) {
        stopMultiActionIfOne();
        startIt = false;
      }
    }

    boolean startNewWindow = app instanceof ApplicationSDI && !(ev.isForcedToThisWindowCrtl()) && !(isMultiAction()) && !(module.isCommandType(ev.getCommandName(), IOFXCommand.OFXCmdTyp.GRAPH_EDIT_CMD)) && module.supportUrlDefaultParams(ev.getCommandName());

    if (startIt && !(startNewWindow)) {

      // else, start command now.
      IOFXCommand cmd = module.startCommand(IOFXCmdModule.CmdExecStrategy.SINGLE, ev.getCommandName(), params, parentSession, app.getUserEnvironment(), app.getUserService());

      ICommandContainer container = uiFactory.createCommandContainer();
      container.initContainer(uiFactory, app, this, parent, ev, cmd.getCommandSession().getSessionLoggingId());

      if (isMultiAction() && currentMultiActContainer == null) {
        // first execution of mutli
        currentMultiActContainer = container;
      }

      boolean inBackground = uiFactory.useBackgroundThread() && (cmd.isCommandType(IOFXCommand.OFXCmdTyp.SEARCH_CMD, IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD, IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD_MODAL) || cmd.hasOption(IOFXCommand.OFXCmdOptions.BACKGROUND));

      app.addToContainerRecorder(container);
      container.receiveAndProcess(new InitCmdEvent(inBackground, cmd, params));

    } else if (startIt) {
      ((ApplicationSDI) app).startWithNewCrtl(window, ev);

    }
  }

  public boolean isMultiAction() {
    return multiActEvent != null;
  }

  public void handleMultiStartEvent() {

    if (!(multiActEvent.isLast())) {

      if (!(multiActEvent.isFastExecNoUi())) {
        Object nextSelection = multiActEvent.getCurrentLocalSelection();
        multiActEvent.getParentContainer().receiveAndProcess(new PushSelEvent(nextSelection));

      }

      Object[] params;
      if (multiActEvent.hasNonDefaultParamProvider()) {
        IOFXDynCmdParams paramProvider = multiActEvent.getNonDefaultParamProvider();
        params = paramProvider.calc(multiActEvent.getLocalSelCrtl(), multiActEvent.getCurrentLocalSelection());

      } else {
        IOFXCmdModule cmdModule = uiFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName(multiActEvent.getCommandName()));
        params = cmdModule.getCommandDefaultParams(multiActEvent.getCommandName(), multiActEvent.getLocalSelCrtl(), multiActEvent.getCurrentLocalSelection());

      }
      BasisCmdStart startEvent = multiActEvent.getParameterizedStartEvent(params);
      multiActEvent.incExecutions();
      receiveAndProcess(startEvent);

    } else {
      stopMultiActionIfOne();

    }

  }

  public void stopMultiActionIfOne() {
    // garcefully, can be called all times.
    if (isMultiAction()) {
      multiActEvent.gcClean();
      currentMultiActContainer = null;
      multiActEvent = null;
    }
  }

  @Override
  public void showException(String cmdOrComponent, String sessId, String reason, String contextInformation, Throwable throwable, IApplication.DlgRunnable run) {
    stopMultiActionIfOne();
    super.showException(cmdOrComponent, sessId, reason, contextInformation, throwable, run);
  }

  @Override
  public void askCloseQuestionDialog(String question, IApplication.DlgRunnable run) {
    stopMultiActionIfOne();
    super.askCloseQuestionDialog(question, run);
  }
  @Override
  public void showGraphDebugger(List<Object> graph, String controllerInformation) {
    stopMultiActionIfOne();
    super.showGraphDebugger(graph, controllerInformation);
  }

  public void commandClosed(GlobalCmdTermEvent termEvent) {
    app.removeFromContainerRecorder(termEvent.getClosedContainer());

    ICommandContainer parent = termEvent.getParentOfClosed();

    if (isMultiAction() && multiActEvent.isFastExecNoUi() && termEvent.wasOk() && !(multiActEvent.isLast())) {
      termEvent.setNotReloadViewsOnParent();
    }

    // GE with no ui started from GE
    boolean parentFound = app.distributeTermEventOnRecorder(termEvent);

    if (isMultiAction()) {
      // Termination of GE or of GO here !!

      if (!(multiActEvent.getParentContainer().isStillOkayAsParentForMultiExecution())) {
        // stop multiprocessing, might be a flag of GO with GO showing it
        stopMultiActionIfOne();

      } else if (currentMultiActContainer == termEvent.getClosedContainer()) {
        boolean startNext = (termEvent.wasOk() || (multiActEvent.isGoOnWhenCanceled() && termEvent.wasCancelOrUserCancel()));

        if (startNext) {
          currentMultiActContainer = null;
          handleMultiStartEvent();

        } else {
          // Stop multiprocessing
          stopMultiActionIfOne();

        }


      } else {
        // nothing to do?

      }

    }

    if (!(parentFound) && parent != null) {
      if (parent.isAutoConNoUi()) {
        // okay, GO in auto con and not displayed ...

      } else {
        // Parent already closed. Eg. GE Printing takes some time, user closes GO in between...
        app.logFrmwrkProblem("", "", IOFXCoreReporter.APP, "Parent " + parent + " not found as tab/prompt of " + termEvent.getClosedContainer().toString(), OFXConsoleHelper._____organizeCurrentStacktrace_____());
      }

      parent.receiveAndProcess(termEvent);
    }
  }

  @Override
  public void showCommandContainerUI(ICommandContainer cc, IToolkit_CommandContainerUi ui, String windowTitle, IToolkit_Form content) {
    throw new RuntimeException("Not implemented in plain WindowController");
  }
  @Override
  public void closeCommandContainerUI(ICommandContainer cc, IToolkit_CommandContainerUi ui, ICommandContainer parent) {
    throw new RuntimeException("Not implemented in plain WindowController");
  }
  @Override
  public void focusTab(ICommandContainer cc, IToolkit_CommandContainerUi ui) {
    throw new RuntimeException("Not implemented in plain WindowController");
  }

  @Override
  public void internal_immediatelyShutdown() {
    throw new RuntimeException("Not implemented right now [SMR 24]");
  }
  public IOFXSession getSession() {
    // mainMenuEvalSession
    return app.getMainWindowEvalSession();
  }
}
