package org.modellwerkstatt.dataux.runtime.core;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Window;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_MainWindow;
import java.util.List;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.Workarounds2;

public class WindowReporter {
  protected IToolkit_UiFactory uiFactory;
  protected IToolkit_Window window;
  protected IApplication app;

  public WindowReporter(IToolkit_UiFactory factory, IToolkit_Window win, IApplication theApp) {
    window = win;
    uiFactory = factory;
    app = theApp;
  }

  public void showException(String cmdOrComponent, String sessId, String reason, String contextInformation, Throwable throwable, IApplication.DlgRunnable run) {

    String message = app.reportException(cmdOrComponent, sessId, reason, contextInformation, throwable);

    if (uiFactory.isSilentExLogging()) {
      window.showDialog(IToolkit_MainWindow.DlgType.ERROR_SMALL, message, run);

    } else {
      window.showDialog(IToolkit_MainWindow.DlgType.ERROR_LARGE, message, run);
    }
  }

  public void showSimpleInfoDialog(String info, IApplication.DlgRunnable run) {
    window.showDialog(IToolkit_MainWindow.DlgType.INFO_SMALL, info, run);
  }
  public void showProblemsDialog(List<IOFXProblem> problems, IApplication.DlgRunnable run) {
    problems = Workarounds2.limitProblemsTo(15, problems);
    window.showProblemsDialog(problems, run);
  }
  public void showBigInformationDialog(String info, IApplication.DlgRunnable run) {
    window.showDialog(IToolkit_MainWindow.DlgType.INFO_LARGE, info, run);
  }
  public void askCloseQuestionDialog(String question, IApplication.DlgRunnable run) {
    window.showDialog(IToolkit_MainWindow.DlgType.QUESTIONCLOSE_SMALL, question, run);
  }
  public void showGraphDebugger(List<Object> graph, String controllerInformation) {
    window.showGraphDebugger(graph, controllerInformation);
  }
  public void setToastInformation(String msg) {
    // might also be published
    window.setToastMessage(msg);
  }
}
