package org.modellwerkstatt.dataux.runtime.delegates;

/*Generated by MPS */

import org.joda.time.DateTime;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_DateOrTimeEditor;
import org.joda.time.format.DateTimeFormatter;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;

public class DateTimeDateDelegate extends Delegate<DateTime, IToolkit_DateOrTimeEditor> {
  private DateTimeFormatter formatter;
  private String format;




  public DateTimeDateDelegate(IToolkit_UiFactory factory, int langIdx, IToolkit_TextEditor.Option... pickerOption) {
    super(factory, langIdx);
    formatter = factory.getTransProvider().getLocalDateFormatter(langIdx, null);
    format = factory.getTransProvider().getDefaultLocalDateFormat();

    boolean needsPicker = IToolkit_TextEditor.has(IToolkit_TextEditor.Option.ALTER_PICKER, pickerOption);

    toolkitEditor = factory.createDateEditor(needsPicker);
    toolkitEditor.setDelegate(this);
    toolkitEditor.setFormatter(format, formatter.getLocale().toLanguageTag(), langIndex);
    toolkitEditor.setEditorPrompt(DateTimeDelegate.convertFormatToPromptString(format));
  }

  public DateTime getValue() {
    if (isCurrentlyInOptionalState()) {
      return null;
    }
    try {
      return formatter.parseDateTime(toolkitEditor.getText());

    } catch (Exception ex) {
      throw new RuntimeException(ex);
    }
  }
  public void setValue(DateTime value) {
    if (value != null) {
      toolkitEditor.setText(formatter.print(value));

    } else {
      toolkitEditor.setText("");
    }
  }


  public String isInputValid() {
    if (!(enabled.getValue())) {
      return null;
    }
    toolkitEditor.setValidationErrorText("");

    try {
      if (this.isCurrentlyInOptionalState()) {
        return null;
      }

      String val = toolkitEditor.getText();

      formatter.parseDateTime(val);
      return null;


    } catch (Exception ex) {
      // ex in parseDateTime
    }

    String errText = String.format(uiFactory.getSystemLabel(langIndex, MoWareTranslations.Key.DATE_VALIDATION_ERR), format);
    toolkitEditor.setValidationErrorText(errText);
    return errText;
  }



  @Override
  public void setFormat(String frmt) {
    // overwrite that .. if necessary ??..
    if (frmt == null || "".equals(frmt.trim())) {
      // nothing .. skip it ..

    } else {
      format = frmt;
      formatter = uiFactory.getTransProvider().getLocalDateFormatter(langIndex, format);
      toolkitEditor.setFormatter(format, formatter.getLocale().toLanguageTag(), langIndex);
      toolkitEditor.setEditorPrompt(DateTimeDelegate.convertFormatToPromptString(format));
      setEnabled(false);
    }
  }
}
